#version 330 core

#define MAX_LIGHTS 4

#define LIGHT_DIRECTIONAL 1
#define LIGHT_POINT 2
#define LIGHT_SPOT 3

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 vertexTexCoord;
layout(location = 2) in vec3 vertexNormal;
layout(location = 3) in vec4 vertexColor;

out vec4 shadowPosition;
out vec2 texCoord;
out vec4 vertexFragColor;
out vec3 normal;
out vec3 lightDirection;
out vec3 eye;

uniform mat4 mvp;
uniform mat4 shadowMvp;
uniform mat3 normalMatrix;
uniform mat4 view;
uniform mat4 model;
uniform mat4 projection;

uniform int activeLightCount = 0;

struct Camera {
    vec3 position;
};
uniform Camera camera = Camera(vec3(0,3,3));

void main(void)
{
    vec4 position = vec4(vertexPosition, 1);
    gl_Position = mvp * position;
    shadowPosition = shadowMvp * position;

    texCoord = vertexTexCoord;
    vertexFragColor = vertexColor;
} 
