#version 330 core

in vec2 texCoord;
out vec4 fragColor;

uniform sampler2D texture0; 
uniform sampler2D texture1; // fft

uniform float intensity = 1.0;
uniform float zoom = 10.0;

uniform vec3 iResolution;

uniform vec4 color = vec4(1);

uniform float pixelX = 0.01;
uniform float pixelY = 0.01;

vec2 pixelate(vec2 coord)
{
    vec2 d = vec2(1.0,1.0)/(iResolution.xy*vec2(pixelY,pixelX));
    coord.s = floor(coord.s/d.s)*d.s;
    coord.t = floor(coord.t/d.t)*d.t;
    return coord;    
}

void main()
{
    if (texCoord.y>0.5) {discard;}
    float c = texture2D(texture1, pixelate(texCoord.yx)).r;
    c = c > 0.01 ? 1.0 : 0.0;

    fragColor.rgb = vec3(c);
    fragColor.a = c;

    fragColor *= color;
}
