#version 330 core

in vec2 texCoord;
out vec4 fragColor;

uniform sampler2D texture0; // mask bg 
uniform sampler2D texture1; // film material

uniform vec3 iResolution;
uniform vec4 color = vec4(1);
uniform float time;

void starfield() {
    vec2 coord = texCoord;


    vec3 tcol = texture(texture0, texCoord).rgb;
    float lightness = (tcol.r+tcol.g+tcol.b)/3.0;
    coord.s += (sin(coord.t*8.0 + lightness*5.0)*0.062)*(coord.t-0.5);
    coord.t += (cos(coord.s*50.0 + lightness*3.3)*0.065)*(coord.t-0.5);

    vec2 position = ( coord.xy)-vec2(0.5,0.5);
    //position.y *= -1.0;

    // 256 angle steps
    float angle = atan(position.y,position.x)/(2*3.14159265359);
    angle -= floor(angle);
    float rad = length(position);
    
    float color1 = 0.0;
    for (int i = 0; i < 2; i++) {
        float angleFract = fract(angle*36.);
        float angleRnd = floor(angle*360.)+1.;
        float angleRnd1 = fract(angleRnd*fract(angleRnd*.7235)*45.1);
        float angleRnd2 = fract(angleRnd*fract(angleRnd*.82657)*13.724);
        float t = time+angleRnd1*100.;
        float radDist = sqrt(angleRnd2+float(i));
        
        float adist = radDist/rad*1.5;
        float dist = (t*.2+adist);
        dist = abs(fract(dist)-.1);
        color1 += max(0.,.8-dist*100./adist)*(.5-abs(angleFract-.5))*5./adist/radDist;
        
        angle = fract(angle);
    }
    
    if (texture(texture0, texCoord).a <= 0.0) {
        //discard;
    }

    fragColor.rgb = vec3(color1);
    fragColor.rgb *= 0.15;
    fragColor += texture(texture0, texCoord);
    fragColor.rgb *= 0.25;

    //fragColor *= vec4(color1);
    fragColor *= color;
}

void main()
{
    starfield();

    //fragColor = texture(texture0, texCoord) * color;
}
