#version 400
precision mediump float;

varying vec4 col;					//colorization
varying vec3 wBin;					//worldspace binormal
varying vec3 wTan;					//worldspace tangent
varying vec3 wNrm;					//worldspace normal
varying vec3 wPos;					//worldspace position (actually, model-space) 
varying vec2 uv;					//texture coordinates
varying vec3 eyeN;					//eye to point 'normal' in worldSpace
varying vec4 ssNrm;					//screenspace normal

//noperspective in vec4 ssUV;		//doesn't seem to work on Intel GPU.
varying vec4 fPos;					//frustum position to compute UV of the current pixel in screenspace [0..1]

uniform samplerCube texcube0;		//light probe
uniform sampler2D tex1,tex2,tex3,tex4;	//albedo+illum, normal+height, shine+metal+ao, reflexion+depth

uniform mat4 matN, matP, matM;

vec2 getUV()
{
	const float TILE_SZ = 1.f/16.f;
	vec2 uv;
	vec3 nrm = abs(wNrm);

	//version with clamp instead of if
/*	vec3 nrm = abs(wNrm+.5f);
	nrm/=max(max(nrm.x,nrm.y),nrm.z)-.00001f;	//-.001 to make sure 1 casts to 1
	uv = int(nrm.x) * wPos.zy * TILE_SZ +
		 int(nrm.y) * wPos.zx * TILE_SZ +
		 int(nrm.z) * wPos.xy * TILE_SZ;
*/
	if(nrm.x>0.5)	uv = wPos.zy/16.0;	else
	if(nrm.y>0.5)	uv = wPos.zx/16.0;	else
	if(nrm.z>0.5)	uv = wPos.xy/16.0;

	return uv;
}

vec4 AddFog(vec4 col)
{
	float fog	 = pow(clamp(gl_FragCoord.z,0.f,1.f),10.f);
	vec3  fogCol = vec3(0.f,.25f,0.f);
	col.rgb = mix(col.rgb, fogCol, fog);

	return	col;
}

vec4 get_reflection(vec3 refN, float diff);

void main()
{
//	gl_FragColor = textureLod(texcube0, reflect(eyeN,wNrm)*vec3(-1,-1,1),1);
//	return;

//	vec2 uv = getUV();
	vec4 col = texture2D(tex1,uv*1);
	vec3 nrm = texture2D(tex2,uv*1).rgb -.5;
	vec3 pbr = texture2D(tex3,uv*1).rgb;

	//to gamma, to HDR
	col*=col;
	//normals and pbr are stored linear already

	//normal map ------------

	//mrn.b as HEIGHT -- better to ue that anyway, so we don't flip normals from the texture
	float h = nrm.z;
	nrm.z = sqrt(1-dot(nrm.xy,nrm.xy));

	nrm =	wNrm * nrm.z +	//TODO: use matrix?
			wBin *-nrm.y +	//somehow X and Y are inverted.
			wTan *-nrm.x;

//--MATERIAL OVERRIDE-- BEGIN
//	nrm = wNrm;				//disable normal map
//	nrm = mix(wNrm,nrm,0.25f);	//scale down normals
//--MATERIAL OVERRIDE-- END

	vec3 refN = reflect(eyeN,nrm);
	float nrmZ = clamp(-dot(nrm,eyeN),0,1);

//	if(-dot(nrm,eyeN)<0)
//	{
//		gl_FragColor = vec4(1.0,0.0,0.0,1.0);
//		return;
//	}

	/*
	refN : worldspace reflection vector, needed as the cubemap is world-aligned
	wNrm : worldspace normal, needed for reflected vector
	wBin : worldspace binormal, for normal mapping
	wTan : worldspace tangent
	nrmZ : length in Z of the normal in screenspace, for fresnel
	*/

//--MATERIAL TESTS-- BEGIN
//	col = vec4(.7,.1,.1,0);	//all red, no self-illum
//	pbr = vec3(0,1,1);		//metal, sharp, no AO
//--MATERIAL TESTS-- END

//--MATERIAL OVERRIDE-- BEGIN
//	pbr.z = 1;				//disable AO
//	col.a = 0;				//disable self-illum
//	col = vec4(1,1,1,0);
//	pbr = vec3(1,0,1);
//--MATERIAL OVERRIDE-- END


	float	plastic	= clamp(pbr.g*2,0,1);						//AKA dielectric, AKA non-Metal, >.5 == sss
	float	sss		= pbr.g*2 - plastic;						//sub-surface scattering
	float	spec	= (1-pbr.r) * 10.f;							//specularity, aka glossiness, aka how sharp reflection is - **lower means sharper**
	float	ao		= pow(pbr.b,.5);

	float	fresnel	= mix(pow(1-nrmZ,6),1,.04*plastic);			//4% reflectivity (or 0 if metal), up to 100% at the edges
	vec4	albedo	= vec4(col.rgb*(1-col.a),1);
	vec4	illum	= vec4(col.rgb*col.a,0);

//	vec4	diffuse	= textureLod(texcube0,refN*vec3(-1,-1, 1),mix(spec,9.5f,plastic));			//the more it's metal, the more it's a specular relfection
//	vec4	gloss	= textureLod(texcube0,refN*vec3(-1,-1, 1),spec*(1-fresnel)) * (1-col.a);	//no gloss if it's self-illum

//	vec4	ssr = get_reflection(refN,spec);
//	gloss = mix(gloss,ssr,ssr.a);

	illum	*= 16;		//light has range of x16

// 	slightly more complex maths, for no much gain in fidelity
	vec3	difN	= mix(refN,nrm,mix(spec,9.5f,plastic)/10.f)*vec3(-1,-1, 1);
	vec3	glsN	= mix(refN,nrm,spec*(1-fresnel)/10.f)*vec3(-1,-1, 1);
	vec4	diffuse	= textureLod(texcube0,difN,mix(spec,9.5f,plastic));			//the more it's metal, the more it's a specular relfection
	vec4	gloss	= textureLod(texcube0,glsN,spec/* *(1-fresnel)*/) * (1-col.a);	//no gloss if it's self-illum

	gloss *=  4;	//just a boost. probably not really the right way to do it, but the skybox is pretty dark.
	diffuse*=  4;
	gl_FragColor	= vec4((mix(albedo*diffuse*ao,gloss,fresnel) + illum).rgb, gl_FragCoord.z);

	//gl_FragColor	= vec4(pow(clamp(gl_FragCoord.z,0.f,1.f),10.f));
	//gl_FragColor	= textureLod(texcube0,nrm,0)*4;
}

//----------------------------------------------------------------------------------
const float step		= 0.1f;
const float minRayStep	= 0.1f;
const float maxSteps	= 30;
const int	numBinarySearchSteps = 5;


vec3 BinarySearch(inout vec3 dir, inout vec3 hitCoord, inout float dDepth)
{
   float depth;

    vec4 projectedCoord;
 
    for(int i = 0; i < numBinarySearchSteps; i++)
    {

        projectedCoord = matP * vec4(hitCoord, 1.0);
        projectedCoord.xy /= projectedCoord.w;
        projectedCoord.xy = projectedCoord.xy * 0.5 + 0.5;
 
        depth = textureLod(tex4, projectedCoord.xy, 2).z;

 
        dDepth = hitCoord.z - depth;

        dir *= 0.5;
        if(dDepth > 0.0)
            hitCoord += dir;
        else
            hitCoord -= dir;    
    }

        projectedCoord = matP * vec4(hitCoord, 1.0);
        projectedCoord.xy /= projectedCoord.w;
        projectedCoord.xy = projectedCoord.xy * 0.5 + 0.5;
 
    return vec3(projectedCoord.xy, depth);
}

vec4 RayMarch(vec3 dir, inout vec3 hitCoord, out float dDepth)
{
	dir *= step;

	float depth;
	int steps;
	vec4 projectedCoord;

	for(int i=0;i<maxSteps;i++)
	{
		hitCoord += dir;

		projectedCoord = matP * vec4(hitCoord ,1.0);
		projectedCoord.xy/=projectedCoord.w;
		projectedCoord.xy = projectedCoord.xy*.5+.5;

		depth = textureLod(tex4, projectedCoord.xy, 2).z;
		if(depth> 1000)
			continue;

		dDepth = hitCoord.z - depth;
		
		if((dir.z - dDepth)<1.2)
		{
			if(dDepth <= 0)
			{
//				return vec4(projectedCoord.xy, depth, 1);
				return vec4(BinarySearch(dir, hitCoord, dDepth),1);
			}
		}

		steps++;
	}

	return vec4(projectedCoord.xy, depth, 0);
}

void main_y()
{
//	vec3 uv = vec3(fPos.xy/fPos.w *.5f+.5f,0);
//	uv.z = texture2D(tex4, uv.xy).a;
//	vec3 viewPos = fPos.xyz;

	vec3 viewPos = textureLod(tex4, fPos.xy/fPos.w *.5f+.5f, 2).xyz;

	vec3 reflected = normalize(reflect(normalize(viewPos),normalize(ssNrm.xyz)));
	vec3 hitPos = viewPos;
	float dDepth;

	gl_FragColor = vec4(normalize(viewPos), 1);
	return;

	vec4 coords = RayMarch(reflected * max(minRayStep, -viewPos.z), hitPos, dDepth);
	vec3 SSR = textureLod(tex4, coords.xy, 0).rgb * coords.a;
	//fade borders
	//pad with cubemap
	//mix with current material

	gl_FragColor = vec4(SSR, 1);
}

vec4 get_reflection(vec3 refN, float diff)
{
	const float q=2;	//quality factor. 0: perfect, 2:-2 mipmap level

	vec3 originalPos;
	float fNrmLen;

	//Normal in world space -> frustum space
//	vec3 refN = reflect(eyeN, wNrm);
	vec4 fPN = matP * matM * vec4(wPos + refN, 1);
	vec3 fNrm = fPN.xyz/fPN.w - fPos.xyz/fPos.w;
	fNrmLen = length(fNrm);

	//Scale to pixel
	const int maxStep = 30;
	fNrm/=max(abs(fNrm.x), abs(fNrm.y));
	fNrm*=.25f/maxStep;

	//Advance through screen
	vec3 uvw;
	uvw.xy = (fPos.xy/fPos.w)*.5f+.5f;
	uvw.z = textureLod(tex4, uvw.xy, q).a;

	int i = 0;
	for(; i < maxStep; i++)
	{
		uvw+=fNrm;
		if (textureLod(tex4, uvw.xy, q).a < uvw.z)
			break;
		if(uvw.z<0 || uvw.z>1 || uvw.x<0 || uvw.x>1 || uvw.y<0 || uvw.y>1)
		{
			return vec4(1,0,1,0);	//magenta.
		}
	}
	if(i == maxStep)
	{
		return vec4(0,1,1,0);	//cyan.
	}

	//Refine
	const int refStep = 5;
	float dir = -1;
	vec4 pix;
	for(int i=0; i < refStep; i++)
	{
		fNrm /= 2;
		uvw += fNrm*dir;
		dir = sign(textureLod(tex4, uvw.xy, 0).a - uvw.z);
	}

	float spec = diff * length(uvw.xyz - fPos.xyz/fPos.w)/2;

	return textureLod(tex4, uvw.xy, spec);
}