#version 140
precision mediump float;

attribute vec3 vpos;	//could use 'location()' in GL4 to set which attrib each var is
attribute vec4 vcol;	//else it's defined at shader-compile time
attribute vec2 vUV;
attribute vec3 vnrm;
attribute vec3 vtan;

varying vec4 col;
//varying vec3 nrm;
varying vec3 wBin;
varying vec3 wTan;
varying vec3 wNrm;
varying vec3 wPos;
varying vec2 uv;
varying vec3 eyeN;					//eye to point 'normal' in worldSpace
varying vec4 ssNrm;					//screen spac normal

varying vec4 fPos;

uniform mat4 matM,matMM,matP,matN;	//world,model,proj,normals

//OPTIM:	compute everything in tangent space
//			so that we don't have anything to compute in the .frag
//			can be done with a simple TBN matrix

void main()
{
	col = vcol;
	gl_Position = matP* matM* vec4(vpos,1.0);
//	nrm = (matN* vec4(vnrm,1.0)).xyz;
	wNrm = vnrm;
	wTan = vtan;
	wBin = cross(wTan,wNrm);
	uv = vUV;

	wPos = vpos;	//untransformed here since it's only for uv mapping

	//eye to vertex, in WorldSpace:	translation, no rot, 
	//								so full transform - rotation (normal matrix)
	eyeN = (inverse(matN)*matM*vec4(vpos,1)).xyz;
	eyeN = normalize(eyeN);

	/*{
		vec4 p = matP* matM* vec4(vpos,1.0);
		vec4 n = matP* matM* vec4(vpos+vnrm,1.0);
		
		ssNrm = n;// normalize(n.xyz/n.w - p.xyz/p.w);

		ssNrm = matN * vec4(vnrm,1.0);
	}*/

	fPos = gl_Position;
//	ssUV.xyz /= ssUV.w;
//	ssUV.xy = ssUV.xy *.5f+.5f;
}
