#version 400
precision mediump float;

varying vec4 col;					//colorization
varying vec3 wBin;					//worldspace binormal
varying vec3 wTan;					//worldspace tangent
varying vec3 wNrm;					//worldspace normal
varying vec3 wPos;					//worldspace position (actually, model-space) 
varying vec2 uv;					//texture coordinates
varying vec3 eyeN;					//eye to point 'normal' in worldSpace

varying vec4 fPos;					//gl_Position

uniform samplerCube texcube0;		//light probe
uniform sampler2D tex1,tex2,tex3;	//albedo+illum, normal+height, metal+shine+ao


vec2 getUV()
{
	const float TILE_SZ = 1.f/16.f;
	vec2 uv;
	vec3 nrm = abs(wNrm);

	//version with clamp instead of if
/*	vec3 nrm = abs(wNrm+.5f);
	nrm/=max(max(nrm.x,nrm.y),nrm.z)-.00001f;	//-.001 to make sure 1 casts to 1
	uv = int(nrm.x) * wPos.zy * TILE_SZ +
		 int(nrm.y) * wPos.zx * TILE_SZ +
		 int(nrm.z) * wPos.xy * TILE_SZ;
*/
	if(nrm.x>0.5)	uv = wPos.zy/16.0;	else
	if(nrm.y>0.5)	uv = wPos.zx/16.0;	else
	if(nrm.z>0.5)	uv = wPos.xy/16.0;

	return uv;
}

vec4 AddFog(vec4 col)
{
	float fog	 = pow(clamp(gl_FragCoord.z,0.f,1.f),10.f);
	vec3  fogCol = vec3(0.f,.25f,0.f);
	col.rgb		 = mix(col.rgb, fogCol, fog);

	return	col;
}

//faster version with no normal, and simplified maths (if possible)
//could try without fresnel, combine gloss/matte
void main()
{
//	vec2 uv = getUV();
	vec4 col = texture2D(tex1,uv);
	vec3 nrm = wNrm;					//no normal map
	vec3 pbr = texture2D(tex3,uv).rgb;	//do we need all the PBR params? probably better...

	//to gamma, to HDR
	col*=col;

	vec3  refN = reflect(eyeN,nrm);
	float nrmZ = clamp(-dot(nrm,eyeN),0,1);

//--USEFUL INFO--	
//	refN : worldspace reflection vector, needed as the cubemap is world-aligned
//	wNrm : worldspace normal, needed for reflected vector
//	wBin : worldspace binormal, for normal mapping
//	wTan : worldspace tangent
//	nrmZ : length in Z of the normal in screenspace, for fresnel


//--MATERIAL TESTS--
//	col = vec4(.7,.1,.1,0);	//all red
//	col.a = 0;
//	pbr = vec3(0,1,1);		//metal, sharp, no AO
//	pbr.z = 1;				//disable AO...

	float	plastic	= pbr.g;									//AKA dielectric, AKA non-Metal
	float	spec	= (1-pbr.r) * 10.f;							//specularity, aka glossiness, aka how sharp reflection is - **lower means sharper**
	float	ao		= pow(pbr.b,.5);

	float	fresnel	= mix(pow(1-nrmZ,6),1,.04*plastic);			//4% reflectivity (or 0 if metal), up to 100% at the edges
	vec4	albedo	= vec4(col.rgb*(1-col.a),1);
	vec4	illum	= vec4(col.rgb*col.a,0);

	vec4	diffuse	= textureLod(texcube0,refN*vec3(-1,-1, 1),mix(spec,9.5f,plastic));			//the more it's metal, the more it's a specular relfection
	vec4	gloss	= textureLod(texcube0,refN*vec3(-1,-1, 1),spec*(1-fresnel)) * (1-col.a);	//no gloss if it's self-illum

	//from non-linear LDR, to linear HDR
	//diffuse *= diffuse * 16;
	//gloss	*= gloss   * 16;

	illum	*=  16;		//light has range of x16

//	slightly more complex maths, for no much gain in fidelity
//	vec3	difN	= mix(refN,nrm,mix(spec,9.5f,plastic)/10.f)*vec3(-1,-1, 1);
//	vec3	glsN	= mix(refN,nrm,spec*(1-fresnel)/10.f)*vec3(-1,-1, 1);
//	vec4	diffuse	= textureLod(texcube0,difN,mix(spec,9.5f,plastic));	//the more it's metal, the more it's a specular relfection
//	vec4	gloss	= textureLod(texcube0,glsN,spec*(1-fresnel));

	gl_FragColor	= mix(albedo*diffuse*ao,gloss,fresnel) + illum;
//	gl_FragColor = col.aaaa;
	gl_FragColor.a	= gl_FragCoord.z;
}
