#version 400
//precision mediump float;

varying vec3 wNrm;
varying vec3 wPos;
varying vec2 uv;						//texture coordinates

//uniform samplerCube texcube0;			//light probe
uniform sampler2D tex1;//,tex2,tex3;	//albedo+illum, normal+height, metal+shine+ao

vec2 getUV()
{
	const float TILE_SZ = 1.f/16.f;
	vec2 uv;
	vec3 nrm = abs(wNrm);

	//version with clamp instead of if
/*	vec3 nrm = abs(wNrm+.5f);
	nrm/=max(max(nrm.x,nrm.y),nrm.z)-.00001f;	//-.001 to make sure 1 casts to 1
	uv = int(nrm.x) * wPos.zy * TILE_SZ +
		 int(nrm.y) * wPos.zx * TILE_SZ +
		 int(nrm.z) * wPos.xy * TILE_SZ;
*/
	if(nrm.x>0.5)	uv = wPos.zy/16.0;	else
	if(nrm.y>0.5)	uv = wPos.zx/16.0;	else
	if(nrm.z>0.5)	uv = wPos.xy/16.0;

	return uv;
}

void main()
{
	//vec2 uv = getUV();

	//keep everything non-linear to preserve all info
	//NOT switch to linear HDR!!
	vec4 col = texture2D(tex1,uv);
	col.rgb *= col.rgb;
	col.a *= 16;
	gl_FragColor = vec4(col.rgb*col.a, gl_FragCoord.z);		//what's best, multiply here or in the next shader pass?
}
