#version 120
precision mediump float;

varying vec4 col;
varying vec2 uv;

uniform sampler2D tex0;

vec3 correct3(vec3 col)
{
	//source: https://knarkowicz.wordpress.com/2016/01/06/aces-filmic-tone-mapping-curve/
	float a = 2.51f;
	float b = 0.03f;
	float c = 2.43f;
	float d = 0.59f;
	float e = 0.14f;
	return clamp((col*(a*col + b)) / (col*(c*col + d) + e),0.f,1.f);
}

void main()
{
	vec4 orig = texture2D(tex0,uv);

	//filmic curve
	//	(it overexposes a bit, so we'll push it down a bit to stay closer to sRGB)
	orig.rgb *= .85f;
	orig.rgb = correct3(orig.rgb);

	//linear to sRGB
	orig = sqrt(orig);

	gl_FragColor = /*orig.aaaa;// */ orig;
}
