/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.ugens.Instrument;
import java.util.ArrayList;
import java.util.HashMap;

public class NoteManager {
    private float sampleRate;
    private float tempo;
    private float noteOffset;
    private float durationFactor;
    private int now;
    private HashMap<Integer, ArrayList<NoteEvent>> events;
    private boolean paused;

    public NoteManager(float sampleRate) {
        this.sampleRate = sampleRate;
        this.events = new HashMap();
        this.tempo = 60.0f;
        this.noteOffset = 0.0f;
        this.durationFactor = 1.0f;
        this.now = 0;
        this.paused = false;
    }

    public synchronized void addEvent(float startTime, float duration, Instrument instrument) {
        ArrayList<Object> eventsAtOn;
        int on = this.now + (int)(this.sampleRate * (startTime + this.noteOffset) * 60.0f / this.tempo);
        Integer onAt = new Integer(on);
        float actualDuration = duration * this.durationFactor * 60.0f / this.tempo;
        if (this.events.containsKey(onAt)) {
            eventsAtOn = this.events.get(onAt);
            eventsAtOn.add(new NoteOnEvent(instrument, actualDuration));
        } else {
            eventsAtOn = new ArrayList<NoteOnEvent>();
            eventsAtOn.add(new NoteOnEvent(instrument, actualDuration));
            this.events.put(onAt, eventsAtOn);
        }
        Integer offAt = new Integer(on + (int)(this.sampleRate * actualDuration));
        if (this.events.containsKey(offAt)) {
            ArrayList<NoteEvent> eventsAtOff = this.events.get(offAt);
            eventsAtOff.add(new NoteOffEvent(instrument));
        } else {
            ArrayList<NoteOffEvent> eventsAtOff = new ArrayList<NoteOffEvent>();
            eventsAtOff.add(new NoteOffEvent(instrument));
            this.events.put(offAt, eventsAtOff);
        }
    }

    public void setTempo(float tempo) {
        this.tempo = tempo;
    }

    public float getTempo() {
        return this.tempo;
    }

    public void setNoteOffset(float noteOffset) {
        this.noteOffset = noteOffset;
    }

    public float getNoteOffset() {
        return this.noteOffset;
    }

    public void setDurationFactor(float durationFactor) {
        this.durationFactor = durationFactor;
    }

    public float getDurationFactor() {
        return this.durationFactor;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public synchronized void tick() {
        if (!this.paused) {
            Integer Now = new Integer(this.now);
            if (this.events.containsKey(Now)) {
                ArrayList<NoteEvent> eventsToSend = this.events.get(Now);
                for (int i = 0; i < eventsToSend.size(); ++i) {
                    eventsToSend.get(i).send();
                }
                this.events.remove(Now);
            }
            ++this.now;
        }
    }

    private class NoteOffEvent
    implements NoteEvent {
        private Instrument instrument;

        public NoteOffEvent(Instrument i) {
            this.instrument = i;
        }

        @Override
        public void send() {
            this.instrument.noteOff();
        }
    }

    private class NoteOnEvent
    implements NoteEvent {
        private Instrument instrument;
        private float duration;

        public NoteOnEvent(Instrument i, float dur) {
            this.instrument = i;
            this.duration = dur;
        }

        @Override
        public void send() {
            this.instrument.noteOn(this.duration);
        }
    }

    private static interface NoteEvent {
        public void send();
    }
}

