/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import processing.core.PApplet;
import processing.sound.Analyzer;
import processing.sound.Engine;
import processing.sound.JSynFFT;

public class FFT
extends Analyzer {
    public float[] spectrum;
    private JSynFFT fft;

    public FFT(PApplet pApplet) {
        this(pApplet, 512);
    }

    public FFT(PApplet pApplet, int n) {
        super(pApplet);
        if (n < 0 || Integer.bitCount(n) != 1) {
            Engine.printError("number of FFT bands needs to be a power of 2");
        } else {
            this.fft = new JSynFFT(2 * n);
            this.spectrum = new float[n];
        }
    }

    @Override
    protected void removeInput() {
        this.fft.input.disconnectAll();
        this.input = null;
    }

    @Override
    protected void setInput(UnitOutputPort unitOutputPort) {
        Engine.getEngine().add((UnitGenerator)this.fft);
        this.fft.input.connect(unitOutputPort);
        this.fft.start();
    }

    public float[] analyze() {
        return this.analyze(this.spectrum);
    }

    public float[] analyze(float[] fArray) {
        if (this.input == null) {
            Engine.printWarning("this FFT has no sound source connected to it, nothing to analyze");
        }
        this.fft.calculateMagnitudes(fArray);
        return fArray;
    }
}

