/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitFilter;

public class AsymptoticRamp
extends UnitFilter {
    public UnitVariablePort current;
    public UnitInputPort halfLife = new UnitInputPort(1, "HalfLife", 0.1);
    private double previousHalfLife = -1.0;
    private double decayScalar = 0.99;

    public AsymptoticRamp() {
        this.addPort(this.halfLife);
        this.current = new UnitVariablePort("Current");
        this.addPort(this.current);
    }

    @Override
    public void generate(int n, int n2) {
        double d;
        double[] dArray = this.output.getValues();
        double[] dArray2 = this.input.getValues();
        double d2 = this.halfLife.getValues()[0];
        double d3 = d = this.current.getValue();
        if (d2 != this.previousHalfLife) {
            this.decayScalar = this.convertHalfLifeToMultiplier(d2);
            this.previousHalfLife = d2;
        }
        for (int i = n; i < n2; ++i) {
            d3 = dArray2[i];
            d += this.decayScalar * (d3 - d);
            dArray[i] = d;
        }
        if (Math.abs(d3 - d) < 1.0E-26) {
            d = d3;
        }
        this.current.setValue(d);
    }
}

