import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import processing.sound.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class OneSceneJM2 extends PApplet {



int numBalls = 200;
float spring = 0.10f;
float gravity = 0.03f;
float friction = -0.5f;
int counter = 1;
Ball[] balls = new Ball[numBalls];
float tx;
float ty;

float startTime;

PFont font;

SoundFile music;

public void settings() {
  size(1920, 1080);
}

public void setup() {
  for (int i = 0; i < numBalls; i++) {
    balls[i] = new Ball(random(width), random(height), random(20, 80), i, balls);
  }
  noStroke(); //ääriviivat
  noCursor();
  surface.setResizable(true);
  fill(255, 231, 235);
  font = createFont("animaletters.medium.ttf", 50);
  music = new SoundFile(this, "Taustamusa.wav");
  music.loop();
  startTime = millis();
 
}

public void draw() {
  background(255, 196, 205);
  for (Ball ball : balls) {
    ball.collide();
    ball.move();
    ball.display();
  }

   float elapsedTime = millis() - startTime;
   text("UWU", tx, ty);
   textFont(font, 80);
   
 
  if (elapsedTime/1000 > counter) {
    counter++;
    textF();
  }

  if (elapsedTime/1000 > 23) {
    exit();
  }
}

public void textF() {
    tx = random(width);
    ty = random(height);  
}

class Ball {
 
  float x, y;
  float diameter;
  float vx = 0;
  float vy = 0;
  int id;
  Ball[] others;
 
  Ball(float xin, float yin, float din, int idin, Ball[] oin) {
    x = xin;
    y = yin;
    diameter = din;
    id = idin;
    others = oin;
  }
 
  public void collide() {
    for (int i = id + 1; i < numBalls; i++) {
      float dx = others[i].x - x;
      float dy = others[i].y - y;
      float distance = sqrt(dx*dx + dy*dy);
      float minDist = others[i].diameter/2 + diameter/2;
      if (distance < minDist) {
        float angle = atan2(dy, dx);
        float targetX = x + cos(angle) * minDist;
        float targetY = y + sin(angle) * minDist;
        float ax = (targetX - others[i].x) * spring;
        float ay = (targetY - others[i].y) * spring;
        vx -= ax;
        vy -= ay;
        others[i].vx += ax;
        others[i].vy += ay;
      }
    }  
  }
 
  public void move() {
    vy += gravity;
    x += vx;
    y += vy;
    if (x + diameter/2 > width) {
      x = width - diameter/2;
      vx *= friction;
    }
    else if (x - diameter/2 < 0) {
      x = diameter/2;
      vx *= friction;
    }
    if (y + diameter/2 > height) {
      y = height - diameter/2;
      vy *= friction;
    }
    else if (y - diameter/2 < 0) {
      y = diameter/2;
      vy *= friction;
    }
  }
 
  public void display() {
    ellipse(x, y, diameter, diameter);
  }
 
}

public void keyPressed() {
    if (keyCode == ESC) {
      exit();
    }
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "OneSceneJM2" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
