
	org #8000

	;test code

begin

	ld hl,music_data
	call play
	ret
	
	
	
	;engine code

;squat by Shiru, 06'17
;Squeeker like, just without the output value table
;4 channels of tone with different duty cycle
;sample drums, non-interrupting
;customizeable noise percussion, interrupting


;music data is all 16-bit words, first control then a few optional ones

;control word is PSSSSSSS DDDN4321, where P=percussion,S=speed, D=drum, N=noise mode, 4321=channels
;D triggers non-interruping sample drum
;P trigger
;if 1, channel 1 freq follows
;if 2, channel 2 freq follows
;if 3, channel 3 freq follows
;if 4, channel 4 freq follows
;if N, channel 4 mode follows, it is either #0000 (normal) or #04cb (noise)
;if P, percussion follows, LSB=volume, MSB=pitch



RLC_H=#04cb			;to enable noise mode
NOP_2=#0000			;to disable noise mode
RLC_HL=#06cb		;to enable sample reading
ADD_IX_IX=#29dd		;to disable sample reading


play

	di
	
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (loop_ptr),de
	
	ld (pattern_ptr),hl
	
	ld hl,ADD_IX_IX
	ld (sample_read),hl
	ld hl,NOP_2					;normal mode
	ld (noise_mode),hl
	
	ld ix,0						;needs to be 0 to skip sample reading

	ld c,0
	exx
	ld de,#0808					;sample bit counter and reload value

play_loop

pattern_ptr=$+1
	ld sp,0
	
return_loop

	pop bc						;control word
								;B=duration of the row (0=loop)
								;C=flags DDDN4321 (Drum, Noise, 1-4 channel update)
	ld a,b
	or a
	jp nz,no_loop
	
loop_ptr=$+1
	ld sp,0
	
	jp return_loop
	
no_loop

	ld a,c
	
	rra
	jr nc,skip_note_0
	
	pop hl
	ld (ch0_add),hl
	
skip_note_0

	rra
	jr nc,skip_note_1

	pop hl
	ld (ch1_add),hl
	
skip_note_1

	rra
	jr nc,skip_note_2
	
	pop hl
	ld (ch2_add),hl
	
skip_note_2

	rra
	jr nc,skip_note_3
	
	pop hl
	ld (ch3_add),hl
	
skip_note_3

	rra
	jr nc,skip_mode_change
	
	pop hl						;nop:nop or rlc h
	ld (noise_mode),hl

skip_mode_change

	and 7
	jp z,skip_drum
	
	ld hl,sample_list-2
	add a,a
	add a,l
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl)
	ld l,a
	ld (sample_ptr),hl
	ld hl,RLC_HL
	ld (sample_read),hl

skip_drum

	bit 7,b						;check percussion flag
	jp z,skip_percussion

	res 7,b						;clear percussion flag
	dec b						;compensate speed

	ld (noise_bc),bc
	ld (noise_de),de

	pop hl						;read percussion parameters

	ld a,l						;noise volume
	ld (noise_volume),a
	ld b,h						;noise pitch
	ld c,h
	ld de,#2174					;utz's rand seed			
	exx
	ld bc,811					;noise duration, takes as long as inner sound loop

noise_loop

	exx							;4
	dec c						;4
	jr nz,noise_skip			;7/12
	ld c,b						;4
	add hl,de					;11
	rlc h						;8		utz's noise generator idea
	inc d						;4		improves randomness
	jp noise_next				;10
	
noise_skip

	jr $+2						;12
	jr $+2						;12
	nop							;4
	nop							;4
	
noise_next

	ld a,h						;4
	
noise_volume=$+1
	cp #80						;7
	sbc a,a						;4
	out (#fe),a					;11
	exx							;4

	dec bc						;6
	ld a,b						;4
	or c						;4
	jp nz,noise_loop			;10=106t

	exx

noise_bc=$+1
	ld bc,0
noise_de=$+1
	ld de,0



skip_percussion

	ld (pattern_ptr),sp

sample_ptr=$+1
	ld hl,0

	ld c,0						;internal loop runs 256 times

sound_loop

sample_read=$
	rlc (hl)					;15 	rotate sample bits in place, rl (hl) or add ix,ix (dummy operation)
	sbc a,a						;4		sbc a,a to make bit into 0 or 255, or xor a to keep it 0

	dec e						;4--+	count bits
	jp z,sample_cycle			;10 |
	jp sample_next				;10

sample_cycle

	ld e,d						;4	|	reload counter
	inc hl						;6--+	advance pointer --24t

sample_next

	exx							;4		squeeker type unrolled code
	ld b,a						;4		sample mask
	xor a						;4
	
	ld sp,sound_list			;10
		
	pop de						;10		ch0_acc
	pop hl						;10		ch0_add
	add hl,de					;11
	rla							;4
	ld (ch0_acc),hl				;16
						
	pop de						;10		ch1_acc
	pop hl						;10		ch1_add
	add hl,de					;11
	rla							;4
	ld (ch1_acc),hl				;16
	
	pop de						;10		ch2_acc
	pop hl						;10		ch2_add
	add hl,de					;11
	rla							;4
	ld (ch2_acc),hl				;16

	pop de						;10		ch3_acc
	pop hl						;10		ch3_add
	add hl,de					;11
	
noise_mode=$
	ds 2,0						;8		rlc h for noise effects

	rla							;4
	ld (ch3_acc),hl				;16

	add a,c						;4		no table like in Squeeker, channels summed as is, for uneven 'volume'
	add a,#ff					;7
	sbc a,#ff					;7
	ld c,a						;4
	sbc a,a						;4

	or b						;4		mix sample
	
	out (#fe),a					;11
		
	exx							;4

	dec c						;4
	jp nz,sound_loop			;10=336t


	dec hl						;last byte of a 256 byte sample packet is 0 means it was the last packet
	ld a,(hl)
	inc hl
	cp #80
	jr nz,sample_no_stop

	ld hl,ADD_IX_IX
	ld (sample_read),hl			;disable sample reading

sample_no_stop

	djnz sound_loop

	ld (sample_ptr),hl
	
	jp play_loop
	
	
	
	align 2

sample_list

	dw sample_1
	dw sample_2
	dw sample_3
	dw sample_4
	dw sample_5
	dw sample_6
	dw sample_7
	
;variables in the sound_list can't be reordered because of stack-based fetching

sound_list

ch0_add		dw 0
ch0_acc		dw 0
ch1_add		dw 0
ch1_acc		dw 0
ch2_add		dw 0
ch2_acc		dw 0
ch3_add		dw 0
ch3_acc		dw 0


;sample data

	align 256

sample_1
sample_2
sample_3
sample_4
sample_5
sample_6
sample_7


;compiled music data

music_data
	dw .loop
.pattern
.loop
	dw #71f,#103,#0,#0,#0,NOP_2
	dw #701,#103
	dw #701,#206
	dw #701,#103
	dw #700
	dw #700
	dw #701,#0
	dw #700
	dw #701,#15a
	dw #701,#15a
	dw #701,#2b4
	dw #701,#15a
	dw #701,#268
	dw #701,#2b4
	dw #701,#134
	dw #701,#268
	dw #701,#103
	dw #701,#103
	dw #701,#206
	dw #701,#103
	dw #700
	dw #700
	dw #701,#0
	dw #700
	dw #701,#e6
	dw #701,#e6
	dw #701,#1cd
	dw #701,#e6
	dw #705,#cd,#393
	dw #705,#cd,#37b
	dw #705,#19b,#363
	dw #705,#cd,#35b
	dw #870f,#103,#40c,#0,#0,#1180
	dw #701,#103
	dw #701,#206
	dw #701,#103
	dw #8700,#1180
	dw #700
	dw #701,#0
	dw #700
	dw #8703,#15a,#0,#1180
	dw #701,#15a
	dw #701,#2b4
	dw #701,#15a
	dw #8701,#268,#1180
	dw #701,#2b4
	dw #701,#134
	dw #701,#268
	dw #8701,#103,#1180
	dw #701,#103
	dw #701,#206
	dw #701,#103
	dw #8700,#1180
	dw #700
	dw #701,#0
	dw #700
	dw #8701,#e6,#1180
	dw #701,#e6
	dw #701,#1cd
	dw #701,#e6
	dw #8703,#cd,#4d1,#1180
	dw #701,#cd
	dw #8701,#19b,#1180
	dw #701,#cd
	dw #870b,#103,#40c,#0,#1180
	dw #701,#103
	dw #701,#206
	dw #701,#103
	dw #8700,#1180
	dw #700
	dw #701,#0
	dw #700
	dw #8703,#15a,#0,#1180
	dw #701,#15a
	dw #701,#2b4
	dw #701,#15a
	dw #8701,#268,#1180
	dw #701,#2b4
	dw #701,#134
	dw #701,#268
	dw #8701,#103,#1180
	dw #701,#103
	dw #701,#206
	dw #701,#103
	dw #8700,#1180
	dw #700
	dw #701,#0
	dw #700
	dw #8703,#e6,#404,#1180
	dw #703,#e6,#3fc
	dw #703,#1cd,#3f4
	dw #703,#e6,#3ec
	dw #8707,#cd,#3e4,#70f,#1180
	dw #707,#cd,#3dc,#6ff
	dw #8707,#19b,#3d4,#6f7,#1180
	dw #707,#cd,#3cc,#6ef
	dw #8707,#122,#245,#6cf,#1180
	dw #703,#122,#245
	dw #70b,#245,#48b,#6cf
	dw #703,#122,#245
	dw #8702,#245,#580
	dw #702,#245
	dw #703,#0,#48b
	dw #702,#245
	dw #8707,#184,#308,#737,#1180
	dw #703,#184,#308
	dw #70b,#308,#611,#737
	dw #703,#184,#308
	dw #8703,#2b4,#2b4,#580
	dw #703,#308,#2b4
	dw #703,#15a,#568
	dw #703,#2b4,#2b4
	dw #8707,#122,#245,#6cf,#1180
	dw #703,#122,#245
	dw #70b,#245,#48b,#6cf
	dw #703,#122,#245
	dw #8702,#245,#580
	dw #702,#245
	dw #703,#0,#48b
	dw #702,#245
	dw #8707,#103,#206,#819,#1180
	dw #703,#103,#206
	dw #70f,#206,#40c,#737,#819
	dw #703,#103,#206
	dw #870f,#e6,#1cd,#6cf,#737,#580
	dw #703,#e6,#1cd
	dw #870f,#1cd,#39b,#611,#6cf,#1180
	dw #703,#e6,#1cd
	dw #870f,#122,#245,#6cf,#611,#1180
	dw #703,#122,#245
	dw #70b,#245,#48b,#6cf
	dw #703,#122,#245
	dw #8702,#245,#580
	dw #702,#245
	dw #703,#0,#48b
	dw #702,#245
	dw #8707,#184,#308,#48b,#1180
	dw #703,#184,#308
	dw #70b,#308,#611,#48b
	dw #703,#184,#308
	dw #8703,#2b4,#2b4,#580
	dw #703,#308,#2b4
	dw #703,#15a,#568
	dw #703,#2b4,#2b4
	dw #8707,#122,#245,#6cf,#1180
	dw #703,#122,#245
	dw #70b,#245,#48b,#6cf
	dw #703,#122,#245
	dw #8702,#245,#580
	dw #702,#245
	dw #703,#0,#48b
	dw #702,#245
	dw #8707,#103,#206,#737,#1180
	dw #703,#103,#206
	dw #70f,#206,#40c,#6cf,#737
	dw #703,#103,#206
	dw #870f,#e6,#1cd,#611,#6cf,#580
	dw #703,#e6,#1cd
	dw #870f,#1cd,#39b,#568,#611,#1180
	dw #703,#e6,#1cd
	dw #8707,#d9,#1b3,#51a,#1180
	dw #703,#d9,#1b3
	dw #70b,#1b3,#367,#51a
	dw #703,#d9,#1b3
	dw #8702,#1b3,#580
	dw #702,#1b3
	dw #703,#0,#367
	dw #702,#1b3
	dw #8707,#122,#245,#568,#1180
	dw #703,#122,#245
	dw #70b,#245,#48b,#568
	dw #703,#122,#245
	dw #8703,#206,#206,#580
	dw #703,#245,#206
	dw #703,#103,#40c
	dw #703,#206,#206
	dw #8707,#d9,#1b3,#51a,#1180
	dw #703,#d9,#1b3
	dw #70b,#1b3,#367,#51a
	dw #703,#d9,#1b3
	dw #8702,#1b3,#580
	dw #702,#1b3
	dw #703,#0,#367
	dw #702,#1b3
	dw #8707,#c2,#184,#611,#1180
	dw #703,#c2,#184
	dw #70f,#184,#308,#568,#611
	dw #703,#c2,#184
	dw #870f,#ad,#15a,#51a,#568,#580
	dw #703,#ad,#15a
	dw #870f,#15a,#2b4,#48b,#51a,#1180
	dw #703,#ad,#15a
	dw #870f,#d9,#1b3,#51a,#48b,#1180
	dw #703,#d9,#1b3
	dw #70b,#1b3,#367,#51a
	dw #703,#d9,#1b3
	dw #8702,#1b3,#580
	dw #702,#1b3
	dw #703,#0,#367
	dw #702,#1b3
	dw #8707,#122,#245,#367,#1180
	dw #703,#122,#245
	dw #70b,#245,#48b,#367
	dw #703,#122,#245
	dw #8703,#206,#206,#580
	dw #703,#245,#206
	dw #703,#103,#40c
	dw #703,#206,#206
	dw #8707,#d9,#1b3,#51a,#1180
	dw #703,#d9,#1b3
	dw #70b,#1b3,#367,#51a
	dw #703,#d9,#1b3
	dw #8702,#1b3,#580
	dw #702,#1b3
	dw #703,#0,#367
	dw #702,#1b3
	dw #8707,#c2,#184,#568,#1180
	dw #703,#c2,#184
	dw #70f,#184,#308,#51a,#568
	dw #703,#c2,#184
	dw #870f,#ad,#15a,#48b,#51a,#580
	dw #703,#ad,#15a
	dw #870f,#15a,#2b4,#40c,#48b,#1180
	dw #703,#ad,#15a
	dw #70f,#103,#611,#0,#0
	dw #705,#103,#609
	dw #709,#206,#601
	dw #701,#103
	dw #702,#609
	dw #706,#601,#601
	dw #70f,#0,#5f9,#5f9,#5f9
	dw #70e,#5f1,#5f1,#5f1
	dw #70f,#15a,#66e,#5e9,#5e9
	dw #70d,#15a,#66e,#5e1
	dw #709,#2b4,#66e
	dw #701,#15a
	dw #703,#268,#666
	dw #707,#2b4,#65e,#65e
	dw #70f,#134,#656,#656,#656
	dw #70f,#268,#64e,#64e,#64e
	dw #70f,#103,#819,#646,#646
	dw #70d,#103,#811,#63e
	dw #709,#206,#809
	dw #701,#103
	dw #700
	dw #700
	dw #701,#0
	dw #700
	dw #701,#e6
	dw #701,#e6
	dw #701,#1cd
	dw #701,#e6
	dw #703,#cd,#811
	dw #707,#cd,#809,#809
	dw #70f,#19b,#801,#801,#801
	dw #70f,#cd,#7f9,#7f9,#7f9
	dw #70f,#103,#611,#7f1,#7f1
	dw #70d,#103,#609,#7e9
	dw #709,#206,#601
	dw #701,#103
	dw #702,#609
	dw #706,#601,#601
	dw #70f,#0,#5f9,#5f9,#5f9
	dw #70e,#5f1,#5f1,#5f1
	dw #70f,#15a,#66e,#5e9,#5e9
	dw #70d,#15a,#666,#5e1
	dw #709,#2b4,#65e
	dw #701,#15a
	dw #703,#268,#666
	dw #707,#2b4,#65e,#65e
	dw #70f,#134,#656,#656,#656
	dw #70f,#268,#64e,#64e,#64e
	dw #70f,#103,#40c,#646,#646
	dw #70d,#103,#404,#63e
	dw #709,#206,#3fc
	dw #701,#103
	dw #700
	dw #700
	dw #701,#0
	dw #700
	dw #701,#e6
	dw #701,#e6
	dw #701,#1cd
	dw #701,#e6
	dw #8703,#cd,#609,#1180
	dw #707,#cd,#601,#601
	dw #870f,#19b,#5f9,#5f9,#5f9,#1180
	dw #70f,#cd,#5f1,#5f1,#5f1
	dw #8703,#103,#611,#1180
	dw #705,#103,#609
	dw #709,#206,#601
	dw #701,#103
	dw #8702,#609,#1180
	dw #706,#601,#601
	dw #70f,#0,#5f9,#5f9,#5f9
	dw #70e,#5f1,#5f1,#5f1
	dw #870f,#15a,#66e,#5e9,#5e9,#1180
	dw #70d,#15a,#66e,#5e1
	dw #709,#2b4,#66e
	dw #701,#15a
	dw #8703,#268,#666,#1180
	dw #707,#2b4,#65e,#65e
	dw #70f,#134,#656,#656,#656
	dw #70f,#268,#64e,#64e,#64e
	dw #870f,#103,#819,#646,#646,#1180
	dw #70d,#103,#811,#63e
	dw #709,#206,#809
	dw #701,#103
	dw #8700,#1180
	dw #700
	dw #701,#0
	dw #700
	dw #8701,#e6,#1180
	dw #701,#e6
	dw #701,#1cd
	dw #701,#e6
	dw #8703,#cd,#811,#1180
	dw #707,#cd,#809,#809
	dw #870f,#19b,#801,#801,#801,#1180
	dw #70f,#cd,#7f9,#7f9,#7f9
	dw #870f,#103,#611,#7f1,#7f1,#1180
	dw #70d,#103,#609,#7e9
	dw #709,#206,#601
	dw #701,#103
	dw #8702,#609,#1180
	dw #706,#601,#601
	dw #70f,#0,#5f9,#5f9,#5f9
	dw #70e,#5f1,#5f1,#5f1
	dw #870f,#15a,#66e,#5e9,#5e9,#1180
	dw #70d,#15a,#666,#5e1
	dw #709,#2b4,#65e
	dw #701,#15a
	dw #8703,#268,#666,#1180
	dw #707,#2b4,#65e,#65e
	dw #70f,#134,#656,#656,#656
	dw #70f,#268,#64e,#64e,#64e
	dw #870f,#103,#40c,#646,#646,#1180
	dw #70d,#103,#404,#63e
	dw #709,#206,#3fc
	dw #701,#103
	dw #8700,#1180
	dw #700
	dw #701,#0
	dw #700
	dw #8701,#e6,#1180
	dw #701,#e6
	dw #8701,#1cd,#1180
	dw #701,#e6
	dw #8703,#cd,#609,#1180
	dw #8707,#cd,#601,#601,#1180
	dw #870f,#19b,#5f9,#5f9,#5f9,#1180
	dw #870f,#cd,#5f1,#5f1,#5f1,#1180
	dw #8707,#146,#28d,#7a5,#1180
	dw #703,#146,#28d
	dw #70b,#28d,#51a,#7a5
	dw #703,#146,#28d
	dw #8702,#28d,#580
	dw #702,#28d
	dw #703,#0,#51a
	dw #702,#28d
	dw #8707,#1b3,#367,#819,#1180
	dw #703,#1b3,#367
	dw #70b,#367,#6cf,#819
	dw #703,#1b3,#367
	dw #8703,#308,#308,#580
	dw #703,#367,#308
	dw #703,#184,#611
	dw #703,#308,#308
	dw #8707,#146,#28d,#7a5,#1180
	dw #703,#146,#28d
	dw #70b,#28d,#51a,#7a5
	dw #703,#146,#28d
	dw #8702,#28d,#580
	dw #702,#28d
	dw #703,#0,#51a
	dw #702,#28d
	dw #8707,#122,#245,#917,#1180
	dw #703,#122,#245
	dw #70f,#245,#48b,#819,#917
	dw #703,#122,#245
	dw #870f,#103,#206,#7a5,#819,#580
	dw #703,#103,#206
	dw #870f,#206,#40c,#6cf,#7a5,#1180
	dw #703,#103,#206
	dw #870f,#146,#28d,#7a5,#6cf,#1180
	dw #703,#146,#28d
	dw #70b,#28d,#51a,#7a5
	dw #703,#146,#28d
	dw #8702,#28d,#580
	dw #702,#28d
	dw #703,#0,#51a
	dw #702,#28d
	dw #8707,#1b3,#367,#51a,#1180
	dw #703,#1b3,#367
	dw #70b,#367,#6cf,#51a
	dw #703,#1b3,#367
	dw #8703,#308,#308,#580
	dw #703,#367,#308
	dw #703,#184,#611
	dw #703,#308,#308
	dw #8707,#146,#28d,#7a5,#1180
	dw #703,#146,#28d
	dw #70b,#28d,#51a,#7a5
	dw #703,#146,#28d
	dw #8702,#28d,#580
	dw #702,#28d
	dw #703,#0,#51a
	dw #702,#28d
	dw #8707,#122,#245,#819,#1180
	dw #703,#122,#245
	dw #70f,#245,#48b,#7a5,#819
	dw #703,#122,#245
	dw #870f,#103,#206,#6cf,#7a5,#580
	dw #703,#103,#206
	dw #870f,#206,#40c,#611,#6cf,#1180
	dw #703,#103,#206
	dw #8707,#f4,#1e9,#5ba,#1180
	dw #703,#f4,#1e9
	dw #70b,#1e9,#3d2,#5ba
	dw #703,#f4,#1e9
	dw #8702,#1e9,#580
	dw #702,#1e9
	dw #703,#0,#3d2
	dw #702,#1e9
	dw #8707,#146,#28d,#611,#1180
	dw #703,#146,#28d
	dw #70b,#28d,#51a,#611
	dw #703,#146,#28d
	dw #8703,#245,#245,#580
	dw #703,#28d,#245
	dw #703,#122,#48b
	dw #703,#245,#245
	dw #8707,#f4,#1e9,#5ba,#1180
	dw #703,#f4,#1e9
	dw #70b,#1e9,#3d2,#5ba
	dw #703,#f4,#1e9
	dw #8702,#1e9,#580
	dw #702,#1e9
	dw #703,#0,#3d2
	dw #702,#1e9
	dw #8707,#d9,#1b3,#6cf,#1180
	dw #703,#d9,#1b3
	dw #70f,#1b3,#367,#611,#6cf
	dw #703,#d9,#1b3
	dw #870f,#c2,#184,#5ba,#611,#580
	dw #703,#c2,#184
	dw #870f,#184,#308,#51a,#5ba,#1180
	dw #703,#c2,#184
	dw #870f,#f4,#1e9,#5ba,#51a,#1180
	dw #703,#f4,#1e9
	dw #70b,#1e9,#3d2,#5ba
	dw #703,#f4,#1e9
	dw #8702,#1e9,#580
	dw #702,#1e9
	dw #703,#0,#3d2
	dw #702,#1e9
	dw #8707,#146,#28d,#3d2,#1180
	dw #703,#146,#28d
	dw #70b,#28d,#51a,#3d2
	dw #703,#146,#28d
	dw #8703,#245,#245,#580
	dw #703,#28d,#245
	dw #703,#122,#48b
	dw #703,#245,#245
	dw #8707,#f4,#1e9,#5ba,#1180
	dw #703,#f4,#1e9
	dw #70b,#1e9,#3d2,#5ba
	dw #703,#f4,#1e9
	dw #8702,#1e9,#580
	dw #702,#1e9
	dw #703,#0,#3d2
	dw #702,#1e9
	dw #8707,#d9,#1b3,#611,#1180
	dw #703,#d9,#1b3
	dw #70f,#1b3,#367,#5ba,#611
	dw #703,#d9,#1b3
	dw #870f,#c2,#184,#51a,#5ba,#580
	dw #703,#c2,#184
	dw #870f,#184,#308,#48b,#51a,#1180
	dw #703,#c2,#184
	dw #8707,#103,#0,#609,#1180
	dw #70d,#103,#601,#609
	dw #70d,#206,#5f9,#601
	dw #70d,#103,#5f1,#5f9
	dw #870c,#5e9,#5f1,#580
	dw #70c,#5e1,#5e9
	dw #70d,#0,#5d9,#5e1
	dw #70c,#5d1,#5d9
	dw #870d,#15a,#5c9,#5d1,#1180
	dw #70d,#15a,#5c9,#5c9
	dw #70d,#2b4,#5d1,#5c9
	dw #70d,#15a,#5d9,#5d1
	dw #870d,#268,#5e1,#5d9,#580
	dw #70d,#2b4,#5e9,#5e1
	dw #70d,#134,#5f1,#5e9
	dw #70d,#268,#5f9,#5f1
	dw #870d,#103,#601,#5f9,#1180
	dw #70d,#103,#609,#601
	dw #70d,#206,#609,#609
	dw #70d,#103,#601,#609
	dw #870c,#5f9,#601,#580
	dw #70c,#5f1,#5f9
	dw #70d,#0,#5e9,#5f1
	dw #70c,#5e1,#5e9
	dw #870d,#e6,#5d9,#5e1,#1180
	dw #70d,#e6,#5d1,#5d9
	dw #70d,#1cd,#5c9,#5d1
	dw #70d,#e6,#5c9,#5c9
	dw #870d,#cd,#5d1,#5c9,#580
	dw #70d,#cd,#5d9,#5d1
	dw #870d,#19b,#5e1,#5d9,#1180
	dw #70d,#cd,#5e9,#5e1
	dw #8707,#103,#0,#609,#1180
	dw #70d,#103,#601,#609
	dw #70d,#206,#5f9,#601
	dw #70d,#103,#5f1,#5f9
	dw #870c,#5e9,#5f1,#1180
	dw #70c,#5e1,#5e9
	dw #70d,#0,#5d9,#5e1
	dw #70c,#5d1,#5d9
	dw #870d,#15a,#5c9,#5d1,#1180
	dw #70d,#15a,#5c9,#5c9
	dw #70d,#2b4,#5d1,#5c9
	dw #70d,#15a,#5d9,#5d1
	dw #870d,#268,#5e1,#5d9,#1180
	dw #70d,#2b4,#5e9,#5e1
	dw #70d,#134,#5f1,#5e9
	dw #70d,#268,#5f9,#5f1
	dw #870d,#103,#601,#5f9,#1180
	dw #70d,#103,#609,#601
	dw #70d,#206,#609,#609
	dw #70d,#103,#601,#609
	dw #870c,#5f9,#601,#1180
	dw #70c,#5f1,#5f9
	dw #70d,#0,#5e9,#5f1
	dw #70c,#5e1,#5e9
	dw #870d,#e6,#5d9,#5e1,#1180
	dw #70d,#e6,#5d1,#5d9
	dw #70d,#1cd,#5c9,#5d1
	dw #70d,#e6,#5c9,#5c9
	dw #870d,#cd,#5d1,#5c9,#1180
	dw #70d,#cd,#5d9,#5d1
	dw #870d,#19b,#5e1,#5d9,#1180
	dw #70d,#cd,#5e9,#5e1
	dw #8707,#103,#0,#609,#1180
	dw #70d,#103,#601,#609
	dw #70d,#206,#5f9,#601
	dw #70d,#103,#5f1,#5f9
	dw #70c,#5e9,#5f1
	dw #70c,#5e1,#5e9
	dw #70d,#0,#5d9,#5e1
	dw #700
	dw #870d,#819,#c23,#0,#1180
	dw #705,#0,#0
	dw #700
	dw #700
	dw #700
	dw #700
	dw #700
	dw #700
	dw #700
	dw #700
	dw #700
	dw #700
	dw 0
