#version 450 core

// inputs 
in vec2 texCoord;

// outputs
out vec4 fragColor;

// uniforms
uniform sampler2D   t_texture0;
uniform float       g_time;
uniform float       g_uvScale;

float t = g_time;
float it = (int((t + .4*sin(t*0.3) + .2*sin(t*0.9)) * 2.)) * .5;

float rand(vec2 co){
    return fract(sin(dot(co, vec2(12.9898, 78.233))) * 43758.5453)-.5;
}

void main(void) {
    vec2 uv = texCoord;
    uv +=
        .32*g_uvScale*vec2(
            .02*sin(uv.x*42. + t*.14)*sin(uv.y*22. + 12.*sin(t*.14)) + .42*cos(uv.y*8 + t*.24),
            .21*cos(uv.x*21. + t*.21)*sin(uv.y*12. + t*.32) + .42*cos(uv.y*14. + 11.*sin(t*.16)));

    float a = smoothstep(.0, .03, rand(vec2(texCoord.y, it)));

    fragColor = vec4(texture(t_texture0, uv).rgb - 0.2*vec3(a), 1.0);
}