#version 450 core

uniform float   g_time;
uniform mat4    m_proj;
uniform mat4    m_rotate;

// outputs
out vec4 color;

float rand(vec2 co){
    return 2.*(fract(sin(dot(co, vec2(12.9898, 78.233))) * 43758.5453)-.5);
}

vec3 palette( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d ) { return a + b*cos( 6.28318*(c*t+d) ); }

void main(){
    gl_Position = m_proj * m_rotate * vec4(
        48.0 * vec2(rand(vec2(gl_VertexID, gl_VertexID*3.)), rand(vec2((gl_VertexID*4.+.2, gl_VertexID*2.+5.2)))),
        -0.03 * (gl_VertexID) + 1.6 * g_time,
        1.0
    );

    float halframp = mod(rand(vec2(gl_VertexID+14., gl_VertexID*3.+5.)), 1.); 

    // iq ramp =)

    color = vec4(palette(halframp, vec3(0.5, 0.5, 0.5), vec3(0.5, 0.5, 0.5), vec3(1.0, 1.0, 1.0), vec3(0.30, 0.20, 0.20)), 1.0);
}
