#version 450 core

// varying inputs
in vec2 texCoord;

// outputs
//out vec4 outColor;

// uniforms
uniform sampler2D t_source;

uniform vec2 g_srcResolution;
uniform vec2 g_dstResolution;

uniform bool  g_thresholdSoft;
uniform float g_thresholdSoftness;
uniform float g_threshold;
uniform float g_thresholdScale;

void main() {
	vec3 in_Color = texture(t_source, texCoord).rgb;
	float brightness = dot(in_Color, vec3(.2126, .7152, .0722));
	float mixFactor = g_thresholdSoft ?
		smoothstep(
			max(g_threshold*(1.-g_thresholdSoftness), 0.),
				g_threshold,
			brightness)
		: step(g_threshold, brightness);
	vec3 out_Color = (in_Color * mixFactor * g_thresholdScale);
	
	gl_FragColor = vec4(out_Color, 1.0);
};
