; pasmo -d -1 -v --tap --name BorderTronCC16K BorderTronCC16K.asm BorderTronCC16K.tap BorderTronCC16K.symbol

; quick compile in kate:
; pasmo -d --tap --name %n %f %n.tap %n.symbol
; pasmo -d %f %n.bin %n.symbol
; -----------------------------;--------------------------------

; t2zx  equ  -5  +6 +11 +12    ; pasmo BUGGED RESULT ! the '-' sign is added AS LAST SUM INFLUENCE
; by which a false negative number is created !! 
; https://worldofspectrum.org/forums/discussion/comment/967124/#Comment_967124

; based on "The BorderTron 3000" Chris Cowley
; Please use this code freely.
; http://freestuff.grok.co.uk/bordertron3000/

; http://z80.info/z80ins.txt and deduction to ZX Spectrum system 
;                              OUT(C) ,   x       &     B           C       value       OUTed
; ED 49 = OUT (c),c  yellow %11101101 + %01001001   %x000xxxx + %11111110  c=254 is   %11111110     > bit 4 is   set = SOUND
; ED 71 = OUT (c),0  black  %11101101 + %01110001   %x000xxxx + %11111110  0=0        %00000000     > bit 4 is REset = NO SOUND
;--                                                                                   %000smccc
; ED 41 = OUT (c),b  (eg ligth blue)
; ED 49 = OUT (c),c  yellow  c=254 is %11111110  > bit 4 is set = SOUNDs a bit like (3.5mhz/8*224 contended BIT)
; ED 51 = OUT (c),d  (eg magenta)
; ED 59 = OUT (c),e  (eg green)
; ED 61 = OUT (c),h  (eg dark blue)
; ED 69 = OUT (c),l  (eg red)
; ED 71 = OUT (c),0  black  %11101101 + %01xxx001   ... BC=0x03FE is ROM and thus contention save, but FE is even and thus contended for the other halve
; ED 79 = OUT (c),a  (eg white)

; used and expanded by Chris Born for 16K ZX Spectrum (aka issue 1) timings in
; "Contend Colour"
; Full Contended Cycle periodes
; which are also known as "machine cycles",
; i hope i can test this demo/bench for real on a real 16K version of ZX Spectrum...
; a 16k/48k frame is (64+192+56)*224=69888 Tstates long (17bit), interrupt is actually a 3.5MHz/69888=50.08 Hz interrupt
; 69888 = 0x11100  = %1_00010001_00000000

; On first issues 16k zx spectrum and actualy all lower memory on a ZX Spectrum,
; RAM executed opcodes are fully contended, delayed, when executes while ULA is active building the screen
; ROM is not but all other are since they reach between 0x4000 and 0x7fff.
; For register BC and OUT (c),a that means reg B between 0x40 and 0x7f will give (more) contention
; This gives a slower execution, which needs a different way off counting for eg borderlines and black/white&bright pictures
; In fact in 16k memory you will have to count in M-cycle off 8 t-state each very often during screen time.

;  halt = wait for first entry tv-raster and set cycle to zero
; cycle = 14335 tstate from halt/start of screen V and H sync= 16/48k zx screen
;   l3b = last 3 bits
; compl = complement of l3b
;   dec = decimal
; delay = by ULA implemented delay is Contended Delay
;  ogev = omgekeerd evenredig=Inversely proportional
;     c = almost constante
;     n = complemented 3 bit cycle number (NAND %00000000.00000111) nand= NOT AND
;     t = tstate
; 1 t duration equals 1 n duration
; Z80 cycle count of 8 goes up while ULA delay count of 6 goes down
; cycle   binary               l3b    compl  delay ogev delay-to-3bitcount 
; 14335 = 11 0111 1111 1111  111(7) = 000(0)  6t   0n-6t=-6 > 8n-6t= 2 ,8is4bit 1000 so borrow '1'
; 14336 = 11 1000 0000 0000  000(0) = 111(7)  5t   7n-5t= 2
; 14337 = 11 1000 0000 0001  001(1) = 110(6)  4t   6n-4t= 2
;ulabus writing aka 'screenvalue', if not attached (?fysic adres above 0x3fff 32767?)
; 14338 = 11 1000 0000 0010  010(2) = 101(5)  3t   5n-3t= 2
; 14339 = 11 1000 0000 0011  011(3) = 100(4)  2t   4n-2t= 2
; 14340 = 11 1000 0000 0100  100(4) = 011(3)  1t   3n-1t= 2
; 14341 = 11 1000 0000 0101  101(5) = 010(2)  0t   2n-0t= 2
;ulabus idle aka 255 or 0 or 191?
; 14342 = 11 1000 0000 0110  110(6) = 001(1)  0t   1n-0t= 1   almost constante = c= 2
; === next ula cycle
; 14343 = 11 1000 0000 0111  111 = 000 0-2= 6
; 14344 = 11 1000 0000 1000
; 14345 = 11 1000 0000 1001 >3bit> 001 >complement> 110 >n-c=t> 6n-2= 4t delay 
;ulabus writing

;as formula(?) for the "8-fold moment"
;set Z80-cycle number, fetch LSB 3 bits, complement them, substract 2 and that gives the delay,
; >>  except for n=0(first make it 4bit by ADD 8) and n=1(delay=0 anyway)
; 374= 101110110 = 110  = 001 =

; 1 scanline takes 224 tstate on 16k and 48k zx
; 224/8=28 exact and 224/16=14, so every display scanline starts an 8fold or 16fold time periode later
; and thus every display scanline starts with a delay of 6t by ULA
;14335+  0=14335  11011111111111 > 111 = 000 0-2= 6
;14335+224=14559  11100011011111
;14559+224=14783  11100110111111
;14783+224=15007  11101010011111

;          0t         128t
;          |++++>+++++|++++151
;   199t   +    <    +    152
;   200t   223t
;      ++++|---->-----|----
;         -     <    -
;      ----|++++>+++++|++++
;         +     <    +
;      ++++|---->-----|----
;         -     <    -
;      ----|++++>+++++|++++
;         +     <    +
;      ++++|---->-----|----
;         -     <    -
;       - - - - > - - - - -
;         -     <    -

;https://faqwiki.zxnet.co.uk/wiki/Contended_memory#16K_and_48K
; moments of ULA Delay are:
; using RAM from $4000 up to $7FFF both reading and writing this area. eg
; using a port with even number/ last bit=0

;    High byte   |         | 
;    in 40 - 7F? | Low bit | Contention pattern  
;    ------------+---------+-------------------
;         No     |  Reset  | N:1, C:3
;         No     |   Set   | N:4
;        Yes     |  Reset  | C:1, C:3
;        Yes     |   Set   | C:1, C:1, C:1, C:1
;
;The 'Contention pattern' column should be interpreted from left to right. An
; "N:n" entry means that no delay is applied at this cycle, and the Z80 continues
; uninterrupted for 'n' T states. A "C:n" entry means that the ULA halts the Z80
; the delay is exactly the same as would occur for a contended memory access at
; this cycle (eg 6 T states at cycle 14335, 5 at 14336, etc on the 48K machine).
; After this delay, the Z80 then continues for 'n' cycles.

; this code is not 'short' or 'fast' but suposed to be 'steady' or 'exact' with loads of delay parts for subloop time compensation.
; short delay is needed eg 1 byte:
;    nop      = 4t or SCF =4t
;    ret nc   = 5t with Carry set NO return !!
;    inc bc   = 6t needs a double if BC is used makes 12t !!
;    ld a,(hl)= 7t 'a' is the most overwritten register, but has the most recent value aswell, can you overwrite?!! b,(hl) etc works to.
; 2byte
;    nop ; nop     = 8t
;    ld a,i        = 9t , carry: SCF ; RET NC     noncarry:  OR A ; RET C
;    inc bc;dec bc =12t
;    jr nz,xx      =12 but false =7 compensate cost 1 more byte ret nz+5
;    but thats 3 byte 12t, JP nz xxxx is 3 byte 10t, very steady

setchan           equ 0x1601           ; ROM openchannel routine
attr              equ 0x5800           ; 22528, start screen attribute field
prbuf             equ 0x5b00           ; 23296, printer buffer on zx 16 and 48 only
kstate            equ 0x5c00           ; 23552, first of 8 (temp) system key storage
seed              equ 0x5c76           ; 23670, RaNDomise system value use as temp

                  org 0x6464           ;@25700
                  ei                   ;  4t
                  ret                  ; 10t

keys              defs 9,0             ; 1+8 key storage
keys2             defs 9,0             ; 1+8 OLD key storage
twice             defb %10101010       ; catapilar


Start:            exx                  ;
                  push hl              ;
                  call  SetupIntHandler;

BorderLoop:
                  halt                 ; 4t until interrupt t= (64+192+56)*224 max=69,888
; cycle=0t to 3t =time to finish LAST code, =max 4t for HALT cyclus
; In IM 2, it takes 19 cycles to get to the interrupt routine, which is 14t by it self, ei=4 ret=10.

t1    equ 0+19+4+10  ;tcycle=33 - 36t but once in 32tstate -2 =31-34 tstate
Tt1   equ t1
Tot1  equ $

; time counter
A_halt            ld a,128             ;  7t        background colour 0
                  out (254),a          ; 11t[4,3,4] even adres is contended 0x80FE but above contented value/adres
                  ld hl,23672          ; 10t
                  inc (hl)             ; 11t        256*1/50 sec max =5.12 seconds
                  jp nz,nsec           ; 10t 7+11+10+11+10=49
t2a   equ 7 +11 +10 +11 +10

                  inc hl               ;  6t
                  inc (hl)             ; 11t
                  jp nz,nmin           ; 10t 6+11+10=27  = 21.84 minute
t2b   equ 6 +11 +10

                  inc hl               ;  6t
                  inc (hl)             ; 11t if 255 aswel, 93.20 hour =3.88 day's are done!
                  jp tdone             ; 10t 6+11+10=27
t2c   equ 6 +11 +10

nsec              ld a,i               ; 9t
                  ld a,i               ; 9t
                  ld a,i               ; 9t
t2b2  equ 9+9+9 
nmin              ld a,i               ; 9t
                  ld a,i               ; 9t
                  ld a,i               ; 9t
t2c2  equ 9+9+9

tdone:

; catapilar 1 and 2 aka old and new "10101010" to "01010101"
                  ld hl,twice          ; 10t
                  rrc (hl)             ; 15t
                  jp c,brk0            ; 10t  on '1' jump to test break
Tot2  equ $-3
tottt equ $
t2d   equ 10+15+10
t2    equ t2a + t2b + t2c +t2d ;
Tt2   equ Tt1 + t2  ; =171 = middle of border (128-224)

;big key Fetch here if 'twice' is 'even'
                  ld hl,keys+8         ;10t
                  ld de,keys2+8        ;10t to old key
                  ld bc,8              ;10t
                  lddr                 ; 8*21-5 t=163t  , z and c not touched

                  inc hl               ; 6t  z and c not touched
                  ld bc,0xfefe         ;10t
;@25783 T_                                               ; 381, 429, 477,
ky                in a,(c)             ;12t 8 x contended ; 374, 422, 470,518,566,614,662,710   z only set if real 0, but IN 254 is at least %10100000 or more so NZ flag is set
                  ret z                ; 5t delay for 8-fold-step synchronice
                  ld (hl),a            ; 7t
                  inc hl               ; 6t
                  rlc b                ; 8t
                  jp c,ky              ;10t  = 48=8-fold as anti-contending rule AS LONG AS the start MOMENT is correct  aswell
                  jp keydone           ;10t   10+10+10+(8*21)-5 +6+10+ 8*(12+5+7+6+8+10) +10= 603 = 2.691964286 scanlines !!

t3a1   equ 10+10+10+(8*21)-5 +6+10+ 8*(12+5+7+6+8+10) +10
; test BREAK-KEY if 'twice' is 'odd' cq carry SET  max 603 tstate,
brk0              ld hl,keys+1         ; 10t
                  ld de,keys+8         ; 10t
                  bit 0,(hl)           ; 12t "Caps"
                  jp nz,adel0          ;|} 10t

                  ex de,hl             ;}  4t
                  bit 0,(hl)           ;} 12t
                  jp nz,adel           ;} 10t =26 to compensate

                  jp ReturnToBASIC     ; 10t EXIT to basic

adel0             ld a,(0)             ;| 13t delay=26 in
                  ld a,(0)             ;| 13t 6 bytes

adel              ld a,33              ; 7t
a33               dec a                ; 4t
                  jr nz,a33            ;12t
                  ret nz               ; 5t 7+33*(4+12)-5+5=535

t3a2   equ 10+10+12+10 +4+12+10 +7+33*(4+12)-5+5

t3aOK  equ t3a1-t3a2                   ; should be 0 indeed
t3     equ t3a1
Tt3    equ Tt2 +t3
Tot3   equ $
keydone:

; exchange INK and PAPER on 3x3 chr$
                  ld d,3               ;   7t
setline           ld hl,attr+256       ;  10t

mvcol             push hl              ;] 11t
                  ld e,3               ;]  7t

mcl               ld a,(hl)            ;]| 7t %fbpppiii   1
                  ld b,a               ;]| 4t             1
                  and  %00000111       ;]| 7t %00000iii   2

                  rlca                 ;]| 4t %0000iii0   1
                  rlca                 ;]| 4t %000iii00   1
                  rlca                 ;]| 4t %00iii000   1
                  ld c,a               ;]| 4t             1

                  ld a,b               ;]| 4t %fbpppiii   1
                  and  %00111000       ;]| 7t %00ppp000   2
                  rrca                 ;]| 4t %000ppp00   1
                  rrca                 ;]| 4t %0000ppp0   1
                  rrca                 ;]| 4t %00000ppp   1
                  or c                 ;]| 4t %00iii000   1
                  ld c,a               ;]| 4t %00iiippp   1 

                  ld a,b               ;]| 4t             1
                  and  %11000000       ;]| 7t %fb000000   2
                  or c                 ;]| 4t %00iiippp   1

                  ld (hl),a            ;]| 7t %fbiiippp   1
;tmcl  equ 7+4+7 +4+4+4+4 +4+7 +4+4+4+4+4 +4+7+4 +7 ; = 87 tstate

                  inc hl               ;]| 6t
                  dec e                ;]| 4t
                  jp nz,mcl            ;]|10t
t4b2  equ 7+4+7 +4+4+4+4 +4+7 +4+4+4+4+4 +4+7+4 +7  +6+4+10; =107

                  pop hl               ;]10t
                  ld bc,32             ;]10t
                  add hl,bc            ;]11t
                  dec d                ;] 4t
                  jp nz,mvcol          ;]10t    3x3 grid done ; 7+10 + 3*(11+7+ (3*107) +10+10+11+4+10)=1169  tstate (=5.272321429 scanlines)

t4    equ 7+10 + 3*(11+7+ (  3*t4b2 ) +10+10+11+4+10)
Tt4   equ Tt3  + t4   ;1943/224=8.674107143 = .674107143 =151.000000032  >  224-151=73t
Tot4  equ $           ;fuse 1943 equal
;delay fine tune on next scanline
                  scf                  ; 4t
                  ret nc               ; 5t
a8                ld a,22              ; 7t
hre               dec a                ; 4t
                  jr nz,hre            ;12t-5 = 24*16-5
                  ret nz               ; 5t complete last 16t step
t5a  equ 4+5 +7 +23*(4+12)-5+5 ;=384

bc5               ld b,0x1d            ;  7t b=29 scanlines
a13               nop                  ;  4t delay !!
                  nop                  ;  4t delay !!
                  ld a,14              ;  7t a=14
noa               dec a                ;  4t
                  jp nz,noa            ; 10t
                  djnz a13             ; 13t 4+4+7+14*(4+10)+13 = 224 per loop
                                       ; -5t
; 7+ 29*(4+4+7  +14*(4+10 ) +13) -5= 6498

t5b2  equ 14 *( 4+10 )
t5b   equ 7+ 29*(4+4+7 + t5b2 +13) -5
t5    equ t5a +t5b
Tt5   equ Tt4 + t5 ;8846 (fuse/8846)
Tot5  equ $

; Finaly set BorderTronColours set 1 and 2 aka old and new

                  ld bc,0x00fe        ; 10t keep b<0x40 or b>0x7f
                  ld de,0xc807        ; 10t
                  ld hl,$c880         ; 10t h=lines+8  l=128+0
borlin1 equ $-1                 ;      (defb 80,c8 ! l,h !)
                  exx                 ;  4t set LSB port BC save in alternate register set

twist             ld hl,twice         ; 10t
                  bit 0,(hl)          ; 12t carry cq nonzero ?
                  jp nz,oldc          ; 10t zflag touched, carry not

newc              ld hl,$8782         ;|10t   h=white   l= red
                  ld de,$8684         ;|10t   d=yellow  e= green
                  ld bc,$86FE         ;|10t(4,3,3)  b=yellow e8ast 12  c=prt254   portBC=0x86FE , above contention
                  jp coldo            ;|10t

oldc              ld hl,$8581         ;}10t   h=light blue l= darkblue
                  ld de,$8684         ;}10t   d=yellow     e= green
                  ld bc,$82FE         ;}10t(4,3,3)  b=red     c=prt254   portBC=0x82FE , above contention
                  jp coldo            ;}10t   timing delay
coldo:
                  ld a,128            ; 7t    a=black, the PORT is BC
backgrcol_1  equ $-1
t6 equ 7+10+10+4 +10+12+10 +10+10+10+10 +7

Tt6  equ Tt5 +t6   ; = 8925/224=39.84375  = .84375 = 224-189=35 tstate to few
Tot6 equ  $

scln40:           ; ScanLine 40*224=8960  , as we expected (??ok?) 
REPT 18
	          out (c),l           ; 12t(4,4,4)  ; blue line
ENDM
	          nop
	          nop                 ; 4t   = (18*12)+4+4=216+8=224

                  ; ScanLine 41
                  out   (c),a  ; black HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b  ; red
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h  ; lightblue
                  out   (c),h
                  out   (c),h
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 42
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 43
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 44
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 45
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),e
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 46
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),e
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),d  ;yellow  ;yellow
                  out   (c),h
                  out   (c),d  ;yellow  ;yellow
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 47
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),d  ;yellow
                  out   (c),h
                  out   (c),d  ;yellow
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 48
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 49
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 50
                  out   (c),d  ;yellow   HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),d  ;yellow HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 51
                  out   (c),d  ;yellow  HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),d  ;yellow HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 52
                  out   (c),d  ;yellow  HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),d  ;yellow HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 53
                  out   (c),d  ;yellow  HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),d  ;yellow HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 54
                  out   (c),d  ;yellow  HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),d  ;yellow
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),d  ;yellow HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 55
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 56
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 57
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 58
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 59
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 60
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),b
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 61
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),h  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 62
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 63, last line, setting once is enough, is free time!!
REPT 16
	          out (c),l    ;12t blue
ENDM
                  exx          ; 4t move colours aside, c=254 e=%10000111
                  scf          ; 4t Carry set for FURTHER DELAY !!!!


t7a  equ (16 * 12 ) +4+4
t7   equ (23 * 224) +t7a
Tt7  equ Tt6 + t7
Tot7 equ $

     nop
     nop
     nop
     nop

t8   equ 4+4+4+4
Tt8  equ Tt7 + t8
Tot8 equ $

; 14335 = 11 0111 1111 1111  111(7) = 000(0)  6t   0n-6t=-6 > 8n-6t= 2 ,8is4bit 1000 so borrow '1'
; 14336 = 11 1000 0000 0000  000(0) = 111(7)  5t   7n-5t= 2
; 14337 = 11 1000 0000 0001  001(1) = 110(6)  4t   6n-4t= 2
; Fully Contended Area, ScanLine 64  CONTENDED for 128 tstate> 128/8= 16 M_cycle

;--- replaced contentionline, 28 +128 +68, keeps changing time after time
lab:              ;t14276
                  ld    a,h           ;  4t
                  and   e             ;  4t switch off bit 6,5,4,3 beeper ticks/ear/mic
A_ou              out (c),a           ; 12t t 14296    colour, around border

; tstate=14335  delay= +6t, 2nd loop delay=+6?

                  cpl                 ;  4t 14300
                  and e               ;  4t 14304
                  out (c),a           ; 12t 14316 contention has started during OUT

nop
nop
nop
nop
nop
                  inc d               ;  4t
                  ld a,d              ;  4t
                  cp 0xc8             ;  7t
borlin3 equ $-1
                  jp nz,setc          ; 10t
                  ld d,8              ;  7t
borlin4 equ $-1
                  jp nand7            ; 10t

setc:             ld b,0              ;  7t BC=0x00fe 7t delay, possible SOUND INPUT ??????? waytomuch
                  jp nand7            ; 10t more delay


nand7             and e
                  out (c),a
                  out (c),b           ; 12t black

t9a   equ 6+4 +4+4 +4+4 +8+8+8 +8+8+8 +8+8+8 +8+8 +15  ;=128
Tot9a equ $
; Not contended for 96 tstates only

                  dec h               ;  4t
                  ld a,8              ;  7t last line+8
borlin2 equ $-1
                  cp h                ;  4t compare a high or low Areg
                  jp nz,lab           ; 10t  times 192 lines





t9b     equ 11+4+4+7 +5+5+5+5 +11+4+7 +4+12+12 ;=96
t9c     equ t9a + t9b
t9      equ 192 * t9c
Tt9     equ Tt8 + t9    ;=57339/57343
Tot9    equ $-3         ; 1 before full loop
Tot9b   equ $           ; T57339(fuse) lower border start
;     192*224=43,008 tstate
;(64+192)*224=57,344 tstate, t57339 = 5 tstate early

                  ; ScanLine 64+192=256
noncontended      ; last jump was NZ so RET NZ is safe as delay.
;                  rld                 ;18t DELAY
;                  inc de              ; 6t DELAY
                  inc de              ; 6t DELAY

                  exx                 ; 4t  fetch color scheme again
                  ld a,128            ; 7t  set a=black & high adres
backgrcol_3 equ $-1                   ; Zflag set so ret NZ=+5
t10 equ 4+7+4+5+5 ; = 25


A_scln256:   ; 15*12 +8= 188
                  out   (c),a 
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),b   ; cross wise color
                  out   (c),l   ; cross wise color
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
sb1                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop                  

                  ; ScanLine 257
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),l   ; cross wise color
                  out   (c),b   ; cross wise color
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
sb2                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop                  

; ScanLines 258-267
REPT 3
REPT 18
	          out (c),a  ; black
ENDM
	          nop
                  nop
ENDM
                  ; ScanLine 268
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 269
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 270
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 271
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 272
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 273
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 274
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),e  ; green
                  out   (c),e  ; green
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 275
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),e  ; green
                  out   (c),e  ; green
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 276
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),e  ; green
                  out   (c),e  ; green
                  out   (c),e  ; green
                  out   (c),e  ; green
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 277
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),e  ; green
                  out   (c),h  ;lblue
                  out   (c),h  ;lblue
                  out   (c),e  ; green
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 278
                  out   (c),a  ; black
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),e  ; green
                  out   (c),e  ; green
                  out   (c),h  ;lblue
                  out   (c),h  ;lblue
                  out   (c),e  ; green
                  out   (c),e  ; green
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; black
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),c  ; HIDDEN - Background sound bit
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 279
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),e  ; green
                  out   (c),h  ;lblue
                  out   (c),h  ;lblue
                  out   (c),h  ;lblue
                  out   (c),h  ;lblue
                  out   (c),e  ; green
                  out   (c),d  ;yellow
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 280
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),e  ; green
                  out   (c),e  ; green
                  out   (c),h  ;lblue
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),h  ;lblue
                  out   (c),e  ; green
                  out   (c),e  ; green
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                 out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop

                  ; ScanLine 281
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),d  ;yellow
                  out   (c),e  ; green
                  out   (c),h  ;lblue
                  out   (c),h  ;lblue
                  out   (c),a  ; black
                  out   (c),a  ; black
                  out   (c),h  ;lblue
                  out   (c),h  ;lblue
                  out   (c),e  ; green
                  out   (c),d  ;yellow
                  out   (c),b  ; red
                  out   (c),b  ; red
                  out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
sbx              out   (c),a  ; HIDDEN - Background
                  out   (c),a  ; HIDDEN - Background
                  nop
                  nop
; ScanLine 282 =224*282= 63168 T-state, should be
; all registers are 'free'

xee               ld a,(23672)        ; 13t 1/50 second
                  and %00011111       ;  7t
                  jp nz,nrdel         ; 10t jump 31 out of 32

brl1              ld hl,borlin1       ; 10t shift border rainbow
                  dec (hl)            ; 11t
                  ld a,(hl)           ;  7t
                  cp 192              ;  7t
                  jp nz,nra           ; 10t  10+11+7+7+10

                  ld (hl),192+8       ;|  7t
                  jr brl2             ;| 12t 7+12

nra:              ld a,(hl)           ;}  7t delay
                  jr brl2             ;} 12t delay

brl2              ld hl,borlin2       ; 10t
                  dec (hl)            ; 11t
                  ld a,(hl)           ;  7t
                  and a               ;  4t
                  jp nz,nra2          ; 10t   10+11+7+4+10

                  ld (hl),0+8         ;|  7t
                  jr compl            ;| 12t  7+12

nra2:             ld a,(hl)           ;}  7t delay
                  jr compl            ;} 12t delay 

borltm  equ  10+11+7+7+10 +7+12 +10+11+7+4+10 +7+12 ;=125

nrdel      ld b,9      ; 7t   flags:Z NC
del3       djnz del3   ;   (9*13)-5
           inc hl      ; 6t
                       ; 7+(9*13)-5+6 =125 delay on (not) border change


compl       ld hl,16384+2048+2048+16  ; 10t
            ld b,8                    ;  7t
cmpl        ld a,(hl)                 ;  7t
            cpl                       ;  4t
            ld (hl),a                 ;  7t
            inc h                     ;  4t
            djnz cmpl                 ; 13t

tcompl  equ 10+7+  8*(7+4+7+4+13)-5   ;=292 tstate


;which keys ARE pressed ? only one key EXECUTED per check

                  ld hl,twice         ; 10t
                  bit 0,(hl)          ; 12t
                  jp nz,kydel         ; 10t  only check and execute key result every 2nd frame

key_1             ld hl,keys+4        ; 10t
                  ld de,keys2+4       ; 10t
                  ex de,hl            ;  4t
                  bit 0,(hl)          ; 12t "1"
                  ex de,hl            ;  4t
                  jp nz,k2del         ;[] 10t if 0 key pressed
k1dtm equ 10+10 +4+12+4 +10 ;=50
                  bit 0,(hl)          ;[ 12t
                  jp z,key_2          ;[ 10t 12+10=22  if 0 key STIL pressed

                  ld hl,setline+1     ;  10t
                  ld a,(hl)           ;   7t
                  and %00011111       ;   7t a=31
                  dec a               ;   4t
                  cp %11111111        ;   7t
                  jp nz,c25           ;|} 10t
                  inc a               ;}  4t
                  jp c26              ;} 10t =14}

c25               ld b,(hl)           ;| 7t
                  ld b,(hl)           ;| 7t =14|

c26               ld c,a              ;  4t
                  ld a,(hl)           ;  7t
                  and %11100000       ;  7t
                  or c                ;  4t
                  ld (hl),a           ; 11t lower LSB from ATTR
                  jp nok              ; 10t =31t

k2del             ld a,i              ;] 9t
                  ld a,i              ;] 9t
                  nop                 ;] 4t =9+9+4=22
key_2             ex de,hl            ;  4t
                  bit 1,(hl)          ; 12t    "2"
                  ex de,hl            ;  4t
                  jp nz,k3del         ; 10t if 0 key pressed
k2dtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 1,(hl)          ; 12t
                  jp z,key_3          ; 10t if 0 key STIL pressed
                  ld hl,setline+1     ; 10t
                  ld a,(hl)           ;  7t
                  and %00011111       ;  7t a=31
                  inc a               ;  4t
                  cp 30               ;  7t
                  jp c,c25            ; 10t
                  dec a               ;} 4t
                  jp c26              ;}10t =14} finish like key1


k3del             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_3             ex de,hl            ; 4t
                  bit 2,(hl)          ;    "3"
                  ex de,hl            ; 4t
                  jp nz,k4del         ; if 0 key pressed
k3dtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 2,(hl)
                  jp z,key_4          ; if 0 key STIL pressed

                  ld bc,32            ; 10t
                  ld hl,(setline+1)   ; 10t
                  add hl,bc           ; 11t
                  ld a,h              ; 4t
                  cp 0x58+3           ; 7t
                  jp c,good           ; 10t
                  or a                ; 4t    strike carry-flag
                  sbc hl,bc           ;  
good              ld a,l              ;  7t
                  cp 192
                  jp c,gd2
                  sub c

                  jp gd2              ; 10t delay

gd2               ld (setline+1),hl   ;  7t
                  jp nok              ; 10t

k4del             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_4             ex de,hl            ;  4t
                  bit 3,(hl)          ;    "4"
                  ex de,hl            ;  4t
                  jp nz,k7del         ;    if 0 key pressed
k4dtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 3,(hl)
                  jp z,key_7          ;    if 0 key STIL pressed
                  ld bc,32
                  ld hl,(setline+1)     ; 10t
                  or a                 ;  4t
                  sbc hl,bc              ;  t
                  ld a,h
                  cp 0x58
                  jp nc,good          ; 10t
                  add hl,bc               ;  7t
                  jp gd2              ; 10t


k7del             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_7             inc hl              ; key+5
                  inc de              ; key2+5
                  ex de,hl            ; 4t new><old
                  bit 3,(hl)          ;   "7"
                  ex de,hl            ; 4t old><new
                  jp nz,k8del         ; if 0 key pressed
k7dtm equ 9+9+4 +6+6 +4+12+4+10 ; = 64
                  bit 3,(hl)
                  jp z,key_8          ; if 0 key STIL pressed

                  ld hl,a8+1
                  dec (hl)            ; 11t lower horizontal
                  jp nok              ; 10t only one key USED per check

k8del             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_8             ex de,hl            ; 4t new><old
                  bit 2,(hl)          ;   "8"
                  ex de,hl            ; 4t old><new
                  jp nz,k9del         ; if 0 key pressed
k8dtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 2,(hl)
                  jp z,key_9          ; if 0 key STIL pressed

                  ld hl,a8+1
                  inc (hl)            ; raise horizontal
                  jp nok              ; 10t only one key USED per check

k9del             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_9             ex de,hl            ; 4t
                  bit 1,(hl)          ;   "9"
                  ex de,hl            ; 4t
                  jp nz,k0del         ; if 0 key pressed
k9dtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 1,(hl)
                  jp z,key_0          ; if 0 key STIL pressed

                  ld hl,a13-1
                  dec (hl)            ; 11t lower 1 scan line
                  jp nok              ; 10t

k0del             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_0             ex de,hl            ; 4t
                  bit 0,(hl)          ;12t   "0"
                  ex de,hl            ; 4t
                  jp nz,kQdel         ; if 0 key pressed
k0dtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 0,(hl)          ;12t
                  jp z,key_Q          ; if 0 key STIL pressed

                  ld hl,a13-1
                  inc (hl)            ; raise 1 scanline
                  jp nok              ; 10t



; HLDEB color registers
kQdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_Q             ld hl,keys+3        ; 10t hl=newkey
                  ld de,keys2+3       ; 10t de=oldkey
                  ex de,hl            ;  4t
                  bit 0,(hl)          ; 12t "Q"
                  ex de,hl            ;  4t
                  jp nz,kWdel         ; 10t if 0 key pressed

kQdtm equ 9+9+4 +10+10 +4+12+4+10 ; = 72

                  bit 0,(hl)          ; 12t
                  jp z,key_W          ; 10t if 0 key STIL pressed

                  ld hl,newc+1        ; 10t L reg for color  
                  jp wrt_col          ; 10t

kWdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_W             ex de,hl            ; 4t key+3 ,hl=new, de=old
                  bit 1,(hl)          ;   "W"
                  ex de,hl            ; 4t        hl=old, de=new
                  jp nz,kEdel         ; if 0 key pressed
kWdtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 1,(hl)
                  jp z,key_E          ; if 0 key STIL pressed

                  ld hl,newc+2        ; H reg for color
                  jp wrt_col          ; 10t

kEdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_E             ex de,hl            ; 4t key+3
                  bit 2,(hl)          ;   "E"
                  ex de,hl            ; 4t
                  jp nz,kRdel         ; if 0 key pressed
kEdtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 2,(hl)
                  jp z,key_R          ; if 0 key STIL pressed

                  ld hl,newc+4        ; E reg for color
                  jp wrt_col          ; 10t

kRdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_R             ex de,hl            ; key+3
                  bit 3,(hl)          ; "R"
                  ex de,hl
                  jp nz,key_T         ; if 0 key pressed
kRdtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 3,(hl)
                  jp z,key_T          ; if 0 key STIL pressed

                  ld hl,newc+5        ; D reg for color
                  jp wrt_col          ; 10t

kTdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_T             ex de,hl            ; key+3
                  bit 4,(hl)          ; "T"
                  ex de,hl
                  jp nz,key_A         ; if 0 key pressed
kTdtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 4,(hl)
                  jp z,key_A          ; if 0 key STIL pressed

                  ld hl,newc+8        ; B reg for color
                  jp wrt_col          ; 10t


; new KEY-scanline = key+2
kAdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_A             dec hl
                  dec de
                  ex de,hl           ; key+2
                  bit 0,(hl)          ;12t "A"
                  ex de,hl
                  jp nz,key_S         ; if 0 key pressed
kAdtm equ 9+9+4 +6+6 +4+12+4+10 ; = 64
                  bit 0,(hl)          ;12t
                  jp z,key_S          ; if 0 key STIL pressed

                  ld hl,oldc+1        ; L reg for color
                  jp wrt_col

kSdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_S             ex de,hl            ; key+2 ,hl=new, de=old
                  bit 1,(hl)          ; "S"
                  ex de,hl            ;        hl=old, de=new
                  jp nz,key_D         ; if 0 key pressed
kSdtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 1,(hl)
                  jp z,key_D          ; if 0 key STIL pressed

                  ld hl,oldc+2        ; H reg for color
                  jp wrt_col

kDdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_D             ex de,hl            ; key+2 ,hl=new, de=old
                  bit 2,(hl)          ; "D"
                  ex de,hl            ;        hl=old, de=new
                  jp nz,key_F         ; if 0 key pressed
kDdtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 2,(hl)
                  jp z,key_F          ; if 0 key STIL pressed

                  ld hl,oldc+4        ; E reg for color
                  jp wrt_col

kFdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_F             ex de,hl            ; key+2 ,hl=new, de=old
                  bit 3,(hl)          ; "F"
                  ex de,hl            ;        hl=old, de=new
                  jp nz,key_G         ; if 0 key pressed
kFdtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 3,(hl)
                  jp z,key_G          ; if 0 key STIL pressed

                  ld hl,oldc+5        ; D reg for color
                  jp wrt_col

kGdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_G             ex de,hl            ;  4t key+2 ,hl=new, de=old
                  bit 4,(hl)          ; 12t "G"
                  ex de,hl            ;  4t hl=old, de=new
                  jp nz,kZdel        ; 10t if 0 key pressed
kGdtm equ 9+9+4 +4+12+4+10 ; = 52
                  bit 4,(hl)          ; 12t
                  jp z,key_Z            ; 10t if 0 key STIL pressed
                  ld hl,oldc+8        ; 10t H reg for color
                  jp wrt_col          ; 10t delay until more code entered between $here and 'wrt_col'


wrt_col           inc (hl)            ; 11t 
                  ld a,%10000111      ;  7t 128+colour
                  and (hl)            ;  7t mask colour
                  ld (hl),a           ;  7t write in
                  jp nok2             ; 10t            11+7+7+7+10 =6*7 = 42



; new KEY-scanline = key+1
kZdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_Z             dec hl
                  dec de
                  ex de,hl           ; key+2
                  bit 0,(hl)          ;12t "A"
                  ex de,hl
                  jp nz,key_X         ; if 0 key pressed
kZdtm equ 9+9+4 +6+6 +4+12+4+10 ; = 64
                  bit 0,(hl)          ;12t
                  jp z,key_X          ; if 0 key STIL pressed

                  call yellowC
                  jp nok


kXdel             ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22
key_X             ex de,hl            ; key+2 ,hl=new, de=old
                  bit 1,(hl)          ; "S"
                  ex de,hl            ;        hl=old, de=new
                  jp nz,nokdel        ; if 0 key pressed
kXdtm equ 9+9+4 +4+12+4+10            ; = 52
                  bit 1,(hl)
                  jp z,nok            ; if 0 key STIL pressed

                  call yellowD
                  jp nok


kydel             ld a,61             ;  7t
noa2              dec a               ;  4t
                  jr nz,noa2          ; 10t 61*(4+12)
                                      ; 7+ 61*(4+12)-5=978

Knumdtm  equ k1dtm + k2dtm + k3dtm + k4dtm + k7dtm + k8dtm + k9dtm + k0dtm
Kchrdtm  equ kQdtm + kWdtm + kEdtm + kRdtm + kTdtm + kAdtm + kSdtm + kDdtm + kFdtm + kGdtm
Kchr2dtm equ kZdtm + kXdtm
Kalldtm  equ Knumdtm + Kchrdtm + Kchr2dtm

nokdel            ld a,i              ;  9t
                  ld a,i              ;  9t
                  nop                 ;  4t =9+9+4=22

nok               rld                 ; 18t contra_delay for 'wrt_col'
                  rrd                 ; 18t delay SAME WAY BACK
                  inc bc              ;  6t delay BCnot used Now! 18+18+6=42
nok2              jp  BorderLoop      ; 10t keep looping without system!


ReturnToBASIC:    di
                  ld a,$3F
                  ld i,a
                  im 1
                  ei
                  pop hl
                  exx
                  ret

sbmiddle equ sb2-sb1                 
yellowC          ld hl,(adsound)
                 ld de,sb1
                 ld bc,38
                 or a            ; strike flags
                 sbc hl,bc

                 call compare
                 jr c,chan2
                 or a            ; delay
                 add hl,bc

chan2            ld (hl),0x49    ; (c),c
                 ld (adsound),hl
                 ret

yellowD          ld hl,(adsound)
                 ld de,sbx
                 ld bc,38
                 or a             ; delay
                 add hl,bc
                 call compare
                 jr c,chan1
                 or a            ; its NC ?? 'or a' can be avoided
                 sbc hl,bc

chan1            ld (hl),0x51    ; (c),d
                 ld (adsound),hl
                 ret





; 16bit compare high/low
;comparex:
;            ex de,hl
;            call compare
;            ex de,hl
;            ret                ; Carry HL highest, zero hl=de, NZ+NC=DE highest

; its not a real compare, but it works
compare      or a              ; reset ALL flags (incl carry to noncarry)
             push hl              ; save hl
             sbc hl,de            ; substract (with carry=0) from hl
             pop hl               ; restore begin value hl
             ret                ; Carry DE highest, zero hl=de, NZ+NC=HL highest


adsound          defw sbx



; Cs+ z+ x+ c+ v  keys +1
;  a+ s+ d+ f+ g  keys +2
;  q+ w+ e+ r+ t  keys +3
;  1+ 2+ 3+ 4+ 5  keys +4
;--0--1--2--3--4--bitposition
;  0+ 9+ 8+ 7+ 6  keys +5
;  p+ o+ i+ u+ y  keys +6
; En+ l+ k+ j+ h  keys +7
; Sp+Ss+ m+ n+ b  keys +8


numstr            defm 0,22,1,0,16,9,17,8,"0123456789ABCDE><EDCBA9876543210",255
SetupIntHandler:  di
screen            call 0x0d6b             ; clear bitmap
                  ld hl,16384
                  ld de,16385
                  ld bc,1024
                  push bc

                  ld a,%00001111
                  ld (hl),a
                  ldir
                  cpl
                  ld (hl),a
                  pop bc
                  ldir

                  ld a,%00110011
                  ld b,4
blocks            push bc
                  ld (hl),a
                  ld bc,512
                  ldir
                  cpl
                  pop bc
                  djnz blocks

                  ld a,%01010101
                  ld b,8
spix              push bc
                  ld (hl),a
                  ld bc,256
                  ldir
                  cpl
                  pop bc
                  djnz spix

ihl               inc hl

;colourwrap       ; replace for sm_attr routine
                  ld hl,attr
phl               push hl
                  ld bc,32
                  ld d,3
moink             ld e,8
numbr             ld a,7         ; bright 0, paper 0, ink 7
ink0              ld (hl),a
                  add hl,bc
                  dec a         
                  dec e
                  jr nz,ink0
                  dec d
                  jr nz,moink

                  pop hl
                  inc hl

                  ld a,l         ; l raises and so does paper
                  and %00001110  ; STEP 2, carry reset
                  rlca           ; %00011100
                  rlca           ; %00111000
                  ld b,a

                  ld a,(numbr+1)
                  and %11000111  ; exclude PAPER
                  or b           ; write PAPER
                  xor 64         ; bright on/off
                  ld (numbr+1),a

                  ld a,31
                  cp l           ; on l=32 Carry set
                  jr nc,phl      ;

                  call print

; EI and RET at $6464
                  ld a,i
                  cp $63
                  jr z,imset           ; assume all set and return
; on 16k the vector table COULD be the printerbuffer,0x5B00 as long as 0x5C00 is re-written correctly OR basic a.k.a. 0x0038 is avoided!!
; Put interrupt vector table at $5B00
                  ld a,0x64            ; msb of 0x6464
intjump equ $-1
                  ld hl,$5B00
inttable equ $-2
                  ld (hl),a
                  ld a,h
                  push hl
                  pop de
                  inc de
                  ld bc,$0100          ; 256+1
                  ldir



kend              ld i,a               ; a= h MSB jumptable
                  im 2
imset             ei

dummy             ret                  ; set 'dummy' for empty CALLs without changing length of code


;print font
print             ld hl,numstr+8
;line
ldach             ld a,(hl)
                  cp 255
                  ret z
                  call prchr
                  inc hl
                  jr ldach

; chr$
prchr             push hl
                  sub ' '
                  ld h, 0
                  ld l, a
                  add hl, hl
                  add hl, hl
                  add hl, hl
                  ex de,hl
                  ld hl,(23606)
                  inc h
                  add hl,de
scradr            ld de,16384    ; rewritten after chr$
                  ld  b,8
foscr             ld c,(hl)
                  ld a,(de)
xcor              xor c          ; eg change to: xor c , and c , or c , and a (no change), ld a,c (pure font)
                  ld (de),a
                  inc d
                  inc hl
                  djnz foscr
                  ld hl,scradr+1
                  inc (hl)       ; next chr cell on this screen-BLOCK
                  pop hl
                  ret

; https://worldofspectrum.org/forums/discussion/comment/214851/#Comment_214851
; Z80 delay routine, but must be UNcontended !!!!!
; by Jan Bobrowski, license GPL
; wait bc T (including call; bc>=141)
; destroys: af, bc, hl

; can i use it on 16k model???
; no reading or writing adresses helps. no IN nor OUTs helps, working AFTER screen build of 64+192+24 scanlines helps
; using as sync time for 2x left_over_time ??? 25 x 2 frames, hope so.

usedtime equ 0                  ;    temporair value
                  ld bc,usedtime;10t

calcdelay:                      ;    more overheadtime
                  or a          ; 4t carry DOWN , NC
                  ld hl,65535   ;10t max countable tstate in 16bit, 1frame = 65536 + 4352 > 0-65535
                  sbc hl,bc     ;15t    SCF:65535-bc-1 ?? is not 65536-(bc-1)
                  ld b,h        ; 4t
                  ld c,l        ; 4t bc=left time HOPEFULLEY, if i know how to calc it correctly, 'ofset 4352' 'scf'
overhead equ  -1  * (141+4+10+10+15+4+4) ; adding a negative number is faster then subtrackting a positive number; tstate * -1

BIGDELAY:
                  ld      hl,overhead
bigdel2           add     hl,bc
                  ld      bc,-23
loop              add     hl,bc
                  jr      c,loop
                  ld      a,l
                  add     a,15
                  jr      nc,g0
                  cp      8
                  jr      c,g1
                  or      0
g0                inc     hl
g1                rra
                  jr      c,b0
                  nop
b0                rra
                  jr      nc,b1
                  or      0
b1                rra
                  ret     nc
                  ret


the               end 25700


;not compiled
;small 1/6 screen ATTR , actualy counting 0 to 127 in another following order
smattr            defb      7, 71, 15, 79, 23, 87, 31, 95, 39,103, 47,111, 55,119, 63,127
                  defb      6, 70, 14, 78, 22, 86, 30, 94, 38,102, 46,110, 54,118, 62,126
                  defb      5, 69, 13, 77, 21, 85, 29, 93, 37,101, 45,109, 53,117, 61,125
                  defb      4, 68, 12, 76, 20, 84, 28, 92, 36,100, 44,108, 52,116, 60,124
                  defb      3, 67, 11, 75, 19, 83, 27, 91, 35, 99, 43,107, 51,115, 59,123
                  defb      2, 66, 10, 74, 18, 82, 26, 90, 34, 98, 42,106, 50,114, 58,122
                  defb      1, 65,  9, 73, 17, 81, 25, 89, 33, 97, 41,105, 49,113, 57,121
                  defb      0, 64,  8, 72, 16, 80, 24, 88, 32, 96, 40,104, 48,112, 56,120

bitwave: ; from UDS, http://blogs.myspace.com/monoinmike 'quds.asm'
ad33024     defb       1, 128,   3, 134,   5, 140,   7, 146  ;
            defb       9, 151,  11, 155,  13, 158,  15, 159;  
            defb      17, 160,  19, 159,  21, 157,  23, 154;  
            defb      25, 150,  27, 145,  29, 140,  31, 134;  
            defb      33, 127,  35, 121,  37, 115,  39, 109;  
            defb      41, 105,  43, 101,  45,  98,  47,  96;  
            defb      49,  96,  51,  97,  53,  99,  55, 102;  
            defb      57, 106,  59, 111,  61, 117,  63, 123;  
            defb      65, 130,  67, 136,  69, 142,  71, 147;  
            defb      73, 152,  75, 156,  77, 158,  79, 160;  
            defb      81, 160,  83, 159,  85, 157,  87, 153;  
            defb      89, 149,  91, 144,  93, 138,  95, 132;  
            defb      97, 126,  99, 119, 101, 114, 103, 108;  
            defb     105, 104, 107, 100, 109,  98, 111,  96;  
            defb     113,  96, 115,  97, 117, 100, 119, 103;  
            defb     121, 108, 123, 113, 125, 119, 127, 125;  
            defb     129, 131, 131, 137, 133, 143, 135, 148;  
            defb     137, 153, 139, 156, 141, 159, 143, 160;  
            defb     145, 160, 147, 158, 149, 156, 151, 152;  
            defb     153, 148, 155, 142, 157, 137, 159, 130;  
            defb     161, 124, 163, 118, 165, 112, 167, 107;  
            defb     169, 103, 171,  99, 173,  97, 175,  96;  
            defb     177,  96, 179,  98, 181, 100, 183, 104;  
            defb     185, 109, 187, 114, 189, 120, 191, 126;  
            defb     193, 133, 195, 139, 197, 145, 199, 150;  
            defb     201, 154, 203, 157, 205, 159, 207, 160;  
            defb     209, 160, 211, 158, 213, 155, 215, 151;  
            defb     217, 147, 219, 141, 221, 135, 223, 129;  
            defb     225, 122, 227, 116, 229, 111, 231, 106;  
            defb     233, 102, 235,  99, 237,  97, 239,  96;  
            defb     241,  97, 243,  98, 245, 101, 247, 105;  
            defb     249, 110, 251, 116,   0,  24,   0,  24;  

