;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;______________________________________________________
;
;
;             zen (256b intro)
;
;______________________________________________________
;
;	CODE:	        svoy
;        GFX:           piesiu
;______________________________________________________
;
;         DiHalt 2021
;         Atari XL/XE intro (256b)
;______________________________________________________
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Cracow

STARTX	equ $80 ; tree pos X
STARTY	equ $81 ; tree pos Y
WIDTH	equ $82 ; base width of the tree (main trunk)
RWIDTH	equ $83 ; current width of the tree, with edge 
HEIGHT	equ $84
;TRCNT	equ $85
TREDAT	equ $86
;XPOS1	equ $87
;XPOS2	equ $88
;YPOS1	equ $89
;LCOUNT	equ $8a
XPOS2	equ $8a
LADD	equ $8b


;PMBASE	equ $7000 
PMBASE	equ $7800
ZENP	equ $6000
;ZENP	equ $5a00
ZENPB	equ $4000-64



; OS addresses:
VCOUNT	equ $D40B
WSYNC	equ $D40a

ROWCRS	equ $54		;Row of cursor, 1 byte
COLCRS	equ $55		;Column of cursor, 2 bytes

OLDROW  equ $5A
OLDCOL  equ $5B     ; 2 bytes
FILFLG 	equ $2B7
FILDAT 	equ $2fD

VVBLKD  equ $0224
XITVBV  equ $e462

; Aliases, because orig reg names are hard to remember ;)
PCOLOR	    equ $2fb	;Color for graphics operations
cursor_y    equ ROWCRS
cursor_x    equ COLCRS
prev_y      equ OLDROW
prev_x      equ OLDCOL

; OS functions
drawto    equ $f9c2

	opt h+	
	
	;org $2000
	org $90
coldat	dta b(112,127)
indir1	dta b($50,$60); used in 2 indirect calls (3b savings), $5080, $6050
	dta (15,6,2,2); PMG colors
	dta b(1,1); PMG sizes
indir2	dta b(0,$60,0); 1 indirect call $6000
partic	dta b($40,$60); used in 2 another indirect calls, $6040, $4000
	dta (15); GRAFM for missles
inctab	dta b(1,2,3,4,4,3,2); 1); 1 taken from zendat
zendat 	dta b(1,3,3,3,129,198,143,111,127,59,19,7,15,31,31,14); from Piesiu
	
	; left absolute adresses:
	; sta $5001,y - handled with ZP data
	; lda ZENPB+16+64,y ; $4000-64+16+64 = $4000+16 = $4010
; program entry point
start:
	; create/setup mode f, using OS routines, and we are going to mess with it later (multimode, move to a different place in memory)
	lda #15 ; 
	jsr $EF9C
				
	; Y=1h	
	sty PCOLOR
	
	inc $26f ; PMG priority
	
	;tay
	; generate nice looking sky gradient, from blue to light blue	
skygen:
	tya
	lsr
	lsr
	pha
	lsr
	;php ; POT1, but sky  a bit worse	
	sta LADD ; to be used later for lower part	
	cpy $D20a
	bcc usepink
	ora #$70 ; top color 
	sbc #1	; less black, but upper part is a bit worse
	;adc #1 ; original, lot of black stripes on the horizon
	;bne donebrown
	.BYTE $2C ;0 effectively skips the usepink section
usepink:	
	ora #$81 ; bottom/horizon color	
donebrown:		
	;sta $5001,y ; this will be used in main frame loop below
	sta ($63),y	
	;sta (indir1),y ; this will be used in main frame loop below

	;now the bottom/land part, just grass
	;tya
	;lsr
	;lsr
	pla
	lsr
	;plp	
	;sta LADD	
	lda #$cf ; grassy ground
	sbc LADD
	;eor #$FF ; but the sky looks worse?; POT2	
	;adc #$cf
	;sta $5000+128,y
	sta (indir1-1),y ; 1b saved vs absolute version above

; randomize particle positions
	tya	
	asl
	asl	
	and #%00111111
	adc #96
	;sta ZENP,y
	sta (indir2),y
	;sta ZENPB-1,y; make it offseted ; not needed, will be nicely repopulated by rotation		
	iny	
	bpl skygen
	
	
	;lda XPOS1; start with 42, so it can be used for initializations
	lda #42
	;pha ; use it as XPOS1 later on
	sta $22f ; DMACTL
	sta $D01D ; GRACTL, 1+2 for missles and players	
	
linedraw:
	; vertical
	;lda XPOS1
	;pla
	sta prev_x
	adc #5
	;sta XPOS1
	pha	
	;lda XPOS2
	;sta cursor_x	
	;clc	
	;adc #11
	;sta XPOS2
	lda cursor_x ; assuming we start with 0 at cursor_x
	adc #10	
	sta cursor_x
	lda #122
	sta $D407 ; PMBASE ; at $70, so above DOS area		
	sta prev_y
	lda #190	
	sta cursor_y
	jsr drawto
	; pmg copy part
	ldx start+1
	lda zendat,x	
	sta PMBASE+768+80,x ; left side
	ldy #7
roller:	
	;ror zendat,x
	ror ; POT1, but some dirty line in the very beginning...
	rol PMBASE+896+80,x ; mirrored right side
	dey
	bpl roller
; now colors setup. PMG sizes, GRAFM, etc.
	lda coldat,x ; big init loop
	sta $D002,x
	;sta $2c0-11,x
	sta $2c0-4,x ; for colors/shadows
	pla ; to be used as XPOS1 at the beginning of the loop
	dec start+1
	bpl linedraw
			
; setup PMG:
;     Turn off the playfield                           0
;     Use narrow playfield                             1
;     Use normal playfield                             2
;     Use wide playfield                               3
;     Enable missile DMA                               4
;     Enable player DMA                                8
;     Enable both player and missile DMA              12
;     Single line player resolution                   16
;     Enable DMA Fetch instructions                   32

	;lda #42
;	lda #2+8+32
;	sta $22f ; DMACTL
;	sta $D01D ; GRACTL, 1+2 for missles and players
;	sta $D407 ; PMBASE ; at $28

			
frame:
	ldx VCOUNT ; X=0 used in several effects reached by jsr	
	bne frame	
skyloop:
; colors	
	;lda $5000-8,x
	lda $5000-8,x	
	sta WSYNC ; 3b
	sta $D01a ; 3b
	sbc #1	
	sta $D016 ; 3b	
; particles
	txa
	lsr
	lsr
	tay
	;lda ZENP+16+64,y
	lda (indir1),y	
	sta $D004 ; missle front
	lda ZENPB+16+64,y
	;lda (partic-1),y	
	sta $D005 ; missle back
	inx 
	bne skyloop
; update particles
	lda 20 ; use RTCLOCK, and every 2nd frame move the particles
	ror	
	bcc frame	
	;Y=64 ; from the skyloop above
updatepart:
	;clc ; this and then comment 2xSEC (POT1), but the particiles uglier	
	lda (partic),y
	sec ; POT1
	sbc #96
	lsr
	lsr
	lsr
	tax
	lda (partic),y
	adc inctab,x
	cmp #160
	bcc notreached
	sbc #64
	sta (partic-1),y
	;beq skipzerof ; looks like not needed?	
notreached:	
	sta (partic),y	
skipzerof:	
; now the back particles part	
	lda (partic-1),y
	sec ; POT1
	sbc #96
	lsr
	lsr
	lsr
	tax
	lda (partic-1),y		
	sbc inctab,x
	cmp #96	
	bcs notlower		
	adc #64
notlower:
	sta (partic-1),y
skipzerob:		 
	dey
	bpl updatepart	
	bne frame ; wait for new frame

	run start
	
	end	
		
	