
;Keyboard macro recorder v1.0 by Pex Mahoney Tufvesson
;Runs using IRQ with kernal enabled

;Press shift + F1 to start recording. Press shift+F1 to stop recording. Press F1 to replay recorded macro.
;Press shift + F3 to start recording. Press shift+F3 to stop recording. Press F3 to replay recorded macro.
;Press shift + F5 to start recording. Press shift+F5 to stop recording. Press F5 to replay recorded macro.
;Press shift + F7 to start recording. Press shift+F7 to stop recording. Press F7 to replay recorded macro.

; This source code is used on your own risk.
; It's not written to be readable, only usable.
; ...and yes, you can crash the program by recording too many keys.

; The tool was used to produce the music video to my song
; Load Error (feat. Jesper of Press Play On Tape) - released with the music collection
; The Sound of Scenesat vol. 6

; For more information, have a look at
; https://sound.of.scenes.at
; Released on Spotify, Bandcamp, etc somewhere in August 2021.

; Have a noise night! / Pex "Mahoney" Tufvesson

      processor 6502
      org $0801
      ;basic sys line
      dc.b $0b,$08,$00,$00,$9e,$32,$30,$36
      dc.b $31,$00,$00,$00

basic_start:
; Move code into $c000-$cfff, away from other BASIC stuff.
  ldx #0
moveit:
  lda stuff_to_move + $000,x
  sta destination   + $000,x
  lda stuff_to_move + $100,x
  sta destination   + $100,x
  lda stuff_to_move + $200,x
  sta destination   + $200,x
  lda stuff_to_move + $300,x
  sta destination   + $300,x
  lda stuff_to_move + $400,x
  sta destination   + $400,x
  lda stuff_to_move + $500,x
  sta destination   + $500,x
  lda stuff_to_move + $600,x
  sta destination   + $600,x
  lda stuff_to_move + $700,x
  sta destination   + $700,x
  lda stuff_to_move + $800,x
  sta destination   + $800,x
  lda stuff_to_move + $900,x
  sta destination   + $900,x
  lda stuff_to_move + $a00,x
  sta destination   + $a00,x
  lda stuff_to_move + $b00,x
  sta destination   + $b00,x
  lda stuff_to_move + $c00,x
  sta destination   + $c00,x
  lda stuff_to_move + $d00,x
  sta destination   + $d00,x
  lda stuff_to_move + $e00,x
  sta destination   + $e00,x
  lda stuff_to_move + $f00,x
  sta destination   + $f00,x
  inx
  bne moveit
  jmp basic_start_addr

org $0900
stuff_to_move:
rorg $c000
destination:

init:
;Don't print anything if the user does SYS 49152
  lda #0
  sta recording_into+1
basic_start_addr:
  sei
  lda #<irq
  sta $0314
  lda #>irq
  sta $0315
  cli
  rts

;IRQ handler when kernal is on:
;.,FF48 48       PHA PULS   PHA
;.,FF49 8A       TXA        TXA
;.,FF4A 48       PHA        PHA
;.,FF4B 98       TYA        TYA
;.,FF4C 48       PHA        PHA
;.,FF4D BA       TSX        TSX
;.,FF4E BD 04 01 LDA $0104,X        LDA $104,X      ;GET OLD P STATUS
;.,FF51 29 10    AND #$10         AND #$10        ;BREAK FLAG?
;;  check bit 4 to determine HW or SW interrupt
;.,FF53 F0 03    BEQ $FF58        BEQ PULS1       ;...NO
;.,FF55 6C 16 03 JMP ($0316)        JMP (CBINV)     ;...YES...BREAK INSTR
;.,FF58 6C 14 03 JMP ($0314)

irq:
; This is replacing the code from $ea31-
memEA31:
  JSR $FFEA ;UPDATE JIFFY CLOCK
  LDA $CC   ;LDA BLNSW       ;BLINKING CRSR ?
  BNE memEA61 ;BNE KEY4        ;NO
  DEC $CD   ;DEC BLNCT       ;TIME TO BLINK ?
  BNE memEA61 ;       BNE KEY4        ;NO
  LDA #$14  ;       ;RESET BLINK COUNTER
  STA $CD   ; REPDO  STA BLNCT
  LDY $D3   ;     LDY PNTR        ;CURSOR POSITION
  LSR $CF   ;     LSR BLNON       ;CARRY SET IF ORIGINAL CHAR
  LDX $0287 ;       LDX GDCOL       ;GET CHAR ORIGINAL COLOR
  LDA ($D1),Y  ;      LDA (PNT)Y      ;GET CHARACTER
  BCS memEA5C   ;     BCS KEY5        ;BRANCH IF NOT NEEDED
  INC $CF       ; INC BLNON       ;SET TO 1
  STA $CE       ; STA GDBLN       ;SAVE ORIGINAL CHAR
  JSR $EA24     ;   JSR SCOLOR
  LDA ($F3),Y   ;     LDA (USER)Y     ;GET ORIGINAL COLOR
  STA $0287     ;   STA GDCOL       ;SAVE IT
  LDX $0286     ;   LDX COLOR       ;BLINK IN THIS COLOR
  LDA $CE       ; LDA GDBLN       ;WITH ORIGINAL CHARACTER
memEA5C:
  EOR #$80  ;      ;BLINK IT
  JSR $EA1C ;       JSR DSPP2       ;DISPLAY IT
memEA61:
  LDA $01   ;       LDA R6510       ;GET CASSETTE SWITCHES
  AND #$10      ;   AND #$10        ;IS SWITCH DOWN ?
  BEQ memEA71   ;     BEQ KEY3        ;BRANCH IF SO
  LDY #$00  ;LDY    #0
  STY $C0    ;    STY CAS1        ;CASSETTE OFF SWITCH
  LDA $01     ;   LDA R6510
  ORA #$20     ;    ORA #$20
  BNE memEA79   ;     BNE KL24        ;BRANCH IF MOTOR IS OFF
memEA71:
  LDA $C0       ;KEY3   LDA CAS1
  BNE memEA7B   ;     BNE KL2
  LDA $01       ; LDA R6510
  AND #$1F      ;   AND #%011111    ;TURN MOTOR ON
memEA79:
  STA $01       ; STA R6510
memEA7B:

  ldx $c6
  stx old_nof_keys+1
  JSR $EA87     ;KL2    JSR SCNKEY      ;SCAN KEYBOARD

; And this is where we need to grab the keys from the keyboard buffer - before anything in the main thread can see it.

recording_into:
  ldx #$88
  bpl not_replaying_anything

  jsr peek_a_byte
  cmp frame_no_LSB
  bne no_new_char_this_frame

  inc replay_addr+1
bne nowr3
  inc replay_addr+2
nowr3:
  jsr peek_a_byte
; Check for the end marker:
  cmp #0
  bne no_end_this_time
  lda #0
  sta recording_into+1
  lda #$e
  sta $d020
  jmp end_the_irq

no_end_this_time:
  ldx $c6
  sta $0277,x
  inc $c6
  inc replay_addr+1
bne nowr4
  inc replay_addr+2
nowr4:
  lda #1
  sta frame_no_LSB
  lda #0
  sta frame_no_MSB
  jmp end_the_irq

no_new_char_this_frame:
  inc frame_no_LSB
  bne nowr6
  inc frame_no_MSB
nowr6:
  jmp end_the_irq

not_replaying_anything:
  beq not_recording_anything

old_nof_keys:
  ldx #0
are_we_done_yet:
  cpx $c6
  beq no_new_keys

  lda frame_no_LSB
  jsr store_it
;Then read $0277- for the chars.   $52 = R  $55 = U   $55 = N    $0d = enter
  lda $0277,x
  cmp #$89
  beq end_record
  cmp #$8a
  beq end_record
  cmp #$8b
  beq end_record
  cmp #$8c
  beq end_record
  jsr store_it
  lda #0
  sta frame_no_LSB
  sta frame_no_MSB
  inx
  jmp are_we_done_yet

end_record:
  lda #$0
  jsr store_it
  lda #$0
  jsr store_it
  lda #0
  sta recording_into+1
  lda #$e
  sta $d020
;  jmp no_new_keys

no_new_keys:
  inc frame_no_LSB
  bne nowr2
  inc frame_no_MSB
;but don't allow more than 255 frames between keys:
  lda #$0
  jsr store_it
  lda #$0
  jsr store_it
  lda #0
  sta recording_into+1
  lda #$e
  sta $d020
nowr2:

end_the_irq:
  LDA $DC0D  ;KPREND LDA D1ICR       ;CLEAR INTERUPT FLAGS
  PLA        ; PLA             ;RESTORE REGISTERS
  TAY        ; TAY
  PLA        ; PLA
  TAX        ; TAX
  PLA        ; PLA
  RTI 

store_it:
store_addr:
  sta $cf00
  inc store_addr+1
  bne nowrap
  inc store_addr+2
nowrap:
  rts

not_recording_anything:
  ldx old_nof_keys+1
are_we_done_yet2:
  cpx $c6
  beq no_new_keys2
  lda $0277,x
  cmp #$89
  bne no_F2
  lda #>keybuf_F1
  ldy #1
  jmp start_recording
no_F2:
  cmp #$8a
  bne no_F4
  lda #>keybuf_F3
  ldy #2
  jmp start_recording
no_F4:
  cmp #$8b
  bne no_F6
  lda #>keybuf_F5
  ldy #3
  jmp start_recording
no_F6:
  cmp #$8c
  bne no_F8
  lda #>keybuf_F7
  ldy #4

start_recording:
start_replaying:
  sta store_addr+2
  sta replay_addr+2
  sty recording_into+1
  lda #0
  sta store_addr+1
  sta replay_addr+1
  sta frame_no_LSB
  sta frame_no_MSB
  jmp done_with_start_checking

no_F8:
  cmp #$85
  bne no_F1
  lda #>keybuf_F1
  ldy #$85
  jmp start_replaying
no_F1:
  cmp #$86
  bne no_F3
  lda #>keybuf_F3
  ldy #$86
  jmp start_replaying
no_F3:
  cmp #$87
  bne no_F5
  lda #>keybuf_F5
  ldy #$87
  jmp start_replaying
no_F5:
  cmp #$88
  bne no_F7
  lda #>keybuf_F7
  ldy #$88
  jmp start_replaying
no_F7:

done_with_start_checking:
  inx
  jmp are_we_done_yet2

no_new_keys2:
  jmp end_the_irq

frame_no_LSB: .byte 0
frame_no_MSB: .byte 0

peek_a_byte:
replay_addr:
  lda keybuf_first
  rts

;C:$e5d4) d ea31
;.C:ea31  20 EA FF    JSR $FFEA
;.C:ea34  A5 CC       LDA $CC
;.C:ea36  D0 29       BNE $EA61
;.C:ea38  C6 CD       DEC $CD
;.C:ea3a  D0 25       BNE $EA61
;.C:ea3c  A9 14       LDA #$14
;.C:ea3e  85 CD       STA $CD
;.C:ea40  A4 D3       LDY $D3
;.C:ea42  46 CF       LSR $CF
;.C:ea44  AE 87 02    LDX $0287
;.C:ea47  B1 D1       LDA ($D1),Y
;.C:ea49  B0 11       BCS $EA5C
;.C:ea4b  E6 CF       INC $CF
;.C:ea4d  85 CE       STA $CE
;.C:ea4f  20 24 EA    JSR $EA24
;.C:ea52  B1 F3       LDA ($F3),Y
;.C:ea54  8D 87 02    STA $0287
;.C:ea57  AE 86 02    LDX $0286
;.C:ea5a  A5 CE       LDA $CE
;.C:ea5c  49 80       EOR #$80
;.C:ea5e  20 1C EA    JSR $EA1C
;.C:ea61  A5 01       LDA $01
;.C:ea63  29 10       AND #$10
;.C:ea65  F0 0A       BEQ $EA71
;.C:ea67  A0 00       LDY #$00
;.C:ea69  84 C0       STY $C0
;.C:ea6b  A5 01       LDA $01
;.C:ea6d  09 20       ORA #$20
;.C:ea6f  D0 08       BNE $EA79
;.C:ea71  A5 C0       LDA $C0
;.C:ea73  D0 06       BNE $EA7B
;.C:ea75  A5 01       LDA $01
;.C:ea77  29 1F       AND #$1F
;.C:ea79  85 01       STA $01
;.C:ea7b  20 87 EA    JSR $EA87
;.C:ea7e  AD 0D DC    LDA $DC0D
;.C:ea81  68          PLA
;.C:ea82  A8          TAY
;.C:ea83  68          PLA
;.C:ea84  AA          TAX
;.C:ea85  68          PLA
;.C:ea86  40          RTI

keybuf_first:
; keyboard macro tool v1.0
; by pex mahoney tufvesson
; press F1 for instructions
; ready.
  .byte $01,$4b,$01,$45,$01,$59,$01,$42,$01,$4f,$01,$41,$01,$52,$01,$44  ; !K.E.Y.B.O.A.R.D
  .byte $01,$20,$01,$4d,$01,$41,$01,$43,$01,$52,$01,$4f,$01,$20,$01,$54  ; . .M.A.C.R.O. .T
  .byte $01,$4f,$01,$4f,$01,$4c,$01,$20,$01,$56,$01,$31,$01,$2e,$01,$30  ; .O.O.L. .V.1...0
  .byte $01,$8d,$01,$42,$01,$59,$01,$20,$01,$50,$01,$45,$01,$58,$01,$20  ; 4.GB.Y. .P.E.X. 
  .byte $01,$22,$01,$cd,$01,$14,$01,$4d,$01,$41,$01,$48,$01,$4f,$01,$4e  ; .".. ..M.A.H.O.N
  .byte $01,$45,$01,$59,$01,$22,$01,$20,$01,$54,$01,$55,$01,$46,$01,$56  ; .E.Y.". .T.U.F.V
  .byte $01,$45,$01,$53,$01,$53,$01,$4f,$01,$4e,$01,$8d,$01,$50,$01,$52  ; .E.S.S.O.NV.%P.R
  .byte $01,$45,$01,$53,$01,$53,$01,$20,$01,$46,$01,$31,$01,$20,$01,$46  ; .E.S.S. .F.1. .F
  .byte $01,$4f,$01,$52,$01,$20,$01,$49,$01,$4e,$01,$53,$01,$54,$01,$52  ; .O.R. .I.N.S.T.R
  .byte $01,$55,$01,$43,$01,$54,$01,$49,$01,$4f,$01,$4e,$01,$53,$01,$8d  ; .U.C.T.I.O.N.S8.
  .byte $01,$52,$01,$45,$01,$41,$01,$44,$01,$59,$01,$2e,$01,$8d,$00,$00  ; .R.E.A.D.Y......

org stuff_to_move+$0300
rorg $c300

keybuf_F1:
;  .byte $19,$48,$03,$4f,$0c,$57,$06,$20,$07,$41,$07,$4d,$08,$20,$08,$49  ; )H.O.W. .A.M. .I
;  .byte $04,$20,$12,$44,$03,$4f,$08,$49,$01,$4e,$07,$47,$10,$3f,$22,$0d  ; . .D.O.I.N.G.?..
;  .byte $36,$50,$08,$52,$06,$49,$03,$4e,$07,$54,$05,$20,$06,$35,$0f,$2f  ; <P.R.I.N.T. .5./
;  .byte $0b,$30,$06,$0d,$47,$4c,$09,$4f,$05,$41,$03,$44,$09,$20,$09,$22  ; .0..GL.O.A.D. ."
;  .byte $1d,$4c,$05,$49,$07,$46,$08,$45,$0c,$22,$0c,$2c,$0c,$38,$2e,$0d  ; .L.I.F.E.".,.8..
;  .byte $6d,$50,$06,$52,$04,$49,$08,$4e,$05,$54,$03,$20  ; .8%./P.R.I.N.TD 
;  .byte $19,$50,$02,$4f,$03,$53,$02,$28,$02,$22,$04,$22,$03,$29,$02,$50  ; .P.O.S%(.".".)>P
;  .byte $05,$4f,$04,$53,$03,$28,$02,$22,$04,$22,$03,$29,$02,$50,$02,$4f  ; .O.S.(.".".).P.O
;  .byte $04,$53,$03,$28,$03,$22,$02,$22,$03,$29,$04,$0d,$4a,$4c,$08,$4f,$06,$41,$02,$44  ; .0...)(.zL.O.A.D
;  .byte $01,$20,$16,$22,$10,$4d,$06,$41,$06,$48,$02,$4f,$05,$4e,$07,$45,$08,$59  ; 6".M.A.H.O.N.E.Y
;  .byte $0a,$22,$0e,$2c,$09,$30,$16,$0d  ; .".,.8?..
;  .byte $16,$4c,$08,$4f,$06,$41,$02,$44  ; L.O.A.D
;  .byte $01,$20,$18,$22,$09,$22,$15,$2c,$21,$38,$21,$0d,$6a,$91,$2b,$0d,$0c,$32  ; 0".".,!8!.j.+.<2
;  .byte $06,$30,$04,$32,$07,$31,$14,$20,$12,$47,$03,$4f,$1b,$53,$06,$55  ; .0.2.1. .G.O.S.U
;  .byte $09,$42,$0a,$20,$0d,$32,$05,$30,$04,$32,$09,$31,$09,$0d,$11,$52  ; .B. .2.0.2.1...R
;  .byte $07,$55,$02,$4e,$0e,$0d
;
;  .byte $14,$31,$02,$30,$04,$20,$03,$46,$06,$4f,$05,$52,$04,$20,$03,$41  ; 51.0. .F.O.R. .A
;  .byte $05,$3d,$05,$31,$06,$20,$07,$54,$04,$4f,$03,$20,$05,$31,$04,$31  ; %=91. .T.O. .1.1
;  .byte $06,$0d,$04,$31,$04,$33,$06,$33,$05,$37,$02,$20,$04,$4f,$02,$50  ; ..$1.3.3.7. .O.P
;  .byte $08,$45,$06,$4e,$03,$20,$05,$41,$03,$2c,$04,$42,$02,$0d,$03,$31  ; .E.N# .A.,.B..+1
;  .byte $04,$39,$03,$39,$04,$39,$05,$20,$04,$4e,$03,$45,$02,$58,$02,$54  ; .9.9.9. .N.E.X.T
;  .byte $01,$0d,$05,$52,$04,$55,$02,$4e,$09,$0d                          ; ..%R.U.N..
;  .byte $13,$4c,$06,$4f,$08,$41,$09,$44,$1c,$0d,$01,$00



  .byte $01, $3d, $09, $3d, $09, $3d, $1b, $20, $0b, $4b, $07, $45, $05, $59, $0d, $42  ; .=.=.=. .K.E.Y.B
  .byte $05, $4f, $08, $41, $05, $52, $08, $44, $0c, $20, $19, $4d, $05, $41, $0a, $43  ; .O.A.R.D. .M.A.C
  .byte $08, $52, $07, $4f, $07, $20, $08, $54, $06, $4f, $09, $4f, $0f, $4c, $0c, $20  ; .R.O. .T.O.O.L. 
  .byte $12, $56, $0e, $31, $0a, $2e, $05, $30, $09, $20, $25, $3d, $0c, $3d, $09, $3d  ; .V.1...0. %=.=.=
  .byte $17, $20, $06, $20, $06, $20, $07, $20, $05, $20, $05, $20, $05, $20, $24, $20  ; . . . . . . . $ 
  .byte $2c, $42, $06, $59, $02, $20, $0b, $50, $05, $45, $04, $58, $08, $20, $0c, $4d  ; ,B.Y. .P.E.X. .M
  .byte $06, $41, $06, $48, $03, $4f, $04, $4e, $07, $45, $05, $59, $05, $20, $11, $54  ; .A.H.O.N.E.Y. .T
  .byte $08, $55, $08, $46, $06, $56, $06, $45, $09, $53, $09, $53, $0c, $4f, $03, $4e  ; .U.F.V.E.S.S.O.N
  .byte $1c, $20, $09, $20, $05, $20, $08, $20, $05, $20, $04, $20, $06, $20, $08, $20  ; . . . . . . . . 
  .byte $05, $20, $07, $20, $06, $20, $07, $20, $05, $20, $04, $20, $08, $20, $06, $20  ; . . . . . . . . 
  .byte $4d, $55, $10, $53, $08, $41, $1e, $47, $06, $45, $0c, $3e, $30, $14, $0f, $3b  ; MU.S.A.G.E.>0..;
  .byte $1c, $20, $14, $14, $09, $14, $28, $3a, $30, $20, $15, $53, $08, $48, $04, $49  ; . ....(:0 .S.H.I
  .byte $06, $46, $06, $54, $36, $2d, $1e, $14, $0c, $30, $1e, $14, $0b, $2d, $1c, $14  ; .F.T6-...0...-..
  .byte $07, $2d, $18, $14, $02, $3d, $2d, $14, $0e, $29, $1b, $14, $07, $30, $1a, $14  ; .-...=-..)...0..
  .byte $0c, $2d, $1c, $14, $15, $2d, $1a, $14, $0d, $3d, $18, $14, $0c, $2b, $45, $46  ; .-...-...=...+EF
  .byte $0c, $31, $32, $20, $12, $54, $06, $4f, $05, $20, $08, $52, $07, $45, $06, $43  ; .12 .T.O. .R.E.C
  .byte $07, $4f, $06, $52, $0d, $44, $0f, $20, $0e, $4d, $06, $41, $06, $43, $10, $52  ; .O.R.D. .M.A.C.R
  .byte $09, $4f, $11, $20, $12, $20, $04, $20, $04, $20, $04, $20, $04, $20, $3c, $20  ; .O. . . . . . < 
  .byte $0f, $20, $06, $20, $06, $20, $05, $20, $05, $20, $06, $20, $07, $20, $06, $20  ; . . . . . . . . 
  .byte $07, $20, $05, $20, $21, $14, $2a, $53, $14, $48, $05, $49, $08, $46, $0f, $54  ; . . !.*S.H.I.F.T
  .byte $3a, $2b, $3e, $46, $06, $31, $2d, $20, $0c, $54, $0a, $4f, $02, $20, $0a, $45  ; :+>F.1- .T.O. .E
  .byte $09, $4e, $04, $44, $19, $20, $0d, $52, $10, $52, $03, $45, $15, $14, $08, $14  ; .N.D. .R.R.E....
  .byte $0f, $45, $1a, $43, $09, $4f, $07, $52, $0b, $44, $08, $49, $03, $4e, $08, $47  ; .E.C.O.R.D.I.N.G
  .byte $17, $20, $0a, $4f, $05, $52, $07, $20, $0c, $20, $0e, $20, $06, $20, $07, $20  ; . .O.R. . . . . 
  .byte $09, $20, $06, $20, $06, $20, $05, $20, $07, $20, $06, $20, $05, $20, $05, $20  ; . . . . . . . . 
  .byte $03, $20, $08, $20, $05, $20, $06, $20, $06, $20, $04, $20, $08, $20, $07, $20  ; . . . . . . . . 
  .byte $2f, $35, $09, $20, $10, $53, $02, $45, $08, $43, $08, $4f, $03, $4e, $07, $44  ; /5. .S.E.C.O.N.D
  .byte $05, $53, $08, $20, $21, $54, $09, $49, $02, $4d, $06, $45, $10, $4f, $06, $55  ; .S. !T.I.M.E.O.U
  .byte $05, $54, $35, $20, $06, $20, $0a, $20, $03, $20, $09, $20, $03, $20, $07, $20  ; .T5 . . . . . . 
  .byte $07, $20, $05, $20, $06, $20, $07, $20, $06, $20, $06, $20, $1d, $20, $12, $46  ; . . . . . . . .F
  .byte $05, $31, $11, $20, $09, $54, $03, $4f, $21, $14, $35, $4f, $02, $20, $0a, $52  ; .1. .T.O!.5O. .R
  .byte $07, $45, $04, $50, $04, $4c, $08, $41, $07, $59, $2b, $20, $0b, $4d, $06, $41  ; .E.P.L.A.Y+ .M.A
  .byte $09, $43, $09, $52, $04, $4f, $11, $20, $12, $20, $04, $20, $04, $20, $04, $20  ; .C.R.O. . . . . 
  .byte $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20  ; . . . . . . . . 
  .byte $04, $20, $04, $20, $0c, $20, $09, $20, $08, $20, $06, $20, $08, $20, $04, $20  ; . . . . . . . . 
  .byte $07, $20, $0b, $20, $25, $14, $09, $2e, $08, $2e, $0a, $2e, $14, $53, $05, $41  ; . . %........S.A
  .byte $06, $4d, $05, $45, $06, $20, $05, $46, $06, $4f, $05, $52, $05, $20, $24, $46  ; .M.E. .F.O.R. $F
  .byte $09, $33, $05, $2c, $08, $20, $11, $46, $0f, $35, $09, $20, $07, $41, $07, $4e  ; .3.,. .F.5. .A.N
  .byte $04, $44, $05, $20, $06, $46, $0a, $37, $2c, $20, $13, $20, $04, $20, $04, $20  ; .D. .F.7, . . . 
  .byte $09, $20, $0f, $20, $09, $20, $0a, $20, $26, $54, $07, $55, $12, $14, $0f, $48  ; . . . . &T.U...H
  .byte $04, $49, $06, $53, $04, $20, $18, $54, $07, $4f, $05, $4f, $0c, $4c, $09, $20  ; .I.S. .T.O.O.L. 
  .byte $06, $57, $04, $41, $09, $53, $09, $20, $1a, $55, $08, $53, $03, $45, $0a, $44  ; .W.A.S. .U.S.E.D
  .byte $08, $20, $06, $54, $06, $4f, $08, $20, $1a, $52, $06, $45, $0c, $43, $08, $4f  ; . .T.O. .R.E.C.O
  .byte $14, $52, $0b, $44, $08, $20, $07, $54, $06, $48, $07, $45, $06, $20, $23, $4d  ; .R.D. .T.H.E. #M
  .byte $06, $55, $06, $53, $06, $49, $06, $43, $08, $20, $0a, $20, $2a, $56, $09, $49  ; .U.S.I.C. . *V.I
  .byte $0a, $44, $09, $45, $04, $4f, $07, $20, $0c, $22, $19, $4c, $09, $4f, $08, $41  ; .D.E.O. .".L.O.A
  .byte $03, $44, $09, $20, $0a, $45, $05, $52, $09, $52, $09, $4f, $07, $52, $3b, $20  ; .D. .E.R.R.O.R; 
  .byte $24, $28, $46, $46, $08, $45, $09, $41, $07, $54, $0e, $20, $12, $4a, $06, $45  ; $(FF.E.A.T. .J.E
  .byte $06, $53, $08, $50, $0a, $45, $04, $52, $0c, $20, $14, $4f, $08, $46, $06, $20  ; .S.P.E.R. .O.F. 
  .byte $0a, $50, $09, $50, $0c, $4f, $06, $54, $48, $29, $42, $22, $3a, $4f, $11, $4e  ; .P.P.O.TH)B":O.N
  .byte $06, $20, $0b, $41, $03, $20, $1f, $52, $0a, $45, $09, $41, $06, $4c, $04, $20  ; . .A. .R.E.A.L. 
  .byte $1a, $43, $12, $36, $09, $34, $32, $20, $09, $57, $06, $49, $05, $54, $05, $48  ; .C.6.42 .W.I.T.H
  .byte $03, $20, $23, $54, $06, $59, $0a, $50, $0b, $49, $07, $4e, $07, $47, $08, $20  ; . #T.Y.P.I.N.G. 
  .byte $14, $53, $08, $59, $07, $4e, $09, $43, $09, $48, $0a, $52, $17, $4f, $0c, $4e  ; .S.Y.N.C.H.R.O.N
  .byte $08, $49, $0a, $5a, $09, $45, $0c, $44, $20, $20, $10, $20, $28, $54, $07, $4f  ; .I.Z.E.D  . (T.O
  .byte $04, $20, $07, $54, $06, $48, $05, $45, $06, $20, $1c, $4d, $05, $55, $08, $53  ; . .T.H.E. .M.U.S
  .byte $22, $49, $0a, $43, $35, $20, $08, $41, $05, $4e, $06, $44, $02, $20, $0c, $4c  ; "I.C5 .A.N.D. .L
  .byte $08, $59, $05, $52, $09, $49, $09, $43, $0b, $53, $0f, $2e, $5d, $20, $13, $20  ; .Y.R.I.C.S..] . 
  .byte $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $0e, $20, $0a, $20  ; . . . . . . . . 
  .byte $09, $20, $06, $20, $05, $20, $07, $20, $05, $20, $07, $20, $92, $54, $06, $4f  ; . . . . . . .T.O
  .byte $03, $20, $0c, $52, $08, $45, $0b, $53, $02, $54, $0c, $41, $08, $52, $04, $54  ; . .R.E.S.T.A.R.T
  .byte $09, $20, $0c, $54, $06, $48, $05, $45, $05, $20, $48, $54, $08, $4f, $05, $4f  ; . .T.H.E. HT.O.O
  .byte $0e, $4c, $35, $2c, $05, $20, $28, $44, $08, $4f, $0e, $20, $12, $53, $08, $59  ; .L5,. (D.O. .S.Y
  .byte $06, $53, $0a, $20, $08, $34, $08, $39, $06, $31, $08, $35, $04, $32, $5e, $20  ; .S. .4.9.1.5.2^ 
  .byte $10, $41, $08, $46, $08, $54, $05, $45, $03, $52, $0b, $20, $24, $41, $10, $20  ; .A.F.T.E.R. $A. 
  .byte $08, $52, $08, $45, $0a, $53, $04, $45, $09, $54, $2f, $2e, $36, $20, $12, $c5  ; .R.E.S.E.T/.6 ..
  .byte $0a, $4e, $1b, $4a, $02, $4f, $0c, $59, $15, $14, $09, $14, $0c, $14, $0a, $14  ; .N.J.O.Y........
  .byte $08, $14, $1e, $45, $0a, $4e, $0b, $4a, $0c, $4f, $0d, $59, $0c, $21, $21, $20  ; ...E.N.J.O.Y.!! 
  .byte $1e, $26, $3b, $14, $2e, $2f, $2f, $20, $18, $50, $05, $45, $04, $58, $5e, $20  ; .&;..// .P.E.X^ 
  .byte $0e, $5e, $27, $14, $1f, $32, $18, $14, $0a, $22, $23, $4d, $07, $41, $06, $48  ; .^'..2..."#M.A.H
  .byte $04, $4f, $05, $4e, $07, $45, $05, $59, $0b, $22, $23, $20, $21, $54, $07, $55  ; .O.N.E.Y."# !T.U
  .byte $08, $46, $06, $56, $05, $45, $16, $53, $14, $53, $14, $4f, $27, $4e, $89, $11  ; .F.V.E.S.S.O'N..
  .byte $18, $9d, $3c, $0d, $36, $52, $06, $45, $0c, $41, $05, $44, $08, $59, $0b, $2e  ; ..<.6R.E.A.D.Y..
  .byte $45, $11, $0f, $9d, $09, $9d, $09, $9d, $09, $9d, $09, $9d, $0c, $9d, $01, $00  ; E.............[.


org stuff_to_move+$0800
rorg $c800
keybuf_F3:
  .byte $01, $49, $04, $20, $0e, $48, $04, $4f, $0b, $50, $09, $45, $06, $20, $12, $59  ; .I. .H.O.P.E. .Y
  .byte $05, $4f, $06, $55, $03, $20, $07, $48, $08, $41, $07, $56, $05, $45, $03, $20  ; .O.U. .H.A.V.E. 
  .byte $06, $53, $0b, $45, $0a, $45, $09, $4e, $02, $20, $0a, $54, $05, $48, $04, $45  ; .S.E.E.N. .T.H.E
  .byte $05, $20, $1d, $44, $05, $45, $28, $4d, $03, $4f, $09, $53, $15, $20, $10, $42  ; . .D.E(M.O.S. .B
  .byte $07, $59, $01, $20, $07, $54, $04, $48, $07, $45, $15, $20, $08, $20, $0d, $20  ; .Y. .T.H.E. . . 
  .byte $30, $47, $09, $52, $04, $4f, $06, $55, $04, $50, $06, $20, $37, $50, $09, $45  ; 0G.R.O.U.P. 7P.E
  .byte $02, $52, $15, $14, $0a, $14, $09, $14, $1c, $22, $23, $50, $07, $45, $01, $52  ; .R......."#P.E.R
  .byte $0a, $46, $07, $4f, $08, $52, $05, $4d, $0a, $45, $08, $52, $0c, $53, $12, $22  ; .F.O.R.M.E.R.S."
  .byte $37, $2e, $1f, $20, $3c, $c3, $1d, $14, $08, $43, $30, $4f, $08, $4f, $11, $4c  ; 7.. <....C0O.O.L
  .byte $3f, $20, $0f, $53, $09, $54, $05, $55, $0a, $46, $0d, $46, $17, $2c, $03, $20  ; ? .S.T.U.F.F.,. 
  .byte $11, $49, $04, $4e, $09, $44, $05, $45, $0c, $45, $0c, $44, $13, $21, $43, $20  ; .I.N.D.E.E.D.!C 
  .byte $01, $00

org stuff_to_move+$0a00
rorg $ca00
keybuf_F5:
  .byte $01, $54, $07, $48, $06, $49, $06, $53, $03, $20, $08, $54, $05, $4f, $08, $4f  ; .T.H.I.S. .T.O.O
  .byte $0d, $4c, $0f, $20, $16, $57, $05, $41, $09, $53, $07, $20, $15, $55, $09, $53  ; .L. .W.A.S. .U.S
  .byte $03, $45, $0a, $44, $07, $20, $0a, $54, $04, $4f, $06, $20, $34, $50, $08, $52  ; .E.D. .T.O. 4P.R
  .byte $06, $4f, $0a, $44, $09, $55, $06, $43, $09, $45, $20, $20, $0e, $54, $06, $48  ; .O.D.U.C.E  .T.H
  .byte $06, $45, $06, $20, $16, $4d, $07, $55, $06, $53, $06, $49, $07, $43, $1b, $20  ; .E. .M.U.S.I.C. 
  .byte $17, $56, $07, $49, $07, $44, $07, $45, $03, $4f, $06, $20, $08, $54, $06, $4f  ; .V.I.D.E.O. .T.O
  .byte $05, $20, $17, $22, $31, $4c, $0b, $4f, $07, $41, $02, $44, $09, $20, $09, $45  ; . ."1L.O.A.D. .E
  .byte $03, $52, $0c, $52, $0a, $4f, $09, $52, $1a, $22, $4c, $2c, $05, $20, $99, $52  ; .R.R.O.R."L,. .R
  .byte $06, $45, $07, $4c, $06, $45, $08, $41, $0c, $53, $06, $45, $0d, $20, $0b, $57  ; .E.L.E.A.S.E. .W
  .byte $04, $49, $06, $54, $06, $48, $02, $20, $09, $54, $06, $48, $05, $45, $1d, $20  ; .I.T.H. .T.H.E. 
  .byte $2a, $53, $08, $4f, $05, $55, $03, $4e, $06, $44, $05, $53, $0c, $20, $0c, $4f  ; *S.O.U.N.D.S. .O
  .byte $07, $46, $05, $20, $08, $53, $06, $43, $0d, $45, $08, $4e, $06, $45, $2d, $53  ; .F. .S.C.E.N.E-S
  .byte $09, $41, $0d, $54, $08, $20, $0a, $56, $20, $4f, $30, $4c, $39, $20, $19, $36  ; .A.T. .V O0L9 .6
  .byte $36, $20, $1b, $2f, $0c, $20, $13, $20, $04, $20, $04, $20, $04, $20, $05, $14  ; 6 ./. . . . . ..
  .byte $13, $14, $04, $14, $0d, $14, $0b, $14, $08, $14, $0b, $14, $09, $2d, $09, $2d  ; .............-.-
  .byte $15, $14, $08, $14, $18, $20, $06, $2d, $0a, $2d, $09, $2d, $09, $20, $13, $20  ; ..... .-.-.-. . 
  .byte $04, $20, $04, $20, $04, $20, $04, $20, $09, $20, $0a, $20, $0c, $20, $08, $20  ; . . . . . . . . 
  .byte $0a, $20, $0b, $20, $25, $48, $06, $41, $0c, $56, $06, $45, $04, $20, $08, $41  ; . . %H.A.V.E. .A
  .byte $03, $20, $0c, $4c, $08, $49, $06, $53, $01, $54, $07, $45, $29, $4e, $11, $20  ; . .L.I.S.T.E)N. 
  .byte $10, $59, $03, $4f, $08, $55, $05, $52, $0d, $53, $03, $45, $06, $4c, $0c, $46  ; .Y.O.U.R.S.E.L.F
  .byte $06, $20, $13, $41, $06, $41, $18, $14, $09, $54, $18, $0d, $5c, $53, $09, $4f  ; . .A.A...T..\S.O
  .byte $07, $55, $02, $4e, $06, $44, $06, $53, $4c, $2e, $fb, $4f, $0a, $46, $08, $2e  ; .U.N.D.SL..O.F..
  .byte $1e, $53, $03, $43, $0d, $45, $0b, $4e, $06, $45, $5b, $53, $0c, $2e, $11, $41  ; .S.C.E.N.E[S...A
  .byte $16, $54, $84, $1d, $13, $1d, $04, $1d, $04, $1d, $04, $1d, $04, $1d, $04, $1d  ; .T..............
  .byte $04, $1d, $04, $1d, $04, $1d, $04, $1d, $04, $1d, $04, $1d, $04, $1d, $04, $1d  ; ................
  .byte $04, $1d, $04, $1d, $04, $1d, $04, $1d, $0c, $1d, $20, $20, $2b, $2e, $0a, $2e  ; ..........  +...
  .byte $07, $2e, $2e, $59, $08, $45, $06, $53, $22, $2c, $07, $20, $08, $49, $07, $54  ; ...Y.E.S",. .I.T
  .byte $08, $5e, $08, $53, $0d, $20, $13, $14, $07, $14, $0a, $14, $26, $27, $18, $14  ; .^.S. ......&'..
  .byte $24, $27, $0a, $53, $12, $20, $08, $41, $0a, $4e, $0e, $20, $1f, $55, $0e, $52  ; $'.S. .A.N. .U.R
  .byte $07, $4c, $3d, $2e, $0c, $20, $28, $54, $09, $52, $06, $59, $1b, $20, $09, $49  ; .L=.. (T.R.Y. .I
  .byte $0f, $54, $0c, $21, $4b, $20, $11, $20, $04, $20, $04, $20, $04, $20, $04, $20  ; .T.!K . . . . . 
  .byte $04, $20, $0f, $20, $0c, $20, $08, $20, $0a, $20, $0c, $20, $01, $00

org stuff_to_move+$0d00
rorg $cd00
keybuf_F7:
;  .byte $01,$50,$05,$45,$04,$58,$07,$20,$06,$22,$0d,$4d,$07,$41,$05,$48 ;  [P.E.X. .".M.A.H
;  .byte $04,$4f,$04,$4e,$05,$45,$08,$59,$0e,$22,$0e,$20,$07,$54,$06,$55 ;  .O.N.E.Y.". .T.U
;  .byte $09,$46,$06,$56,$04,$45,$06,$53,$0a,$53,$04,$4f,$05,$4e,$04,$20 ;  .F.V.E.S.S.O.N. 
;  .byte $0b,$50,$05,$52,$03,$45,$07,$53,$05,$45,$08,$4e,$05,$54,$07,$53 ;  .P.R.E.S.E.N.T.S
;  .byte $18,$8d,$19,$3f,$0a,$4c,$0a,$4f,$05,$41,$03,$44,$08,$20,$09,$20 ;  (.)?.L.O.A.D. . 
;  .byte $0d,$45,$0d,$52,$07,$52,$09,$4f,$06,$52,$17,$20,$0a,$20,$08,$46 ;  .E.R.R.O.R. . .F
;  .byte $07,$45,$0a,$41,$09,$54,$09,$20,$0f,$4a,$07,$45,$07,$53,$06,$50 ;  .E.A.T. .J.E.S.P
;  .byte $07,$45,$02,$52,$09,$20,$3d,$48,$04,$4f,$0c,$4c,$07,$4d,$03,$20 ;  .E.R. =H.O.L.M. 
;  .byte $0c,$4f,$0a,$4c,$08,$53,$04,$45,$09,$4e,$0b,$20,$1a,$4f,$09,$46 ;  .O.L.S.E.N. .O.F
;  .byte $2a,$8d,$1a,$4c,$0c,$cf,$1a,$0d,$00,$00


  .byte $01, $48, $06, $41, $06, $56, $06, $45, $06, $20, $09, $20, $24, $14, $06, $41  ; .H.A.V.E. . $..A
  .byte $1c, $20, $10, $4e, $07, $4f, $07, $49, $05, $53, $01, $45, $14, $20, $1c, $4e  ; . .N.O.I.S.E. .N
  .byte $06, $49, $07, $47, $06, $48, $04, $54, $39, $21, $9d, $1d, $21, $20, $10, $20  ; .I.G.H.T9!..! . 
  .byte $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20  ; . . . . . . . . 
  .byte $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $10, $20  ; . . . . . . . . 
  .byte $0d, $20, $0e, $20, $2f, $20, $0b, $20, $0c, $20, $09, $20, $11, $2f, $28, $20  ; . . / . . . ./( 
  .byte $0c, $50, $08, $45, $03, $58, $08, $20, $0d, $22, $25, $4d, $06, $41, $07, $48  ; .P.E.X. ."%M.A.H
  .byte $02, $4f, $07, $4e, $06, $45, $05, $59, $0b, $22, $15, $20, $0f, $54, $07, $55  ; .O.N.E.Y.". .T.U
  .byte $06, $46, $06, $56, $06, $45, $0c, $53, $0a, $53, $0b, $4f, $03, $4e, $ba, $20  ; .F.V.E.S.S.O.N. 
  .byte $10, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $0e, $20  ; . . . . . . . . 
  .byte $0e, $20, $0a, $20, $29, $20, $0d, $20, $0a, $20, $0a, $20, $09, $20, $09, $20  ; . . ) . . . . . 
  .byte $08, $20, $25, $14, $0f, $5f, $22, $14, $0f, $5f, $1e, $14, $14, $27, $10, $14  ; . %.._".._...'..
  .byte $08, $41, $28, $14, $16, $c1, $17, $14, $0c, $22, $1a, $14, $0c, $21, $22, $14  ; .A(......"...!".
  .byte $0c, $23, $18, $14, $08, $24, $27, $14, $12, $25, $1f, $14, $18, $5e, $17, $26  ; .#...$'..%...^.&
  .byte $0c, $2a, $0d, $28, $0b, $93, $0a, $29, $21, $2d, $1d, $2d, $2e, $5d, $14, $de  ; .*.(...)!-.-.]..
  .byte $11, $22, $0b, $5b, $06, $5d, $0a, $5d, $0a, $5e, $0c, $14, $10, $14, $04, $14  ; .".[.].].^......
  .byte $04, $14, $04, $14, $04, $14, $04, $14, $04, $14, $04, $14, $04, $14, $04, $14  ; ................
  .byte $04, $14, $04, $14, $0d, $14, $09, $14, $09, $14, $20, $20, $0a, $41, $04, $54  ; ..........  .A.T
  .byte $12, $20, $1e, $47, $05, $55, $09, $42, $09, $42, $0b, $44, $08, $41, $03, $54  ; . .G.U.B.B.D.A.T
  .byte $07, $41, $09, $20, $0c, $32, $0c, $30, $16, $32, $12, $31, $54, $20, $13, $20  ; .A. .2.0.2.1T . 
  .byte $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20  ; . . . . . . . . 
  .byte $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $04, $20, $14, $20  ; . . . . . . . . 
  .byte $00, $00












