.include "swis.asm"

.org 0x8000

Start:

main:
	; Set mode 13 (320*256*8bpp)
	swi 0x116
	swi 0x10d

	; Disable cursor
	swi 0x36

	; Read VDU values (Start Address mainly)
screen_addr:
	adr r0, screen_addr_input
	adr r1, screen_addr
	swi OS_ReadVduVariables

	mov r2,#32	; CX	; Starting Y (changed a bit from the X86 for the curve drawn to be more consistent)
	mov r3,#772	; SI	; Controls amplitude (I set it to be almost in the 0-255 range)
	adr r0,sines
singen:
	mov r4,r2,LSR #8		; R4 = (CX >> 8)
	strb r4,[r0],#1			; Write 
	mov r4,#64				; Controls frequency (40 just happens to loop about 256 pixels, but hacked now to 64 to mess up pattern)
	mul r4,r2,r4			; R4 = 40 * CX
	add r2,r2,r3			; CX = CX + SI	; moved here compared to where is at x86 code, to make sine more even
	sub r3,r3,r4,ASR #16	; SI = SI - (R4 >> 16) (DX in the x86 IMUL)
	subs r1,r1,#1
	bne singen

main_loop:

	adr r1, screen_addr
	ldr r1,[r1]

	swi OS_ReadMonotonicTime
	mov r0,r0,LSR #3

	adr r11,sines
	and r2,r0,#255
	add r11,r11,r2
	ldrb r6,[r11]
	sub r6,r6,#128
	ldrb r5,[r11,#64]
	sub r5,r5,#128

	eor r9,r9,r9
	mov r10,r9
	sub r9,r9,r5,LSL #8
	add r10,r10,r6,LSL #7

	mov r3,#256
	loopY:
		mov r7,r9
		mov r8,r10
		mov r2,#320

		loopX:
			mov r12,r7,LSR #6
			and r12,r12,#255
			mov r13,r8,LSR #6
			and r13,r13,#255

			ldrb r14,[r11,r12]
			ldrb r12,[r11,r13]
			add r4,r14,r12

			mov r4,r4,LSR #4
			add r4,r4,r0

			and r4,r4,#15
			mov r12,r0,LSR #4
			add r4,r4,r12,LSL #4
			strb r4,[r1],#1
			add r7,r7,r5
			add r8,r8,r6
		subs r2,r2,#1
		bne loopX
		sub r9,r9,r6
		add r10,r10,r5
	subs r3,r3,#1
	bne loopY

	mov r0,#OSByte_Vsync
	swi OS_Byte

	swi OS_ReadEscapeState
	bcc main_loop

	swi OS_Exit

screen_addr_input:
	.long VD_ScreenStart, -1

sines:
