            org 0x8000

screen_top  equ 0x40e0
scroll_top  equ 0x4820
frog_start_pos equ 0x5a6f

start
            ld hl,frog_start_pos
            ld (frog_pos+1),hl
            call 3435
            ld hl,traffic
            ld de,screen_top
            ld c,6
draw_traffic_lane_lp
            ld b,16
draw_traffic_pixrow_lp
            push bc
            push hl
            push de
            ld b,2
draw_traffic_byte_lp
            ld c,(hl)
            inc hl
            scf
draw_traffic_bit_lp
            rl c
            jr z,draw_traffic_byte_done
            sbc a,a
            ld (de),a
            inc e
            ld (de),a
            inc e
            or a
            jr draw_traffic_bit_lp
draw_traffic_byte_done
            djnz draw_traffic_byte_lp
            pop de
            ex de,hl
            call uphl
            ex de,hl
            pop hl
            pop bc
            djnz draw_traffic_pixrow_lp
            inc hl
            inc hl
            dec c
            jr nz,draw_traffic_lane_lp

frame_lp
            halt
            ld hl,scroll_top
            call scroll_left
            call scroll_right_2
            call scroll_left_2
            call scroll_right
            call scroll_left_2

            ld hl,(frog_pos+1)
            ld a,070o
            call put_frog
            ; bc is still 32
            ld a,(iy-50)
            ld (iy-50),0
            sub 8
            jr z,move_left
            dec a
            jr z,move_right
            dec a
            jr z,move_down
            dec a
            jr z,move_up

move_done
            ld a,l
            cpl
            and 0x1f
            jr z,no_set_frog_pos
            ld (frog_pos+1),hl
no_set_frog_pos
frog_pos
            ld hl,frog_start_pos
            ld a,044o
            call put_frog
            ; convert hl to screen memory equivalent
            ld a,h
            and 0x0f
            add a,a
            add a,a
            add a,a
;            or 0x07  ; bottom line of char so that we can advance to next with uphl
            ld h,a
            ld a,(hl)
            inc l
            or (hl)
            jp nz,start

; reached end?
            ld a,h
            cp 0x40
            jr nz,frame_lp
            ld (hl),h
            ld hl,frog_start_pos
            ld (frog_pos+1),hl
;            call uphl
;            ld a,(hl)
;            dec l
;            or (hl)
;            jp nz,start
            jr frame_lp

move_left
            dec l
            jr move_done

move_right
            inc l
            jr move_done

move_down
            ; bc is still 32
            add hl,bc
            jr move_done
move_up
            ; bc is still 32
            sbc hl,bc
            jr move_done

            ; 1101 1011 0110 1101 - homes
traffic     db 0xdb, 0x6d
            ; 1100 0000 1100 0110 - lorries
            db 0xc0, 0xc6
            ; 1000 1010 1000 0000 - cars
            db 0x8a, 0x80
            ; 1010 1001 0100 1000 - scary middle lane
            db 0xa9, 0x48
            db 0xc0, 0xc6  ; lorries
            db 0x08, 0x88
            ;db 0x00, 0x00
            ;db 0xff, 0xff

put_frog
            ld (hl),a
            inc l
            ld (hl),a
            dec l
            ld bc,32
;            add hl,bc
;            ld (hl),a
;            dec l
;            ld (hl),a
;            sbc hl,bc
            ret

scroll_left_2
            push hl
            call scroll_left
            pop hl
scroll_left
            ld c,16
scroll_left_line_lp
            push hl
            ld a,l
            add a,0x1f
            ld l,a
            push hl
            ld a,(hl)
            rla
            ld b,31
scroll_left_char_lp
            dec l
            rl (hl)
            djnz scroll_left_char_lp
            pop hl
            rl (hl)
            pop hl
            call uphl
            dec c
            jr nz,scroll_left_line_lp
            ret

scroll_right_2
            push hl
            call scroll_right
            pop hl
scroll_right
            ld c,16
scroll_right_line_lp
            push hl
            ld a,(hl)
            rra
            ld b,31
scroll_right_char_lp
            inc l
            rr (hl)
            djnz scroll_right_char_lp
            pop hl
            rr (hl)
            call uphl
            dec c
            jr nz,scroll_right_line_lp
            ret

uphl
            inc h
            ld a,h
            and 7
            ret nz
            ld a,l
            add a,32
            ld l,a
            ret c
            ld a,h
            sub 8
            ld h,a
            ret

            db "G"  ; a very important signature
