	var palCanvas = document.getElementById('palette');
	var palCtx = palCanvas.getContext('2d');
	var imgPalSelect = new Image();
	imgPalSelect.addEventListener('load', function(){
		palCanvas.width = imgPalSelect.width;
		palCanvas.height = imgPalSelect.height;
		palCtx.drawImage(imgPalSelect, 0,0, imgPalSelect.width, imgPalSelect.height, 0,0, imgPalSelect.width, imgPalSelect.height);
	});
	imgPalSelect.src = 'data:image/png;base64,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';
	palCanvas.onclick = function(e){
		var palPixelData = palCtx.getImageData(e.offsetX, e.offsetY, 1, 1).data;
		var hex = "#" + ("000000" + (((palPixelData[0] << 16) | (palPixelData[1] << 8) | palPixelData[2]).toString(16))).slice(-6);

		colorArr[palCurrId] = hex;
		textarea.value = JSON.stringify(colorArr);
		for (var i = 0; i < 16; i++) {
			palCurrCtx.fillStyle = colorArr[i];
			palCurrCtx.fillRect(0, i*24, 24, 24);
		}
	};