<?
$frameQty = 67;
$zxframeQty = 20;
//--- 4. create zx sprites
$imgList = 'var imgList = [';

$xMax = 0;
$xMin = 999;

$asmTbl = ";---------------------------- FRAMETBL\r\nframetbl\r\n";
$asm = ";---------------------------- FRAMES\r\n";
$chunkList = array();
for ($frameZx = 0; $frameZx < 20; $frameZx++) {
    $imgPath = __DIR__ . '/frameszx2/framezx' . sprintf('%02d', $frameZx) . '.png';
    $img = imagecreatefrompng($imgPath);
    $asm .= "frame_" . $frameZx . "\r\n";
    $asmTbl .= "\tdw\tframe_" . $frameZx . "\r\n";
    for ($y = 0; $y < 24; $y++) {
        for ($x = 2; $x < 14; $x++) {
            $chunk = array();
            for ($by = 0; $by < 8; $by+=2) {
                $byte = 0;
                for ($bx = 0; $bx < 8; $bx++) {
                    $clr = imagecolorat($img, $x*8+$bx + 0, $y*8+$by);
                    if ($clr != 0) {
                        $byte += pow(2,7-$bx);
                    }
                }
                if ($byte != 0) {
                    $xMax = max($xMax, $x);
                    $xMin = min($xMin, $x);
                }
                $chunk[] = $byte;
            }
            $chunk = implode('_', $chunk);
            $chunkId = isset($chunkList[$chunk]) ? $chunkList[$chunk] : sizeof($chunkList);
            $chunkList[$chunk] = $chunkId;
            $asm .= "\tdw\tchunk_" . $chunkId . ($x%2==0 ? "" : " + 3") . "\r\n";
        }
    }
}
$asm .= ";---------------------------- CHUNKS\r\n";
foreach ($chunkList as $chunkData => $chunkId) {
    $chunk = explode('_', $chunkData);
    $asm .= "chunk_" . $chunkId . "\r\n";
    foreach ($chunk as $byte) {
        $asm .= "\tdb\t" . $byte . "\r\n";
    }
}
$asm .= $asmTbl;

file_put_contents(__DIR__ . '/anima.asm', $asm);


echo "chunkList sz " . sizeof($chunkList) . " " . 4*sizeof($chunkList) . "\r\n";
echo "sz scr " . (288*20*2). "\r\n";
echo "total sz " . (288*20*2 + 4*sizeof($chunkList)) . "\r\n";
echo "xMin " . $xMin . "\r\n";
echo "xMax " . $xMax . "\r\n";

die();


//--- 3. after conversion
$imgList = 'var imgList = [';
for ($frameZx = 0; $frameZx < $zxframeQty; $frameZx++) {
    $imgPath = __DIR__ . '/frameszx2/framezx' . sprintf('%02d', $frameZx) . '.png';
    $img = imagecreatefrompng($imgPath);
    $color = imagecolorallocate($img, 0, 0, 0);
    for ($y = 0; $y < 192; $y++) {
        if (($y%2) == 0) {
            imagefilledrectangle($img, 0, $y, 127, $y, $color);
        } else {
            for ($x = 0; $x < 128; $x++) {
                
            }
        }
    }
    //imagepng($img, 'test2.png');
    ob_start();
    imagepng($img);
    $imgData = ob_get_clean();
    $imgList .= "'" . 'data:image/png;base64,' . base64_encode($imgData) . "',\r\n";
}
$imgList .= '];';
file_put_contents(__DIR__ . '/base64img.json', $imgList);
die();

//--- 2. create zx-size frames
$imgList = array();
for ($frame = 0; $frame < $frameQty; $frame++) {
    $imgPath = __DIR__ . '/frames/frame' . sprintf('%02d', $frame) . '.gif';
    $src = imagecreatefromgif($imgPath);
    $imgList[$frame] = imagecreatetruecolor(128, 192);
    imagecopyresampled($imgList[$frame], $src, 0,0,
        267,0,
        128,192,
        268,400);
}
for ($frameZx = 0; $frameZx < $zxframeQty; $frameZx++) {
    $frame = round($frameQty * $frameZx / $zxframeQty);
    imagepng($imgList[$frame], __DIR__ . '/frameszx/framezx' . sprintf('%02d', $frameZx) . '.png');
}
die();


//--- 1. create allframes
$imgList = array();
for ($frame = 0; $frame < $frameQty; $frame++) {
    $imgPath = __DIR__ . '/frames/frame' . sprintf('%02d', $frame) . '.gif';
    $src = imagecreatefromgif($imgPath);
    $imgList[$frame] = imagecreatetruecolor(imagesx($src), imagesy($src));
    imagecopy($imgList[$frame], $src, 0, 0, 0, 0, imagesx($src), imagesy($src));
}
$w = imagesx($imgList[0]);
$h = imagesy($imgList[0]);
$result = array();
for ($y = 0; $y < $h; $y++) {
    $result[$y] = array();
    for ($x = 0; $x < $w; $x++) {
        $result[$y][$x] = array('r' => 0, 'g' => 0, 'b' => 0);
    }
}

foreach ($imgList as $n => $img) {
    echo 'frame ' . $n . "\r\n";
    for ($y = 0; $y < $h; $y++) {
        for ($x = 0; $x < $w; $x++) {
            $color1 = imagecolorat($img, $x, $y);
            $r = $color1 & 255;
            $g = ($color1 >> 8) & 255;
            $b = ($color1 >> 16) & 255;
            $result[$y][$x]['r'] = min(255, $result[$y][$x]['r'] + $r);
            $result[$y][$x]['g'] = min(255, $result[$y][$x]['g'] + $g);
            $result[$y][$x]['b'] = min(255, $result[$y][$x]['b'] + $b);
        }    
    }
}

$imgNew = imagecreatetruecolor($w,$h);
for ($y = 0; $y < $h; $y++) {
    for ($x = 0; $x < $w; $x++) {
        $color = imagecolorallocate($imgNew, $result[$y][$x]['r'], $result[$y][$x]['g'], $result[$y][$x]['b']);
        imagesetpixel($imgNew, $x, $y, $color);
    }
}

imagepng($imgNew, __DIR__ . '/allframes.png');

