//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT

    ld  a,#17
    call    PAGER
    
    ei
    halt
    ld  hl,#5aff
    ld  de,#5afe
    ld  bc,6911
    ld  (hl),0
    lddr

    ld  hl,logo_out
    ld  de,#408b
    ld  bc,256 * 12 + 32
    call spr_out

    ld  hl,logo_of
    ld  de,#482d
    ld  bc,256 * 8 + 32
    call spr_out

    ld  hl,logo_compo
    ld  de,#48c5
    ld  bc,256 * 22 + 32
    call spr_out

    ld  hl,#4000
    ld  de,#c000
    ld  bc,6144
    ldir
    
    ld  hl,tits
    call ta_do_hl
    ld  hl,tits+3
    call ta_do_hl
    ld  hl,tits+6
    call ta_do_hl
    ld  hl,tits+9
    call ta_do_hl

    ei
    halt
    ld  hl,logo_attr
    ld  de,#5800
    ld  bc,768
    ldir

    ld  hl,#d800
    ld  de,#d801
    ld  bc,767
    ld  (hl),#47
    ldir

	RET
    
spr_out
    ld  lx,b
spr2
    push    de
    ld      b,lx
spr1
    ldi
    inc bc
    djnz    spr1
    pop     de
    call    downde
    dec     c
    jr      nz,spr2
    ret
downde
    inc d
    ld  a,d
    and 7
    ret nz
    ld  a,e
    add a,#20
    ld  e,a
    ret c
    ld  a,d
    sub 8
    ld  d,a
    ret

//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	xor a:out(#fe),a
    ;ld  a,7:out(#fe),a

    ld  a,(PAGE)
    xor #08
    or  #07
    call    PAGER
    
    call    tits_anim
    
    ;xor a:out(#fe),a
    
	RET
//======================================================== FX_PROCEDURES
rand
	LD  A,137
randseed	EQU	$-1
	LD	B,A
	ADD	A,A
	XOR	B
	LD	B,A
	SRL	A
	XOR	B
	LD	B,A
	ADD	A,A
	ADD	A,A
	XOR	B
	LD	(randseed),A
	RET

tits_anim
    ld  a,0
tawait equ $-1
    inc a
    and 3
    ld  (tawait),a
    ret nz
    ;---
    ld  a,5
ta_qty equ $-1
    dec a
    ld  (ta_qty),a
    jp  nz,ta_do
    call    rand
    and 3
    add a,4
    ld  (ta_qty),a
    call    rand
    and 4
    ld  a,1
    jr  z,1f
    ld  a,-1
1   ld  (ta_dir),a
    
    ld  a,(ta_num)
    ld  c,a
    call    rand
    and 3
    cp  c
    jr  nz,1f
    inc a
    and 3
1   ld  (ta_num),a

ta_do
    ld  a,0
ta_num equ $-1
    ld  l,a
    add a,a
    add a,l
    add a,low tits
    ld  l,a
    adc a,high tits
    sub l
    ld  h,a

ta_do_hl

    ld  a,1
ta_dir equ $-1
    add a,(hl)
    cp  #80
    jr  c,ta1
    ld  a,11
ta1 cp  12
    jr  c,ta2
    xor a
ta2 ;--
    push    af
    ld  (hl),a
    inc hl
    ld  e,(hl)
    inc hl
    ld  d,(hl)
    ;--
    push    de
    ;ld  hl,tits_empty
    ;ld  bc,256 * 4 + 32
    ;call spr_out
    ;--
    pop de
    pop af
    
    add a,a
    ld  hl,tits_faze
    add a,l
    ld  l,a
    adc a,h
    sub l
    ld  h,a

    ld  a,(hl)
    inc hl
    ld  h,(hl)
    ld  l,a

    ld  bc, 4 * 256 + 32
    call spr_out
    ret

    ld  a,e
    add a,(hl)
    ld  e,a
    jr  nc,ta3
    ld  a,d
    add a,8
    ld  d,a
ta3 
    inc hl
    ld  a,d
    add a,(hl)
    ld  d,a    

    inc hl
    ld  a,(hl)
    inc hl
    ld  b,a
    ld  c,#ff
 
ta4
    ldi
    ld  a,(hl)
    ld  (de),a
    inc hl
    dec e
    call downde
    djnz ta4

    ret
    


//======================================================== FX_INCLUDE_DATA
logo_out    incbin "bin/logo-out_pix_0.bin"
logo_of     incbin "bin/logo-of_pix_0.bin"
logo_compo  incbin "bin/logo-compo_pix_0.bin"
logo_attr   incbin "bin/logo-attr.bin"
            ;include "bin/tits.asm"
            include "bin/tits2.asm"
//======================================================== FX_TABLES

tits
    db  0       ;faze 0..11
    dw  #c08b   ;scr
    ;---
    db  4       ;faze 0..11
    dw  #c82d   ;scr
    ;---
    db  11      ;faze 0..11
    dw  #c8c9   ;scr
    ;---
    db  8       ;faze 0..11
    dw  #c8d7   ;scr
    ;---
tits_faze
    dw  tits_0
    dw  tits_1
    dw  tits_2
    dw  tits_3
    dw  tits_4
    dw  tits_5
    dw  tits_6
    dw  tits_7
    dw  tits_8
    dw  tits_9
    dw  tits_10
    dw  tits_11



