//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
stepMax	equ 280
//======================================================== FX_INIT
EFF_INI_
	ei
	halt

/*
	ld	a,#17
	call	PAGER

	;--- clr
	ld	a,0
	out	(#fe),a
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),0
	ldir

	;--- grid
	xor a
	ld	hl,#4000
	ld	de,#4001
	ld	c,6
grid1	;-
	ld	b,4
grid2
	ld	(hl),a
	inc	l
	jp	nz,grid2
	inc	h
	djnz	grid2
	cpl
	dec	c
	jp	nz,grid1
	ld	hl,#4000
	ld	de,#c000
	ld	bc,6912
	ldir
*/

	ld	hl,buff
	ld	de,buff+1
	ld	(hl),#99
	ld	bc,767
	ldir

	;--- set im2 routine
	ld  hl,fxim2
	ld  (IM2CALL),hl

	;--- makepal
	ld	bc,pal
	ld	hl,pal1+16
	ld	ix,pal1
	call	mkpl0

	ld	bc,pal+256
	ld	hl,pal2+16
	ld	ix,pal2

mkpl0	;---
	ld	ly,16
mkpl1	;--
	ld	d,hx
	ld	e,lx
	;--
	dup	16
	ld	a,(de)
	or	(hl)
	ld	(bc),a
	inc	de
	inc	c
	edup
	;--
	inc	hl
	;--
	dec	ly
	jp	nz,mkpl1
	;--
	ret
//======================================================== FX_MAINLOOP
EFF_RUN_
	ei
	halt
	
	ld	a,3
border2	equ $-1
	ld	(border),a
	out	(#fe),a

	call	movebuff
	call	nextfrm
	call	rotozoom

	xor	a
	ld	(border3),a

	ret
//======================================================== FX_PROCEDURES

fxim2
	ld	a,3
border	equ	$-1
	out	(#fe),a

	ld	a,(PAGE)
	xor	#08
	call	PAGER
	jp  IM2CALL_RET

;-------------------------
    
nextfrm
	ld	h,rottbl/256

	
	ld	a,0
rottbl_a equ $-1
	add	a,1
	ld	(rottbl_a),a
	ld	l,a
	ld	l,(hl)
	inc	h
	
	;--- step rotate x
	ld	e,(hl)
	inc	h
	ld	d,(hl)
	ld	(stepX),de
	scf
	bit	7,d
	jr	nz,1f
	and	a
1	rr	d
	rr	e
	ld	(dy1y),de
	ld	(dy2y),de
	;--- step rotate y
	ld	a,l
	add	a,#40
	ld	l,a
	ld	d,(hl)
	dec	h
	ld	e,(hl)
	ld	(stepY),de
	scf
	bit	7,d
	jr	nz,1f
	and	a
1	rr	d
	rr	e
	ld	(dy1x),de
	ld	(dy2x),de

	ld	hl,y0+1
	inc	(hl)
	inc	(hl)
	inc	(hl)

	ret

;-----------------------------
movebuff

	ld	a,0
border3	equ $-1
	ld	(border2),a
	ld	(border),a

	ld	a,(PAGE)
	or	7
	call	PAGER

	ld	h,pal/256
	ld	de,#5800
	exx
	ld	h,pal/256 + 1
	ld	de,#d800

	ld	a,(PAGE)
	and	#08
	jr	nz,mvbf2
	exx
mvbf2
	call	mvbf0
	exx
mvbf0	ld	(sohr_sp1),sp
	ld	sp,buff
	ld	a,12
mvbf1	;--
	dup	32
	pop	bc	;10
	ld	l,c	;4
	ldi		;16
	ld	l,b	;4
	ldi		;16 /50
	edup
	;--
	dec	a
	jp	nz,mvbf1
	;-----
	ld	sp,0
sohr_sp1 equ $-2
	ret
;-----------------------
rotozoom
	ld	a,(PAGE)
	and	%11111000
	call    PAGER

	;-----		;pri
	ld	hl,#0000
y0 equ $-2
	ld	bc,0
stepY equ $-2
	ld	de,buff
	;---
	exx		;alt
	ld	hl,#4000
x0 equ $-2
	ld	bc,0
stepX equ $-2
	;--------------
	ld	ly,24
	;-------------- alt
lp1	push	hl
	exx		;pri
	push	hl
	;--------------
	push	de
	;--------------
	dup	32
	;---
	add	hl,bc	;11
	ld	a,h	;4
	or	#c0
	exx		;4	;alt
	add	hl,bc	;11
	ld	d,a	;4
	ld a,h: and 127
	
	ld	e,a	;4
	ld	a,(de)	;7
	exx		;4	;pri
	ld	(de),a	;7
	inc	e	;4 /60
	;---
	edup
	;---
	org $-1
	pop	de
	;--------------
	pop	hl	;10
	push	bc	;11
	ld	bc,0	;10
dy1y equ $-2
	add	hl,bc	;11
	pop	bc	;10
	exx		;4	;alt
	pop	hl	;10
	ld	de,0	;10
dy1x equ $-2
	sbc	hl,de	;15
	push	hl	;11
	;set	7,h	;8
	exx		;4	;pri
	push	hl	;11 /125
	;--------------
	push hl:pop ix:ex de,hl
	;--------------
	dup	32
	;---
	add	ix,bc	;15
	exx		;4	;alt
	add	hl,bc	;11
	ld	a,hx
	or	#c0
	ld	d,a	;8
	ld a,h: or 128
	ld	e,a	;4
	ld	a,(de)	;7
	exx		;4	;pri
	or	(hl)	;7
	ld	(hl),a	;7
	inc	l	;4 /71
	;---
	edup
	;--------------
	org $-1
	inc	hl
	ex	de,hl
	;--------------
	pop	hl
	push	bc
	ld	bc,0
dy2y equ $-2
	add	hl,bc
	pop	bc
	exx			;alt
	pop	hl
	ld	de,0
dy2x equ $-2
	sbc	hl,de
	;--------------
	dec	ly
	jp	nz,lp1
	;--------------
	ret

//======================================================== FX_INCLUDE_DATA
pal1	DB	#00+1*3,#00+1*0,#00+1*2,#40+1*2,#40+1*2,#00+1*2,#00+1*7,#00+1*3,#40+1*3
	DB	#00+1*7
	ds	6,#00+1*3
	DB	#00+8*3,#00+8*0,#00+8*2,#40+8*2,#40+8*2,#00+8*2,#00+8*7,#00+8*3,#40+8*3
	DB	#00+8*7
	ds	6,#00+8*3

pal2	DB	#40+1*3,#00+1*0,#40+1*0,#40+1*0,#40+1*2,#40+1*7,#40+1*7,#00+1*3,#40+1*3
	DB	#00+1*7
	ds	6,#40+1*3
	DB	#40+8*3,#00+8*0,#40+8*0,#40+8*0,#40+8*2,#40+8*7,#40+8*7,#00+8*3,#40+8*3
	DB	#00+8*7
	ds	6,#40+8*3

	align	256
rottbl	
	incbin "bin/rottbl-1.bin"
	org $-256
	incbin "bin/rottbl.bin"

pal	equ $
buff	equ pal + 512

EFF_USE_END equ buff + 768


	display "rottbl: ", /A, rottbl
	display "pal: ", /A, pal
	display "buff: ", /A, buff
	display "EFF_USE_END: ", /A, EFF_USE_END

