#version 430
layout(location = 0) uniform vec4 iResolution;
layout(binding = 0) uniform sampler2D T;
const float a = 3.;

#define Radius 3

vec3 neighborhoods[Radius*Radius];


void getNeighborhoods(vec2 coord)
{
    vec2 step1 = vec2(1.0)/iResolution.xy;
    
    for (int i = 0; i < Radius*Radius; i++)
    {
        vec4 color = texture(T, coord + vec2(i/Radius, mod(float(i), float(Radius)))*step1);
        neighborhoods[i] = a*color.rgb/color.a;
    }
}

void sortNeighborhoods()
{
    for(int i = 0; i < Radius*Radius/2-1; i++)
    {
         for (int j=0; j < (Radius*Radius -1-i); j++)
         {
              if (length(neighborhoods[j+1]) > length(neighborhoods[j]))
              { 
                    vec3 temp = neighborhoods[j];
                    neighborhoods[j] = neighborhoods[j+1];
                    neighborhoods[j+1] = temp;
              }
          }
     }
}

void main()
{  
	vec2 uv=gl_FragCoord.xy/iResolution.xy;
    vec4 tex=texture(T,uv);
    vec3 c= a*tex.rgb/tex.a;
    
    //getNeighborhoods(uv);
    //sortNeighborhoods(); 
    vec3 color = c;
    //vec3 color = vec3(neighborhoods[(Radius*Radius)/2]);
    //if (length(color) < 0.1) {
    //color = vec3(neighborhoods[(Radius*Radius)/2+1])/2.;
    //}
        /*float count = 0.;
        vec3 avg = vec3(0.);
        for (int i = 0; i < Radius*Radius; i++)
        {
            if (length(neighborhoods[i]) < 0.1) {
                avg += neighborhoods[i];
                count += 1.;
            }
        }
        if (count > 5.) {
        color = avg / count/2.;
        } else {*/
        //color /= 1.6;
        //for (int i = 0; i < Radius*Radius; i++)
        //{
        //        avg += neighborhoods[i];
        //}
        //color = avg / float(Radius*Radius);
        //}
    //}
    
    //color = c;
    
	color=color*(1.+(color/10.))/(1.+color);
    
    // vignette to lighten the corners
	uv-=.5;
	// color += dot(uv,uv)*.5;
    
    // gamma correction and a slight blue color grading
	color=pow(color, .45*vec3(1.0,1.1,1.2))*(1.-dot(uv,uv)*.75);
    
	gl_FragColor.rgb=color;
}