#version 460
#extension GL_NV_shader_atomic_int64 : enable
#extension GL_ARB_gpu_shader_int64 : enable
layout(local_size_x = 32, local_size_y = 1) in;

#define USE_RANDOM 1
#define USE_MARCHER 1
#define USE_MATERIAL_HANDLER 1

float scene_kleinian_jewel(vec3 p, out int material, out float gradmag);
void scene_init();

#define SCENE_WITH_GRAD scene_kleinian_jewel
#define SCENE_INIT scene_init

#includelib

uniform sampler2D texMarbleDiffuse;
uniform sampler2D texMarbleRoughness;

// Original distance estimator: pseudo_knightyan by Knighty (Fractalforums.com/Fractalforums.org)
// katakombit
struct KnightyanParams {
    vec3 CSize; // [(-2,-2,-2),(0,0,0),(2,2,2)]
    float Size; // [-2,0.70968,2]
    float DEfactor; // [0,1,10]
    float TwiddleRXY; // [-2,0.92784,2]
    float TwiddleP;           // [-2,2,5]
    int Iter;// [0,9,100]
    int ColorIterations; //;slider[0,9,100]
};

KnightyanParams catacombs =
{
    0.7*vec3(1., 1., 1.),   // csize
    0.8,                    // size
    1.,                     // DEfactor
    0.92784,                // TwiddleRXY
    2.,                     // TwiddleP
    10,                     // Iter
    9,                      // ColorIterations
};

KnightyanParams stars =
{
    2.0*vec3(1., 1., 1.),   // csize
    2.0,                    // size
    1.0,                     // DEfactor
    1.0,                // TwiddleRXY
    2.,                     // TwiddleP
    10,                     // Iter
    9,                      // ColorIterations
};

KnightyanParams stripes =
{
    1.5*vec3(1., 0.05, 1.),   // csize
    1.1,                    // size
    1.0,                     // DEfactor
    0.9,                // TwiddleRXY
    2.,                     // TwiddleP
    10,                     // Iter
    9,                      // ColorIterations
};

KnightyanParams strings =
{
    0.25*vec3(1., 1.0, 1.),   // csize
    0.95,                    // size
    1.0,                     // DEfactor
    0.8,                // TwiddleRXY
    2.,                     // TwiddleP
    5,                     // Iter
    9,                      // ColorIterations
};

KnightyanParams pseudo =
{
    vec3(0.956,0.8985,1.105772),   // csize
    1.03524229,                    // size
    0.387168145,                     // DEfactor
    1.13538111,                // TwiddleRXY
    2.01793721,                     // TwiddleP
    14, /*14*/                     // Iter
    9,                      // ColorIterations
};

KnightyanParams kni = pseudo;

float knightyan(vec3 p)
{
    float j=kni.DEfactor;
    for(int i=ZERO;i<kni.Iter;i++){
        p = kni.TwiddleP*clamp(p, -kni.CSize, kni.CSize)-p;
        //float k = max(kni.Size/dot(p,p),1.);
        float k = max(kni.Size/dot(p,p), 0.989910313);
        p *= k;
        //j *= k + 0.05;
        j *= k + 0.1;
        float r2 = dot(p, p);
        if (i<kni.ColorIterations) orbitTrap = min(orbitTrap, abs(vec4(p.xyz,r2)));
    }
    float rxy=length(p.xy);
    return max(rxy-kni.TwiddleRXY, abs(rxy*p.z) / length(p))/j;
}

// cone distance function by iq
float sdCone(in vec3 p, in vec2 c, float h)
{
  // c is the sin/cos of the angle, h is height
  // Alternatively pass q instead of (c,h),
  // which is the point at the base in 2D
  vec2 q = h*vec2(c.x/c.y,-1.0);

  vec2 w = vec2( length(p.xz), p.y );
  vec2 a = w - q*clamp( dot(w,q)/dot(q,q), 0.0, 1.0 );
  vec2 b = w - q*vec2( clamp( w.x/q.x, 0.0, 1.0 ), 1.0 );
  float k = sign( q.y );
  float d = min(dot( a, a ),dot(b, b));
  float s = max( k*(w.x*q.y-w.y*q.x),k*(w.y-q.y)  );
  return sqrt(d)*sign(s);
}

float sdEllipsoid( vec3 p, vec3 r )
{
  float k0 = length(p/r);
  float k1 = length(p/(r*r));
  return k0*(k0-1.0)/k1;
}

float jewel(in vec3 p)
{
    vec3 p2 = p;
    float floorplane_dist = p2.y - 0.07;

    p2.y -= 0.0;

    float ball = length(p.xz) - 0.7;

    //p2.y += 1.5e-1 * length(p.xz);
    p2.y -= 0.07;
    //p2.y += 0.5e-1 * pow(length(p.xz), 2.);
    p2.y += 0.0e-1 * pow(length(p.xz), 2.);
    float skyplane_dist = 0.8 - p2.y;

    p2.zy = p2.yz;

    //p2.yz = rot2d(p2.yz, 0.5);

    orbitTrap = vec4(1e4);
    float d = knightyan(p2);
    d = max(d, -skyplane_dist);
    d = max(d, -floorplane_dist);

    d = max(d, ball);
    return d;
}

float sdCap(vec3 p) {
    float r = 8.00;
    //float bb = length(p * vec3(2., 1., 1.) - vec3(0., -r - 0.3 + 0.022, 0.)) - r;
    float bb = sdEllipsoid(p - vec3(0., -r - 0.3 + 0.021, 0.), vec3(r*4,r,r));
    //return bb;
    float cone = sdCone(p, vec2(1.1, 0.8), 0.3);
    //return min(bb, cone);
    return max(-bb, cone) - 1.0e-2;
}

float scene_kleinian_jewel(vec3 p, out int material, out float gradmag) {
    material = MATERIAL_KLEINIAN;
    vec3 p2 = p;
    p2.y = abs(p2.y);
    p2.y -= 0.1;
    float d = jewel(p2 - vec3(0., 0.42 , 0.));

    const float scale = 1.7;
    const float scale2 = scale * 0.9;
    vec3 p3 = p2 / scale;
    vec3 p4 = p2 / scale2;
    p3 -= vec3(0., 0., 0.);
    p4.xz = rot2d(p4.xz, 1.3); // back shell rotation
    p4 -= vec3(0.71, 0.60, 0.);
    p3.xy = rot2d(p3.xy, PI);
    p4.xy = rot2d(p4.xy, -PI/2);
    float cover1 = sdCap(p3) * scale;
    float cover2 = sdCap(p4) * scale2;
    float clam = min(cover1, cover2);
    float floord = p2.y;

    if (floord < d) {
        material = MATERIAL_OTHER;
    }
    d = min(d, floord);

    if (clam < d) {
        material = MATERIAL_MARBLE;
    }
    d = min(d, clam);

    //cover = max(-p.z, cover);
    //d = min(d, cover);
    //d = cover1;
    return d;
}

const float marbleScale = 0.5;

void materialHandler(in SurfaceInfo surf, inout vec3 base, inout float shininess, inout float ambient, inout float sun,
inout float facing, inout vec3 suncol)
{
    if (surf.material == MATERIAL_MARBLE) {
        vec3 diffuse = boxmap( texMarbleDiffuse, surf.p * marbleScale, surf.normal, 1.0 ).rgb;
        float roughness = boxmap( texMarbleRoughness, surf.p * marbleScale, surf.normal, 1.0 ).r;
        base = 2. * diffuse * diffuse * diffuse;
        shininess = roughness;
        shininess = 0.99;
        shininess = 0.5;
        //base = vec3(pow(1.-roughness, 2.));
    } else if (surf.material == MATERIAL_OTHER) {
        base = 1e-3*vec3(1./(.5+length(surf.p.xz)));
    }
    ambient *= 2.;
    /*
    float roughness = boxmap( texRockRoughness, surf.p * rockScale, surf.normal, 1.0 ).r;

    //sun = 0.1;
    //base = diffuse * max(0.1, ambient) * 4.;
    base = diffuse * max(0.1, ambient);
    //base *= vec3(0.3, 1., 0.9);
    //base = vec3(.5) + .5* surf.normal;
    shininess = mix((1. - roughness), 1., 0.4);

    // blend towards roughness when far away
    shininess = mix(shininess, 0., saturate(length(surf.p - surf.campos) / 3.));

    //ambient = 0.; // no actual ambient light
    //facing = 1.;
    */
}


float scene_kleinian(vec3 p, out int material, out float gradmag) {
    material = MATERIAL_KLEINIAN;
    vec3 p2 = p;
    p2.y = abs(p2.y);
    p2.y -= 0.2;

    p2.y += 1.5e-1 * length(p.xz);
    float skyplane_dist = p2.y - 0.8;

    p2.zy = p2.yz;

    //p2.yz = rot2d(p2.yz, 0.5);

    orbitTrap = vec4(1e4);
    float d = knightyan(p2);
    d = max(d, skyplane_dist);
    return d;
}

void scene_init()
{
    switch (prop_geometry) {
        case GEOMETRY_KLEINIAN:
            KnightyanParams kni = pseudo;
            break;
        default:
            break;
    }
}




