#version 460
#extension GL_EXT_shader_atomic_int64 : enable
#extension GL_NV_shader_atomic_int64 : enable
#extension GL_ARB_gpu_shader_int64 : enable
#extension GL_NV_gpu_shader5 : enable
layout(local_size_x = 32, local_size_y = 1) in;

#define USE_RANDOM 1
#define USE_MARCHER 1
#define USE_MATERIAL_HANDLER 1
//#define USE_SHADING_HANDLER 1

float scene_with_grad(vec3 p, out int material, out float gradmag);
void scene_init();

#define SCENE_WITH_GRAD scene_with_grad
#define SCENE_INIT scene_init

#includelib

// mandelbox distance function by Rrola (Buddhi's distance estimation)
// http://www.fractalforums.com/index.php?topic=2785.msg21412#msg21412

const float SCALE = 2.3;
const float MR2 = 0.5;
vec4 mbox_scalevec = vec4(SCALE, SCALE, SCALE, abs(SCALE)) / MR2;
float mbox_C1 = abs(SCALE-1.0);

int mandelbox_material(vec3 position, int iters=7) {
    float mbox_C2 = pow(abs(SCALE), float(1-iters));
	// distance estimate
	vec4 p = vec4(position.xyz, 1.0), p0 = vec4(position.xyz, 1.0);  // p.w is knighty's DEfactor
	for (int i=0; i<iters; i++) {
		p.xyz = clamp(p.xyz, -1.0, 1.0) * 2.0 - p.xyz;  // box fold: min3, max3, mad3
		float r2 = dot(p.xyz, p.xyz);  // dp3
        //if (p.x * p.y * p.z > 2.) {
        if (r2 > 40.) {
            return i;
        }
		p.xyzw *= clamp(max(MR2/r2, MR2), 0.0, 1.0);  // sphere fold: div1, max1.sat, mul4
		p.xyzw = p*mbox_scalevec + p0;  // mad4
	}
	float d = (length(p.xyz) - mbox_C1) / p.w - mbox_C2;
    return 0;
}

int mandelbox_material2(vec3 position, int iters=7) {
    float mbox_C2 = pow(abs(SCALE), float(1-iters));
	// distance estimate
	vec4 p = vec4(position.xyz, 1.0), p0 = vec4(position.xyz, 1.0);  // p.w is knighty's DEfactor
	for (int i=0; i<iters; i++) {
		p.xyz = clamp(p.xyz, -1.0, 1.0) * 2.0 - p.xyz;  // box fold: min3, max3, mad3
		float r2 = dot(p.xyz, p.xyz);  // dp3
        //if (p.x - p.y > 0.8 ) {
        if (p.z - p.y  > 0.8 ) {
        //if (r2 > 10.) {
            return i;
        }
		p.xyzw *= clamp(max(MR2/r2, MR2), 0.0, 1.0);  // sphere fold: div1, max1.sat, mul4
		p.xyzw = p*mbox_scalevec + p0;  // mad4
	}
	float d = (length(p.xyz) - mbox_C1) / p.w - mbox_C2;
    return 0;
}


float mandelbox(vec3 position, int iters=7) {
    float mbox_C2 = pow(abs(SCALE), float(1-iters));
	// distance estimate
	vec4 p = vec4(position.xyz, 1.0), p0 = vec4(position.xyz, 1.0);  // p.w is knighty's DEfactor
	for (int i=ZERO; i<iters; i++) {
		p.xyz = clamp(p.xyz, -1.0, 1.0) * 2.0 - p.xyz;  // box fold: min3, max3, mad3
		float r2 = dot(p.xyz, p.xyz);  // dp3
		p.xyzw *= clamp(max(MR2/r2, MR2), 0.0, 1.0);  // sphere fold: div1, max1.sat, mul4
		p.xyzw = p*mbox_scalevec + p0;  // mad4
	}
	float d = (length(p.xyz) - mbox_C1) / p.w - mbox_C2;
    return d;
}

float scene_rotated_brot(vec3 p, out int material, int eval_mat=0) {
	material = MATERIAL_METAL;
    vec3 p2 = p;
    p2.y = abs(p2.y);
    p2.y -= prop_mandelbox_height;
    vec2 cells = pMod2(p2.xz, vec2(15.0, 15.0));
    p2.zy = p2.yz;
    p2.xz = rot2d(p2.xz, prop_mandelbox_roll);

    if (eval_mat==1) {
        material = mandelbox_material(p2, prop_mandelbox_iters);
    } else if (eval_mat==2) {
        material = mandelbox_material2(p2, prop_mandelbox_iters);
    }

	return mandelbox(p2, prop_mandelbox_iters);
}


float scene_brot(vec3 p, out int material) {
	material = MATERIAL_OTHER;
    vec3 p2 = p;
    p2.y = abs(p2.y);
    p2.y -= prop_mandelbox_height;
    p2.yz = rot2d(p2.yz, 0.5);
	return mandelbox(p2, prop_mandelbox_iters);
}
float scene_with_grad(vec3 p, out int material, out float gradmag) {
    return scene_rotated_brot(p, material);
}

void scene_init()
{
}

void materialHandler(in SurfaceInfo surf, inout vec3 base, inout float shininess, inout float ambient, inout float sun,
inout float facing, inout vec3 suncol)
{
    if (prop_geometry == GEOMETRY_MANDELBOX) {
        base = .1 * vec3(1., 1., 1.);
        shininess = 0.7;

        int mat=0;
        scene_rotated_brot(surf.p, mat, 1);
        vec3 colors[] = {
        .05*vec3(1., 0.1, 0.1),
        vec3(1., 1., 0.),
        0.1 * vec3(1.0, 1.0, 0.1)
        };
        colors[0] *= mix(1., .5+.5*sin(surf.p.y * .5 * surf.p.x * 1.), 0.8);
        float shines[] = {0.5, 0.0, 0.8};
        //base = hsv2rgb(vec3(float(mat) * 0.2, 1., 1.));
        int id = (mat + 0) % colors.length;
        base = colors[id];
        shininess=shines[id];
    } else if (prop_geometry == GEOMETRY_MANDELBOX2) {
        base = .1 * vec3(1., 1., 1.);
        shininess = 0.7;

        int mat=0;
        scene_rotated_brot(surf.p, mat, 2);
        vec3 colors[] = {
        .05*vec3(1., 0.1, 0.1),
        8.0 * vec3(0.5, 1.0, 0.5),
        vec3(1.0, 1., 0.),
        };
        //colors[0] *= mix(1., .5+.5*sin(surf.p.y * .5 * surf.p.x * 1.), 0.8);
        //colors[2] *= 10.0 * pow(.5 + .5*sin(surf.p.y*8. - surf.p.x*4. + secs*8.), 2.);
        colors[1] *= (1. - prop_mandelbox_glow);
        colors[2] *= prop_mandelbox_glow * 10. * pow(saturate(.5 + .5*sin(surf.p.z/2.-PI/2.)),1.5);
        //colors[2] *= 0.1;
        float shines[] = {0.5, 0.8, 0.8};
        float suns[] = {sun, sun, 1.0};
        //base = hsv2rgb(vec3(float(mat) * 0.2, 1., 1.));
        int id = (mat + 0) % colors.length;
        base = colors[id];
        shininess=shines[id];
        sun = suns[id];
    }
    /*
    float roughness = boxmap( texRockRoughness, surf.p * rockScale, surf.normal, 1.0 ).r;
    vec3 diffuse = boxmap( texRockDiffuse, surf.p * rockScale, surf.normal, 1.0 ).rgb;

    //sun = 0.1;
    //base = diffuse * max(0.1, ambient) * 4.;
    base = diffuse * max(0.1, ambient);
    //base *= vec3(0.3, 1., 0.9);
    //base = vec3(.5) + .5* surf.normal;
    shininess = mix((1. - roughness), 1., 0.4);

    // blend towards roughness when far away
    shininess = mix(shininess, 0., saturate(length(surf.p - surf.campos) / 3.));

    //ambient = 0.; // no actual ambient light
    //facing = 1.;
    */
}


void shadingHandler(in vec3 p, in float t, in int hitmat, in CameraParams cam, inout vec3 normal, inout vec3 roughNormal, inout vec3 to_light, inout vec3 to_camera, inout float maxShadowDist)
{
    if (hitmat == MATERIAL_METAL) {
    /*
        // "p" point apply texture to
        // "n" normal at "p"
        // "k" controls the sharpness of the blending in the
        //     transitions areas.
        // "s" texture sampler
        vec4 tex = boxmap( texRockNormals, p * rockScale, normal, 1.0 );
        vec3 nor = tex.xyz * vec3(2., 2., 2.) + vec3(-1, -1, -1.);
        //vec3 nor = tex.xyz * vec3(2., 2., 1.) + vec3(-1, -1, 0.);
        nor = mix(vec3(0., 0., 1.), nor, 1.);

        vec3 tangent_x, tangent_y;

        //makeOrthoFrame(normal, tangent_x, tangent_y);
        //vec3 warped_normal = nor.x * tangent_x + nor.y * tangent_y + nor.z * normal;
        vec3 warped_normal = normal + 0.3 * nor.xzy;
        normal = normalize(warped_normal);

        vec3 lightPosition = (cam.pos - vec3(0., 0.05, 0.0)*normalize(cam.up));

        //if (rand() < 0.9) { lightPosition = statuePos; }

        vec3 pointToLight = lightPosition - p;
        const float lightDist = length(pointToLight);
        maxShadowDist = lightDist;

        to_light = pointToLight / lightDist;
        //to_light = normalize(to_camera + 0.03*vec3(0., -1., 0.)/(t+.1));
        //to_light = to_camera;
        */
    }
}



