; --------------------------------------------------------------------------------
; A Dragon 32 entry for the "Vintage Computing Christmas Challenge 2021"
;
; Code by Geir Straume (Discord: GeirS#7311, Web: https://gstraume.itch.io/)
; --------------------------------------------------------------------------------

; Assemble using a vasm binary (http://sun.hasenbraten.de/vasm/) which has been
; compiled with CPU=6809 and SYNTAX=oldstyle

; vasm6809_oldstyle -Fbin -o xmastree.rom source.asm

                org $c000             ; Cartridge start address

; Main code
                ldx  #$0400           ; Address of screen
                ldu  #CharCounts      ; Address of char counts

RowLoop         lda  ,u+              ; Get char count
End             beq  End              ; Loop forever here when we're done
                tfr  a,b              ; Transfer count to b for use in loop below
                adda #$1f             ; Calculate first column number
                lsra
                leax a,x              ; Calculate actual screen address
                lda  #$2a+$40         ; Asterisk character (non-reverse)
CharLoop        sta  ,x+              ; Put char on screen
                incb
                bne  CharLoop         ; Loop for all chars
                tfr  x,d
                addd #$0010           ; Calculate address of next screen row
                andb #$e0
                tfr  d,x
                bra  RowLoop          ; Loop for all rows

; Char counts for asterisks (stored as negative values to optimize the code)
CharCounts      byte -1,-3,-5,-7,-3,-7,-11,-15,-5,-11,-17,-23,-3,-3

; Pad to 16KB
                org $fffe

                word $c000            ; Reset vector
