; --------------------------------------------------------------------------------
; An entry for the "Vintage Computing Christmas Challenge 2021"
;
; Code by Geir Straume (Discord: GeirS#7311, Web: https://gstraume.itch.io/)
; --------------------------------------------------------------------------------

                processor 6502        ; This source file is in DASM format

; Available target platforms
PLUS4           = 4
C64             = 64

; Selected target platform
TARGET          = PLUS4

; Set constants according to target platform
 IF TARGET = PLUS4
LOADADDR        = $1001               ; Load address
SCROLLUP        = $da89               ; KERNAL routine to scroll screen upwards
YVAL            = $27                 ; Value of y after calling SCROLLUP
SCREENPTR       = $c8                 ; Current screen line address
 ELSE
   IF TARGET = C64
LOADADDR        = $0801               ; Load address
SCROLLUP        = $e8ea               ; KERNAL routine to scroll screen upwards
YVAL            = $87                 ; Value of y after calling SCROLLUP
SCREENPTR       = $d1                 ; Current screen line address
   ELSE
     ECHO "Unknown target platform"
     ERR
   ENDIF
 ENDIF
                org LOADADDR
; BASIC stub
                dc.w NextLine         ; Address of next line
                dc.w CharCounts-YVAL  ; Line number (available at location $39)
                dc.b $9e              ; SYS token
                dc.b [Start]d         ; SYS address as digits
                dc.b 0                ; End of line
NextLine        dc.w 0

; Char counts for asterisks (stored as negative values to optimize the code)
CharCounts      dc.b -1,-3,-5,-7,-3,-7,-11,-15,-5,-11,-17,-23,-3,-3

; Main code
Start           jsr SCROLLUP          ; Scroll the screen upwards (y=YVAL after)
                lax ($39),y           ; Load char count into both a and x
End             bpl End               ; Loop forever here when we're done
                adc #$27              ; Calculate first column number
                lsr
                tay
                lda #$2a              ; Asterisk character
CharLoop        sta (SCREENPTR),y     ; Put char in bottom screen row
                iny
                inx
                bne CharLoop          ; Loop for all chars
                inc $39               ; Next char count
                bne Start             ; Loop
