#version 430

// bind light setup to buffer 1
#define LIGHT_PROPERTIES_BINDING 1
#define GRID_RES 256

uniform sampler2D  s_texture0;	// depth
uniform usampler2D s_texture1;	// normal + material (encoded)
uniform sampler2D  s_texture2;	// color
uniform usampler2D s_texture3;	// metalness roughness material index

uniform sampler3D s_voxel_colors;	// color
uniform sampler3D s_voxel_colors_filtered;	// color

uniform sampler2DArray s_BlueNoise;

#define sMetalnessRoughnessMaterialTags s_texture3

in vec2 vTexcoord0;
in vec4 vFrustum;

uniform vec4 vNearFarPlane;
uniform vec3 vCameraPosition;

uniform float g_global_time;

// output

out vec4 outColor;

#include <shaders/materials/commons.glsl>
#include <shaders/materials/deferred/lighting_support.glsl>
#include <shaders/materials/raytrace_buffers.glsl>
#include <shaders/materials/raytrace_commons.glsl>

float linearizeDepth(float d)
{
	return vNearFarPlane.z / (vNearFarPlane.y + vNearFarPlane.x - d * vNearFarPlane.w);
}

vec3 positionFromDepth(vec4 vDirection, float depth)
{
	return vCameraPosition.xyz + (vDirection.xyz * depth);
}

#include <shaders/materials/noise/noise3d.glsl>
#include <shaders/materials/raytrace_cone_tracing.glsl>

// all the positions are in world coords
vec3 calculate_lighting_world(LightProperties light, in vec3 pos, in vec3 normal, in vec3 light_pos, in vec3 cam_pos, in float NdotL)
{
	float d = NdotL;
	if (d < 0.0)
		d = 0.0;
	
	vec3 specular = vec3(0.0);
	if (d > 0.0)
		specular = pow(max(0.0, dot(reflect(-normalize(pos - light_pos), normalize(normal)), -normalize(cam_pos - pos))), 14.0) * light.diffuse.xyz;

	return vec3(vec3(d) * light.diffuse.xyz + specular);
}


void main() {

	uint encoded_normal_material = texture(s_texture1, vTexcoord0).r;
	vec3 vNorm = decode_normal(encoded_normal_material);
	int materialId = decode_material(encoded_normal_material);

	if ((materialId & MATERIAL_ID_MASK_ATTR) == ATTR_BACKGROUND)
	{	
		outColor = vec4(materialId);
		return;
	}

	float depth = linearizeDepth(texture(s_texture0, vTexcoord0).r);
	vec3 world = positionFromDepth(vFrustum, depth);

	outColor = vec4(0.0);
	float NdotL = 1.0;
	
	// for particles don't include directional component
	if ((materialId & MATERIAL_ID_MASK_ATTR) == ATTR_PARTICLE)
		NdotL = 1.0;

	float metalness;
	float roughness;
	uint material;
	decode_metalness_roughness_material(textureLod(sMetalnessRoughnessMaterialTags, vTexcoord0, 0.0).rg, metalness, roughness, material);

	vec3 dir = -normalize(vCameraPosition.xyz - world);
	float range = min(in_bbox_data.grid_size_voxelize.x, min(in_bbox_data.grid_size_voxelize.y, in_bbox_data.grid_size_voxelize.z));

	vec4 occlusion = vec4(0.0);
	occlusion = rt_cone_trace_occlusion(ivec2(gl_FragCoord.xy), s_voxel_colors_filtered, in_bbox_data.grid_size_voxelize.xyz, GRID_RES, in_bbox_data.bbox_voxelize_min.xyz,
		world, vNorm, range, roughness);

	//occlusion.rgb += rt_cone_trace_specular(gl_FragCoord.xy, s_voxel_colors_filtered, in_bbox_data.grid_size_voxelize.xyz, GRID_RES, in_bbox_data.bbox_voxelize_min.xyz,
	//	world, vNorm, reflect(dir, vNorm), 0.75 * length(in_bbox_data.grid_size_voxelize.xyz), roughness);

	//outColor.rgb = vNorm.xyz * 0.5 + 0.5;
	outColor.rgba = occlusion;
}

