#version 430

#define MATERIAL_PROPERTIES_BINDING 1
#include <shaders/materials/commons.glsl>

in vec2 vTexcoord0;

layout(rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;

void main() {

	// all we do is discard where material RT properties are not present

	float metalness;
	float roughness;
	uint materialIndex;
	decode_metalness_roughness_material(imageLoad(imMetalnessRoughnessMaterialTags, ivec2(gl_FragCoord.xy)).rg, metalness, roughness, materialIndex);

	MaterialPropertiesGPU material = materials.material_properties[materialIndex];
	
	if ((material.flags & MaterialFlag_Raytrace) == 0 && (material.flags & MaterialFlag_Reflective) == 0)
		discard;

}
