#version 430

in vec2 vTexcoord0;
uniform sampler2D s_texture0;  // base image (HDR)
uniform sampler2D s_texture1;  // glow (HDR)
uniform sampler2D s_texture2;  // glow2, (smaller radius) (HDR)

uniform vec2 vResolution;
uniform vec2 vResolutionInv;

uniform float vGlowThreshold;
uniform vec4 vGlowStrength;

layout(location = 0) out vec4 outColor;

vec3 threshold_input(vec3 inpt)
{
	return max(vec3(0.0), inpt - vGlowThreshold);
}

vec4 threshold_input(vec4 inpt)
{
	return max(vec4(0.0), inpt - vGlowThreshold);
}

void main()
{
	vec4 pxl = texture(s_texture0, vTexcoord0);
	vec4 glow = threshold_input(texture(s_texture1, vTexcoord0)) * vGlowStrength;
	vec4 glow2 = threshold_input(texture(s_texture2, vTexcoord0)) * vGlowStrength;
	//glow = glow * glow;

	//outColor = pow(pxl + glow, vec4(1.0/2.2));
	outColor = pxl + (glow2 + glow) * 0.5;
}
