#version 430

#extension GL_NV_gpu_shader5 : enable

#include <shaders/materials/commons.glsl>
#include <shaders/particles/particles_commons.glsl>

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};

layout(std430) buffer VTXCoords {
	float coords[];
} vtx_coords;

vec3 vtx_coords_load(uint idx)
{
	return vec3(vtx_coords.coords[idx * 3 + 0], vtx_coords.coords[idx * 3 + 1], vtx_coords.coords[idx * 3 + 2]);
}

layout(std430) buffer VTXNormals {
	float normals[];
} vtx_normals;

vec3 vtx_normals_load(uint idx)
{
	return vec3(vtx_normals.normals[idx * 3 + 0], vtx_normals.normals[idx * 3 + 1], vtx_normals.normals[idx * 3 + 2]);
}

uniform float instancing_scale;
uniform int instancing_clones;					// how many times base mesh is clones
uniform int instancing_base_verts_num;			// how many verts total it has

out Vertex
{
	vec3 vCoords;
	f16vec3 vNorm;
	f16vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vWorldPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_output;

//#define RENDER_POINTS

void main() {
	
#ifndef RENDER_POINTS
	// fetch input data
	int vidx = gl_InstanceID * instancing_clones + gl_VertexID / instancing_base_verts_num;
	//int vidx = gl_InstanceID;
	vec3 vInstPosition = prt_get_position(vidx);
	vec4 vInstColor = prt_get_color(vidx);
	bool is_alive = prt_is_alive(vidx);

	//vec3ivNormal = vec3(indata.verts[vidx].nx, indata.verts[vidx].ny, indata.verts[vidx].nz);
	//ivColor = vec4(indata.verts[vidx].cr, indata.verts[vidx].cg, indata.verts[vidx].cb, indata.verts[vidx].ca);

	// rotate base cube

	vec3 angles = vec3(0.0);// vec3(indata.verts[vidx].nx, indata.verts[vidx].ny, indata.verts[vidx].nz);
	float cosb = cos(angles.z);   // don't change x with z. This is a correct order.
	float sinb = sin(angles.z);
	float cosp = cos(angles.x);
	float sinp = sin(angles.x);
	float cosh = cos(angles.y);
	float sinh = sin(angles.y);

	vec3 mx, my, mz;
	mx.x = cosh * cosb + (sinh * sinp * sinb);
	mx.y = sinh * sinp * cosb - (cosh * sinb);
	mx.z = sinh * cosp;
	my.x = cosp * sinb;
	my.y = cosp * cosb;
	my.z = -sinp;
	mz.x = cosh * sinp * sinb - (sinh * cosb);
	mz.y = sinh * sinb + (cosh * sinp * cosb);
	mz.z = cosh * cosp;

	vec3 cube_coords = vtx_coords_load(gl_VertexID);
	vec3 cube_normal = vtx_normals_load(gl_VertexID);
	float cube_scale = is_alive ? instancing_scale : 0.0;// indata.verts[vidx].ca;
	cube_coords = vec3(dot(cube_coords, mx), dot(cube_coords, my), dot(cube_coords, mz));
	cube_normal = vec3(dot(cube_normal, mx), dot(cube_normal, my), dot(cube_normal, mz));

	vInstPosition = vInstPosition + cube_coords * cube_scale;
	vec3 pos = vInstPosition;
	f16vec3 norm = f16vec3(cube_normal);
#else
	int vidx = gl_VertexID;
	vec3 pos = prt_get_position(vidx);
	f16vec3 norm = vec3(0.0, 0.0, 1.0);
#endif

	vtx_output.vLocalPos = pos;

	vec3 vPos1 = pos;
	vec3 vPos = vector_transform_by_mat43(vPos1, transform_params.mModelView);
	vtx_output.vWorldPos = vector_transform_by_mat43(vPos1, transform_params.mModel).xyz;

	vtx_output.vWorldNorm = norm;
	vtx_output.vNorm = norm;

	vtx_output.vCoords = vPos.xyz;
	vtx_output.vColor = f16vec4(vInstColor);
	vtx_output.vUV0 = f16vec2(0.0);

	gl_Position = transform_params.mProjection * vec4(vPos, 1.0);

}