#ifndef COMMONS_INDIRECT_H
#define COMMONS_INDIRECT_H

// NOTE: Add more defines here for utility functions
#if defined(MAIN_BUILD_DRAW_ELEMENTS_INDIRECT_FROM_BUFFER) || defined(MAIN_BUILD_DRAW_ARRAYS_INDIRECT_FROM_BUFFER)
#version 430
layout (local_size_x = 32, local_size_y = 1) in;
#endif

struct DrawElementsIndirectParams
{
	uint  count;
	uint  instance_count;
	uint  first_index;
	uint  base_vertex;
	uint  base_instance;
};

struct DrawArraysIndirectParams
{
	uint  count;
	uint  instance_count;
	uint  first_index;
	uint  base_instance;
};




// DrawElementsIndirect support

#ifdef MAIN_BUILD_DRAW_ELEMENTS_INDIRECT_FROM_BUFFER

// Take data from some arbitrary buffer location, transform it a bit and build
// DrawIndirect call from it. For now only single instance

layout (std430) buffer DrawElementsIndirectParamsBuffer {
	DrawElementsIndirectParams draw_indirect_params[];
};

layout (std430) buffer DrawIndirectSourceBuffer {
	uint draw_indirect_src_data[];
};

struct BuildDrawIndirectFromBufferParams
{
	uint indirect_buffer_idx;
	uint src_buffer_offset;
	uint src_buffer_data_numerator;
	uint src_buffer_data_denominator;
};

layout(std140, row_major) uniform BuildDrawIndirectFromBufferParamsBuffer {
	BuildDrawIndirectFromBufferParams params;
};

void MAIN_BUILD_DRAW_ELEMENTS_INDIRECT_FROM_BUFFER()
{
	uint idx = gl_GlobalInvocationID.x;

	if (idx == 0)
	{
		draw_indirect_params[params.indirect_buffer_idx].count = 
			draw_indirect_src_data[params.src_buffer_offset] * params.src_buffer_data_numerator / params.src_buffer_data_denominator;

		draw_indirect_params[params.indirect_buffer_idx].instance_count = 1;
		draw_indirect_params[params.indirect_buffer_idx].first_index = 0;
		draw_indirect_params[params.indirect_buffer_idx].base_vertex = 0;
		draw_indirect_params[params.indirect_buffer_idx].base_instance = 0;
	}
}

#endif



// DrawArraysIndirect support

#ifdef MAIN_BUILD_DRAW_ARRAYS_INDIRECT_FROM_BUFFER

// Take data from some arbitrary buffer location, transform it a bit and build
// DrawIndirect call from it. For now only single instance

layout (std430) buffer DrawArraysIndirectParamsBuffer {
	DrawArraysIndirectParams draw_indirect_params[];
};

layout (std430) buffer DrawIndirectSourceBuffer {
	uint draw_indirect_src_data[];
};

struct BuildDrawIndirectFromBufferParams
{
	uint indirect_buffer_idx;
	uint src_buffer_offset;
	uint src_buffer_data_numerator;
	uint src_buffer_data_denominator;
};

layout(std140, row_major) uniform BuildDrawIndirectFromBufferParamsBuffer {
	BuildDrawIndirectFromBufferParams params;
};

void MAIN_BUILD_DRAW_ARRAYS_INDIRECT_FROM_BUFFER()
{
	uint idx = gl_GlobalInvocationID.x;

	if (idx == 0)
	{
		draw_indirect_params[params.indirect_buffer_idx].count = 
			draw_indirect_src_data[params.src_buffer_offset] * params.src_buffer_data_numerator / params.src_buffer_data_denominator;

		draw_indirect_params[params.indirect_buffer_idx].instance_count = 1;
		draw_indirect_params[params.indirect_buffer_idx].first_index = 0;
		draw_indirect_params[params.indirect_buffer_idx].base_instance = 0;
	}
}

#endif


#endif
