#version 430

//#define HAS_TESSELATION_SHADER

#ifdef HAS_TESSELATION_SHADER
in vec4 teCoords;
in vec3 teNorm;
in vec3 teWorldNorm;
in vec3 teLocalPos;
in vec4 teWorldPos;
#define vCoords teCoords
#define vNorm teNorm
#define vWorldNorm teWorldNorm
#define vLocalPos teLocalPos
#define vWorldPos teWorldPos
#else
in vec4 vCoords;
in vec3 vNorm;
in vec3 vWorldNorm;
in vec3 vLocalCoords;
in vec4 vWorldPos;
#endif

in vec3 vsTexCoords;

uniform vec4 colorDiffuse;
uniform int materialId;

uniform float roughness;
uniform vec3 vCameraPosition;

uniform int gUseDerivedNormal;

uniform samplerCube s_TextureReflectionCubemap;

// output for 2 buffers
#ifndef SHADOWMAP_PASS
layout(location = 0) out vec4 outAlbedo;
layout(location = 1) out vec4 outNormalMaterial;
#endif

float Specular_Fresnel_Schlick(in vec3 normal, in vec3 dir)
{
    normal = normalize(normal);
	dir = normalize(dir);

	vec3 half_dir = normalize(normal + dir);

	float cosine = dot(half_dir, dir);
    float product = max( cosine, 0.0 );
	float factor = 1.0 - pow( product, 5.0 );

	return factor;

}

void main() {
#ifndef SHADOWMAP_PASS
	// output normal only
	//gl_FragColor = vec4(vNorm * 0.5 + 0.5, 0.0);
	float g = vNorm.z * 0.5 + 0.5;
	//outColor = vec4(vec3(vCoords.z/vCoords.w) * 0.5 + 0.5, 0.0);
	//outColor = vec4(vec3(vWorldPos.z/10.0) + 1.0, 0.0);
	//outColor = vec4(vec3(vWorldPos.y/5.0) + 0.5, 0.0);
	//gl_FragColor = vec4(g);
	//gl_FragColor = vec4(0.5, 0.6, 0.7, 0.0);
	vec3 world_norm =  normalize(vWorldNorm);
	
	outNormalMaterial = vec4(normalize(vWorldNorm) * 0.5 + 0.5, materialId / 255.0);	// NOTE: will this preserve all material id values? maybe just make it uint
	vec4 color = vec4(0.0);
	
	{
	//	vec3 dFdxPos = dFdx(vWorldPos.xyz);
	//	vec3 dFdyPos = dFdy(vWorldPos.xyz);
	//	vec3 face_normal = normalize(cross(dFdxPos, dFdyPos));
	//	world_norm = face_normal;
	//	outNormalMaterial = vec4(face_normal * 0.5 + 0.5, materialId / 255.0);	// NOTE: will this preserve all material id values? maybe just make it uint
	}

	//if (materialId != 1)
	{
		//color += (mod(vWorldPos.y, 1.0) > 0.5 ? 0.4 : 0.0);

		// for now without real reflect(). we need to unify some more 
		// data between vertex and fragment shaders. we need localview (camera)
		// coords too. or we need camera position (might be better?) to use world
		// coords + normals
		//vec4 cubemap = textureLod(s_TextureReflectionCubemap, vsTexCoords, roughness);
		vec4 cubemap = textureLod(s_TextureReflectionCubemap, reflect(vCameraPosition - vWorldPos.xyz, normalize(vWorldNorm)), /*roughness*/ 0.0);
		//vec4 cubemap = textureLod(s_TextureReflectionCubemap, normalize(world_norm.xyz), 1.0);
		//vec4 cubemap = textureLod(s_TextureReflectionCubemap, normalize(vWorldNorm.xyz), roughness);
		//color.xyz = vec3(1.0, 0.0, 0.0)  + (1.0 - vec3(1.0, 0.0, 0.0)) * Specular_Fresnel_Schlick(vWorldNorm.xyz, vWorldPos.xyz - vCameraPosition);
		color.xyz += 2.0 * cubemap.xyz + (1.0 - cubemap.xyz) * Specular_Fresnel_Schlick(world_norm, vWorldPos.xyz - vCameraPosition);
		//color.xyz += colorDiffuse.xyz * cubemap.xyz;
	}
	
	//outAlbedo.xyz = vCameraPosition - vWorldPos.xyz + vec3(0.5);
	//color.xyz = vec3(dot(normalize(vCameraPosition - vWorldPos.xyz), normalize(world_norm)));
	//color.xyz = vec3(abs(vWorldPos.z - 10.0) < 0.5 ? 1.0 : 0.0);

	outAlbedo = color;
	//outAlbedo = vec4(vWorldPos.z / 40.0);
#endif
}
