#version 150

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

#include <shaders/materials/noise/noise3d.glsl>

uniform mat4 mModel;
uniform vec4 vModelview[3];
uniform mat4 mProjection;

uniform float vTweenFactor;
uniform float vTweenScale;
uniform float vNoiseShift;

// from vertex shader
#define HAS_TESSELATION_SHADER
#ifdef HAS_TESSELATION_SHADER
in vec3 teNorm[];
in vec3 teWorldNorm[];
in vec3 teLocalPos[];
in vec4 teWorldPos[];
in float teVtxTweenFactor[];
#define vNorm teNorm
#define vWorldNorm teWorldNorm
#define vLocalPos teLocalPos
#define vWorldPos teWorldPos
#define vVtxTweenFactor teVtxTweenFactor
#else
in vec3 vNorm[];
in vec3 vWorldNorm[];
in vec3 vLocalPos[];
in vec4 vWorldPos[];
in float vVtxTweenFactor[];
#endif

out vec3 vGSNorm;
out vec3 vGSWorldNorm;
out vec3 vGSLocalPos;
out vec4 vGSWorldPos;
out float vGSBrightness;

uniform float vTweenBase; // = 0.45;		// 0 is center(0.0) 1 is base position

//float orient2d(vec2 a, const Point2D& b, const Point2D& c)
//{
//	return (b.x - a.x)*(c.y - a.y) - (b.y - a.y)*(c.x - a.x);
//}

void main()
{

	vec3 shift[3];
	float scale = 1.0;

	shift[0] = vec3(0.0);
	shift[1] = vec3(0.0);
	shift[2] = vec3(0.0);

	vec3 center = (teLocalPos[0].xyz + vLocalPos[1].xyz + vLocalPos[2].xyz) / 3.0;

	// TODO: now all verts fall uniquely
#if 0
	if (vVtxTweenFactor[0] > 0.0)
	{
		float noise1 = snoise(center.xyz * vTweenScale + vNoiseShift);
		float noise2 = snoise(center.xyz * vTweenScale * 0.30137);
		float n = 3.0 * (1.0 + noise1 + noise2) + vTweenFactor - vVtxTweenFactor[0] * 0.05 - 5.0;

		n = clamp(n, 0.0, 1.0);
		n = smoothstep(0.0, 1.0, n);
		n = n * (1.0 - vTweenBase) + vTweenBase;

		vec3 center = vec3(0.0);
		vec3 newpos = mix(center, vLocalPos[0].xyz, n);
		
		// remap to 0...1
		scale = (n - vTweenBase) * (1.0 / (1.0 - vTweenBase));
		shift[0] = newpos - vLocalPos[0].xyz;
		shift[1] = shift[0];
		shift[2] = shift[0];
	}
#else
	if (vVtxTweenFactor[0] > 0.0)
	{
		for (int i = 0; i < 3; i++)
		{
			vec3 noise_pos = center.xyz + vLocalPos[i].xyz;
			float noise1 = snoise((noise_pos + vNoiseShift * 0.131) * vTweenScale);
			float noise2 = snoise((noise_pos + vNoiseShift * 0.031) * vTweenScale * 0.30137 + 2.0113);
			float n = 3.0 * (1.0 + noise1 + 0.75 * noise2) + vTweenFactor - vVtxTweenFactor[0] * 0.05 - 5.0;

			n = clamp(n, 0.0, 1.0);
			n = smoothstep(0.0, 1.0, n);
			n = n * (1.0 - vTweenBase) + vTweenBase;

			vec3 center = vec3(0.0);
			vec3 newpos = mix(center, vLocalPos[i].xyz, n);

			// remap to 0...1
			scale = (n - vTweenBase) * (1.0 / (1.0 - vTweenBase));
			shift[i] = newpos - vLocalPos[i].xyz;
		}

		// pull all the verts together
		shift[0] = (shift[0] + shift[1] + shift[2]) / 3.0;
		shift[1] = mix(shift[0], shift[1], 0.1);
		shift[2] = mix(shift[0], shift[2], 0.1);
	}

#endif

	// dont emit really small primitives
	if (scale < 0.00001)
		return;

	vec3 n_world = cross(vWorldPos[1].xyz - vWorldPos[0].xyz, vWorldPos[2].xyz - vWorldPos[0].xyz);
	n_world = normalize(n_world);
	
	for (int i = 0; i < gl_in.length(); i++)
	{

		vGSNorm = vNorm[0];
		// NOTE: somewhere we have fucked up normal direction?
		vGSWorldNorm = -n_world;
		//vGSWorldNorm = -vWorldNorm[0];
		vGSLocalPos = vLocalPos[i];
		vGSWorldPos = vWorldPos[i];

		vec3 localPos = mix(center, vLocalPos[i], scale) + vec3(shift[i]);

		// now we can do the transformations. NOTE: maybe move some to vertex shader if things go too slow...
		vec4 vPos;
		vPos.x = dot(vModelview[0], vec4(localPos, 1.0));
		vPos.y = dot(vModelview[1], vec4(localPos, 1.0));
		vPos.z = dot(vModelview[2], vec4(localPos, 1.0));
		vPos.w = 1.0;
		vGSWorldPos = mModel * vec4(localPos, 1.0);

		vGSBrightness = 1.0 - (scale * scale * scale);  // make it brighter as it shrinks. we really could use 10bit target here...

		gl_Position = mProjection * vPos;

		EmitVertex();
	}

	EndPrimitive();
}

