#version 450

#extension GL_NV_gpu_shader5 : enable

#include <shaders/materials/commons.glsl>
#include <shaders/materials/raytrace_buffers.glsl>
#include <shaders/materials/raytrace_commons.glsl>

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

// for projection we use calculated bounding box converted to the grid coords

#ifndef PARTITION_VOXELIZE
in Vertex
{
	vec3 vCoords;
	f16vec3 vNorm;
	f16vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vWorldPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_inputs[];
#else
in Vertex
{
	vec3 vLocalPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_inputs[];
#endif

// no interpolation, can use intergers
flat out int vOrientationIndex;
out vec3 vGridCoords;
out f16vec2 vUV0;
flat out vec3 vTriCoords[3];
flat out f16vec3 vTriNormal;  // this normal is for the scaled (nonuniform) coords, not real triangle normal

// we need to output orientation to properly place it into grid when running in PS

void main()
{
#ifdef PARTITION_RAYTRACE
	vec3 bbox_origin = in_bbox_data.bbox_raytrace_min.xyz;
	vec3 bbox_grid_size = in_bbox_data.grid_size_raytrace.xyz;
#endif
#ifdef PARTITION_VOXELIZE
	vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
	vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;
#endif

	// build normal to calculate desired orientation. absolute value
	vec3 n = cross((vtx_inputs[1].vLocalPos - vtx_inputs[0].vLocalPos), (vtx_inputs[2].vLocalPos - vtx_inputs[0].vLocalPos));
	vTriNormal = f16vec3(normalize(n));

	n = abs(n);
	int orientation_index;

	vec3 v0, v1, v2;

	// translate and scale gerometry. do not use bbox as we need grid-aligned offsets
	// TODO: we can actually convert bbox to be grid_size aligned (cell size aligned)

	v0 = vtx_inputs[0].vLocalPos.xyz;
	v1 = vtx_inputs[1].vLocalPos.xyz;
	v2 = vtx_inputs[2].vLocalPos.xyz;

	vec3 s = -bbox_origin;
	v0 += s;
	v1 += s;
	v2 += s;
	
	vec3 f = vec3(1.0) / bbox_grid_size;
	v0 *= f;
	v1 *= f;
	v2 *= f;

	float area = length(cross(v1 - v0, v2 - v0));
	if (area <= 0.0001)
		return;

	vTriCoords[0] = v0;
	vTriCoords[1] = v1;
	vTriCoords[2] = v2;
	vTriNormal = f16vec3(cross(v1 - v0, v2 - v1) / area); // match tri-box intersection code

#if 1
	if (n.x > n.y && n.x > n.z)
	{
		// X dominant
		v0 = v0.yzx;
		v1 = v1.yzx;
		v2 = v2.yzx;
		orientation_index = 0;
	}
	else if (n.y > n.x && n.y > n.z)
	{
		// Y dominant
		v0 = v0.zxy;
		v1 = v1.zxy;
		v2 = v2.zxy;
		orientation_index = 1;
	}
	else// if (n.x > n.y && n.x > n.z)
	{
		// Z dominant
		v0 = v0.xyz;
		v1 = v1.xyz;
		v2 = v2.xyz;
		orientation_index = 2;
	}
#else
	// Z dominant
	v0 = v0.xyz;
	v1 = v1.xyz;
	v2 = v2.xyz;
	orientation_index = 2;

#endif

#if 1
	
	gl_PrimitiveID = gl_PrimitiveIDIn;

	vOrientationIndex = orientation_index;
	gl_Position = vec4(v0 * 2.0 - vec3(GRID_RES), GRID_RES);
	vGridCoords = v0;
	vUV0 = vtx_inputs[0].vUV0;
	EmitVertex();

	vOrientationIndex = orientation_index;
	gl_Position = vec4(v1 * 2.0 - vec3(GRID_RES), GRID_RES);
	vGridCoords = v1;
	vUV0 = vtx_inputs[1].vUV0;
	EmitVertex();

	vOrientationIndex = orientation_index;
	gl_Position = vec4(v2 * 2.0 - vec3(GRID_RES), GRID_RES);
	vGridCoords = v2;
	vUV0 = vtx_inputs[2].vUV0;
	EmitVertex();

	EndPrimitive();
#else


	EndPrimitive();
#endif
}

