#ifndef RAYTRACE_SETUP_H
#define RAYTRACE_SETUP_H

#define USE_LINKED_LISTS
#define GRID_RES 256
#define VERTEX_BUFFER_SIZE 7000000

#define VERTEX_COORD_OFFSET_FLOATS (0)
#define VERTEX_NORMAL_OFFSET_FLOATS (VERTEX_COORD_OFFSET_FLOATS + 3 * VERTEX_BUFFER_SIZE)
#define VERTEX_UV0_OFFSET_FLOATS (VERTEX_NORMAL_OFFSET_FLOATS + 2 * VERTEX_BUFFER_SIZE)
#define VERTEX_MATERIAL_OFFSET_FLOATS (VERTEX_UV0_OFFSET_FLOATS + 2 * VERTEX_BUFFER_SIZE)
#define VERTEX_COORD_STRIDE_FLOATS 3
#define VERTEX_NORMAL_STRIDE_FLOATS 2
#define VERTEX_UV0_STRIDE_FLOATS 2
#define VERTEX_MATERIAL_STRIDE_FLOATS 1
#define VERTEX_SIZE_FLOATS (VERTEX_COORD_STRIDE_FLOATS + VERTEX_NORMAL_STRIDE_FLOATS + VERTEX_UV0_STRIDE_FLOATS + VERTEX_MATERIAL_STRIDE_FLOATS)

#ifdef RT_READ_ONLY
#define BUFF_ATTR readonly
#else
#define BUFF_ATTR
#endif

#endif