precision mediump float;
uniform vec4 vColor;
varying vec2 vTexcoord0;
uniform sampler2D s_texture0;
uniform sampler2D s_texture1;

// unit 0 blurred image
// unit 1 base image

void main() {
	// load depth from alpha component of blurred one
	vec4 blurred = texture2D(s_texture0, vTexcoord0);
	float shift = 1.5 / 256.0;
	vec4 blurred_shifted = texture2D(s_texture0, vTexcoord0 - shift);
	vec4 color = texture2D(s_texture1, vTexcoord0);

	float depth_diff = clamp(- (blurred_shifted.w - color.w), 0.0, 1.0);
	depth_diff = clamp(depth_diff * 4.0, 0.0, 1.1);

	// don't bleed to background. TODO: this is a hack. fix at blurring stage

	if (color.w > 0.99)
		depth_diff = -10.0;

	//gl_FragColor = vec4(depth_diff * 3.0);//vec4(blurred_shifted.w);
	gl_FragColor = color * 0.1 + color.w * 0.3 - vec4(depth_diff);// + vec4(blurred.xyzw * 0.4);
}