attribute vec3 vPosition;
attribute vec2 vTexcoord;
attribute vec3 vNormal;
uniform mat4 mModelview;
uniform mat4 mProjection;
varying vec2 vTexcoord0;
varying vec4 vPos;
varying vec4 vColor;
varying vec3 vNorm;

void main() {
	gl_Position = mProjection * mModelview * vec4(vPosition, 1.0);
	vTexcoord0.xy = vTexcoord.xy;
	vPos = mModelview * vec4(vPosition, 1.0);
	vPos.w = gl_Position.z / gl_Position.w;

	vColor = vec4(dot(vNormal, normalize(vPos.xyz)));
	vNorm = vNormal;
}