//-------------------------------------------------------------------------------------------------------------------------------------
//        BasicUpstart2(init)
//-------------------------------------------------------------------------------------------------------------------------------------
//          QCH - full AFLI every 2nd line (w/o FLIbug)
//
//          Source-Code for release at ZOO2021
//
//          "C1X1 - HCB goes HiRes"         
//-------------------------------------------------------------------------------------------------------------------------------------
        .const FILENAME_PIC  =    "afliflea_pepto.bmp"
        .const FILENAME_PIC1 =    "k1or_320px_pepto.png"
        .const f2acv = FILENAME_PIC1 != "" ? 1 : 0
        
        .const FILENAME_FONT=   "font_2x3_resorted3.png"
        .const ROWMODE = 0
        
        .const FILENAME_LOGO=   "c1x1_logo2.png"
        .const FILENAME_SID=    "solitude.sid"
//-------------------------------------------------------------------------------------------------------------------------------------
//          Variables
//-------------------------------------------------------------------------------------------------------------------------------------
        .const zpa=                     $80
        .const zpx=                     $81
        .const zpy=                     $82
        
//        .var virtline=          0
        
        .const SPRSTARTLINE=            $2f
        
        .const dummyreg=                $2fff
        .const SIDEBORDER_COLREG=       $2fff   //$d020
        .const SPRREG_SCROLLGAPS=       $d02b
        .const COLVAL_UPPER_PART =      $0b
        .const COLVAL_SCREEN_PART =     $0b
        .const COLVAL_LOWER_PART =      $0b
//-------------------------------------------------------------------------------------------------------------------------------------
//          Imports
//-------------------------------------------------------------------------------------------------------------------------------------
        .const pic = LoadPicture("picdata/" + FILENAME_PIC)
        .const pic1 = f2acv == 1 ? LoadPicture("picdata/" + FILENAME_PIC1) : pic
        
        .const sidtune = LoadSid("music/" + FILENAME_SID)
        //.printnow "SID tune located from " + sidtune.location + " to " + (sidtune.location + sidtune.size)
        //.printnow "Init at " + sidtune.init
        //.printnow "Playrout at " + sidtune.play
        
        .const logo = LoadPicture("picdata/" + FILENAME_LOGO)
        
        .const font = LoadPicture("picdata/" + FILENAME_FONT)
        
        #import "Col_Distances.asm"
//-------------------------------------------------------------------------------------------------------------------------------------
        //RGB values Pepto
        .const C64ColList = List().add($000000, $ffffff, $68372b, $70a4b2, $6f3d86, $588d43, $352879, $b8c76f)
        .eval           C64ColList.add($6f4f25, $433900, $9a6759, $444444, $6c6c6c, $9ad284, $6c5eb5, $959595)
        //RGB values Deekay
        //.const C64ColList = List().add($000000, $ffffff, $851f02, $65cda8, $a73b9f, $4dab19, $1a0c92, $ebe353)
        //.eval           C64ColList.add($a94b02, $441e00, $d28074, $464646, $8b8b8b, $8ef68e, $4d91d1, $bababa)
//-------------------------------------------------------------------------------------------------------------------------------------
        .const VRamIdxList = List().add(2, 1, 0, 3, 2, 1, 0, 3, 3, 1, 0, 2, 3, 1, 0, 2)
        .const ZeroPageRegList = List().add($ff, zp_qline01,       zp_qline02,       zp_qline03)
        .eval  ZeroPageRegList.add(         $ff, zp_qline01,       zp_qline02,       zp_qline03)
        .eval  ZeroPageRegList.add(         $ff, zp_qline01f1seg1, zp_qline02f1seg1, zp_qline03f1seg1)
        .eval  ZeroPageRegList.add(         $ff, zp_qline01f1seg1, zp_qline02f1seg1, zp_qline03f1seg1)
        
        .const LetterList =       List().add(' ', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z')
        .const LetterHeightList = List().add($0f, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17)
        .eval LetterList.add(                '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '?', '!', '.', ',', ''', '"')
        .eval LetterHeightList.add(          $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $17, $0f, $0f, $08, $08)
        
        .const FLIbugColTabBase = $5d00
//-------------------------------------------------------------------------------------------------------------------------------------
// Pseudo-Ops
//-------------------------------------------------------------------------------------------------------------------------------------
        .pseudocommand asr bitmask {alr bitmask}
        .pseudocommand sbx bitmask {axs bitmask}
        .pseudocommand isb adr {isc adr}
        .pseudocommand sha adr {ahx adr}
//-------------------------------------------------------------------------------------------------------------------------------------
        .var sprline = SPRSTARTLINE
//-------------------------------------------------------------------------------------------------------------------------------------
.macro delay(cycles) {
        .if (cycles<14) .printnow "Delay implementation only for 14 cycles and more!"
        .if (cycles>63) .printnow "Delay implementation only for up to 63 cycles!"
        .if (cycles==12) {
            jsr mindelay
        } else {
            .var subofs = cycles>13 ? 63 - cycles : 50
            jsr delay + subofs
        }
}
//-------------------------------------------------------------------------------------------------------------------------------------
.macro adjust_flibyte(nqline8) {
        .if (nqline8==2)
            lda #$08
        .if (nqline8==3)
            nop
        .if (nqline8==4)
            eor #$06
            
        .if (nqline8==6)
            lda #$08
        .if (nqline8==7)
            nop
        .if (nqline8==0)
            and #$29
}
//-------------------------------------------------------------------------------------------------------------------------------------
.macro set_spr_col(nqline) {
            .var zp_flibyte_reg = ZeroPageRegList.get(mod(nqline, 16)) - $18
            .var colentrypos = (nqline - 1) - floor((nqline-1)/4)
            .var sprcolofs = 2*colentrypos - mod(colentrypos, 2)
            
            ldy FLIbugColTabBase + sprcolofs,x
            .if (mod(nqline, 8)==5) {
                stx $d018
            } else {
                sta $d018
            }
            lda swaptab,y
            
            sty $d025
            sta $d02b
            ldy FLIbugColTabBase + $100 + sprcolofs,x
            lda swaptab,y
            sty $d026
            sta $d02c
            ldy FLIbugColTabBase + $200 + sprcolofs,x
            lda swaptab,y
            sta $d02d
            lda zp_flibyte_reg,x
            sty $d02e
}
//-------------------------------------------------------------------------------------------------------------------------------------
.macro preload_yreg(nqline8) {
        .if (nqline8==2)
            nop
        .if (nqline8==3)
            ldy #$0f
            
        .if (nqline8==6)
            nop
        .if (nqline8==7)
            ldy #$0f
}
//-------------------------------------------------------------------------------------------------------------------------------------
.macro set_spr_pos(ypos_set_line) {
        .if ($30 + ypos_set_line + 16 > sprline + 21) .eval sprline += 21
        
        .var addbyte = sprline - $28   //flibyte
        adc #addbyte
        sta $d009
        sta $d00b
        sta $d00d
        sta $d00f
}
//-------------------------------------------------------------------------------------------------------------------------------------
.macro set_spr_ptr(sprnum, sprseg) {
        .var sprsegcor = mod(sprseg + 1, 13)
        .var sprptrbyte = $42 + 3*sprsegcor + (sprnum-4)
        .var zp_reg = ZPSPRPTR_BASE - $18 + 4*4*(sprnum-4)
        
        lda #sprptrbyte
        sta (zp_reg + 0,x)
        sta (zp_reg + 4,x)
        sta (zp_reg + 8,x)
        sta (zp_reg +12,x)
}
//-------------------------------------------------------------------------------------------------------------------------------------
.macro set_vic_bank() {
        lda zp_vicbank - $18,x
        sta $dd00
}
//-------------------------------------------------------------------------------------------------------------------------------------
//          Functions
//-------------------------------------------------------------------------------------------------------------------------------------
.function FindC64Col(rgb) {
    .var c64col = -1
    .for (var cidx=0; cidx<16; cidx++) {
        .if (rgb == C64ColList.get(cidx)) .eval c64col = cidx
    }
    .if (c64col == -1) .print "Char contains a non-C64 coloured pixel " + rgb
.return c64col
}
//-------------------------------------------------------------------------------------------------------------------------------------
.function Pixels2QuadCharCols(pic, charx, qchary) {
    .var QuadCharCols = List()
    .for (var relline=0; relline<2; relline++) {
        .for (var pixpos=0; pixpos<8; pixpos++) {
            .eval QuadCharCols.add(FindC64Col(pic.getPixel(8*charx + pixpos, 2*qchary + relline)))
        }
    }
.return QuadCharCols
}
//-------------------------------------------------------------------------------------------------------------------------------------
.function QuadCharCols2QuadCharData(qcharcols) {
    .var BitmapPatterns = List().add(0, 0)
    .var UsedCols = List().add(0, 0)
    
    .var minerr = 100000000
    .for (var c0 = 0; c0 < $10; c0++) {
        .for (var c1 = c0+1; c1 < $10; c1++) {
            .var err = 0
            .var BitmapPatternsCand = List()
            .var UsedColsCand = List().add(c0, c1)
            
            .for (var relline = 0; relline < 2; relline++) {
                .var bytetmp = 0
                
                .for (var pixpos = 0; pixpos < 8; pixpos++) {
                    .var idx = 8*relline + pixpos
                    .var pixerr_best = 100000000
                    .var bitpatt_best = 0
                    
                    .for (var bitpatt = 0; bitpatt < 2; bitpatt++) {
                        .var pixerr = Col_Dist.get(qcharcols.get(idx)).get(UsedColsCand.get(bitpatt))
                        .if (pixerr < pixerr_best) {
                            .eval pixerr_best = pixerr
                            .eval bitpatt_best = bitpatt
                        }  
                    }
                    .eval err += pixerr_best
                    .eval bytetmp += bitpatt_best*pow(2, 7-pixpos)
                }
                .eval BitmapPatternsCand.add(bytetmp)
            }
            .if (err < minerr) {
                .eval minerr = err
                .for (var j = 0; j < 2; j++) {
                    .eval UsedCols.set(j, UsedColsCand.get(j))
                    .eval BitmapPatterns.set(j, BitmapPatternsCand.get(j))
                }
                .if (minerr == 0) {
                    .eval c0 = $10
                    .eval c1 = $10
                }
            }
        }
    }
    //.printnow minerr
.return List().add(BitmapPatterns, UsedCols)
}
//-------------------------------------------------------------------------------------------------------------------------------------
.function Pic2QCHBitmap(pic) {
    .var QCHBitmap = List()
    .for (var charline=0; charline<25; charline++) {
        .for (var qcharx=0; qcharx<40; qcharx++) {
            .for (var charquad=0; charquad<4; charquad++) {
                .var qchary = 4*charline + charquad
                .eval QCHBitmap.addAll(QuadCharCols2QuadCharData(Pixels2QuadCharCols(pic, qcharx, qchary)).get(0))
            }
        }
    }
.return QCHBitmap
}
//-------------------------------------------------------------------------------------------------------------------------------------
.function Pic2QCHVRam(pic, idxofs) {
    .var QCHVRam = List().add(List(), List(), List(), List())
    .for (var charline=0; charline<25; charline++) {
        .for (var qcharx=0; qcharx<40; qcharx++) {
            .for (var charquad=0; charquad<4; charquad++) {
                .var qchary = 4*charline + charquad
                .var vramidx = VRamIdxList.get(mod(idxofs + qchary, 16))
                .var qcols = QuadCharCols2QuadCharData(Pixels2QuadCharCols(pic, qcharx, qchary)).get(1)
                .var colbyte = qcols.get(1)*$10 + qcols.get(0)
                .eval QCHVRam.get(vramidx).add(colbyte)
            }
        }
    }
.return QCHVRam
}
//-------------------------------------------------------------------------------------------------------------------------------------
.function ColHistOfTile(qcharcols) {
    .var HistList = List().add(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
    .for (var idx = 0; idx < qcharcols.size(); idx++) {
        .eval HistList.set(qcharcols.get(idx), HistList.get(qcharcols.get(idx)) + 1)
    }
.return HistList
}
//-------------------------------------------------------------------------------------------------------------------------------------
.function ColsUsedOfHist(qhist) {
    .var UsedColsList = List()
    .for (var col = 0; col < 16; col++) {
        .if (qhist.get(col) > 0) .eval UsedColsList.add(col)
    }    
.return UsedColsList
}
//-------------------------------------------------------------------------------------------------------------------------------------
.function ColNumScan(pic) {
    .for (var charline=0; charline<25; charline++) {
        .for (var qcharx=0; qcharx<40; qcharx++) {
            .for (var charquad=0; charquad<4; charquad++) {
                .var qchary = 4*charline + charquad
                .var qcharcols = Pixels2QuadCharCols(pic, qcharx, qchary)
                .var qcharcolsHist = ColHistOfTile(qcharcols)
                .var qcharcolsUsed = ColsUsedOfHist(qcharcolsHist)
                .if (qcharcolsUsed.size() > 2) .printnow "Tile at position qline = " + qchary + "; char = " + qcharx + " (x=" + (qcharx*8) + "; y=" + qchary*2 + ") uses more than 2 cols: found the following colours: " + qcharcolsUsed
            }
        }
    }
.return 0
}
//-------------------------------------------------------------------------------------------------------------------------------------
.function FindLetter(letter) {
    .var LetterNumber = 42
    .for (var testletteridx = 0; testletteridx < LetterList.size() ; testletteridx++) {
        .if (letter == LetterList.get(testletteridx)) {
            .eval LetterNumber = testletteridx
            .eval testletteridx = LetterList.size()
        }    
    }
.return LetterNumber
}
//-------------------------------------------------------------------------------------------------------------------------------------
.printnow "Pic consists of " + (1+f2acv) + " frames."

.printnow "Generating Bitmap Data for QCH-Pic... "
.printnow "...for frame 0..."
.const TestCols = ColNumScan(pic)
.const QCHBitmap = Pic2QCHBitmap(pic)
.if (f2acv == 1) {
    .printnow "...for frame 1..."
    .const TestCols = ColNumScan(pic1)
}
.const QCHBitmap1 = f2acv == 1 ? Pic2QCHBitmap(pic1) : QCHBitmap
.printnow "...done."

.printnow "Generating Colour-Data for QCH-Pic... "
.printnow "...for frame 0..."
.const QCHVRamAll = Pic2QCHVRam(pic, 0)
.if (f2acv == 1) {
    .printnow "...for frame 1..."
}
.const QCHVRamAll1 = f2acv == 1 ? Pic2QCHVRam(pic1, 8) : QCHVRamAll
.printnow "...done."
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $0900 "Init"
init:   
        ldx #$00
        lda #$20
clrscreen_loop:
        sta $0400,x
        sta $0500,x
        sta $0600,x
        sta $0700,x
        dex
        bne clrscreen_loop        
        
        lda #$18
        sta $d011
        lda #<nmi
        sta $fffa
        lda #>nmi
        sta $fffb

        lda #$00
        sta $d01a
        sta $dc0e
        sta $dc0f
        sta $dd0e
        sta $dd0f
        sta $d015
        sta $d017
        
        ldy #$80
        sty $d01c
        cmp $dc8d,y
        dey
        sty $dc0d
        sty $dd0d
        sta $dc05
        sta $dd04
        sta $dd05
        lda #$81
        sta $dd0d
sync_loop:
        lda #$3e
        sta $dc04
		
        ldx #$35
        shx $ff82,y     // y=$7f -> SHA stores to $ff82 + $7f = $0001 (hi-byte gets anded with $ff+1 = $00, which does not change it)
        cpx $01
        bne sync_loop
        lda #COLVAL_UPPER_PART
        sta $d020
        
        lda #<irq
        sta $fffe
        lda #>irq
        sta $ffff
        lda #$2d
        sta $d012
        lda #$08
        sta $d011
        lda #$11
        sta $dc0e   //-$7f,y
        sta $dd0e
        
        ldx #$10
sprxposcols_init_loop:
        lda spr_col_tab,x
        sta $d024,x
        lda spr_xpos_tab,x
        sta $d000,x
        .for (var zpinit_INST=0; zpinit_INST<6; zpinit_INST++) {
            lda zp_init_val_tab + zpinit_INST*$10,x
            sta $18 + zpinit_INST*$10,x
        }
        dex
        bpl sprxposcols_init_loop
        
    lda $dc04
blueprint3:
    sta dummyreg
    inc blueprint3+1
        
        lda #$f3    //$fc
        sta $d015
        lda #$e0
        sta $d01b
        
    ldx #$ff
    stx $dc02
    inx
    stx $dc03
        
        lda #$00
        jsr sidtune.init
        
//        lda #$2c
//wait_line_2c:
//        cmp $d012
//        bne wait_line_2c
		dec $d019
        inc $d01a
		dec $01
//-------------------------------------------------------------------------------------------------------------------------------------
//        lda #$ff
logo_fade_idle:
        bne logo_fade_idle
        ldy #$0f
delay_logo_fadein_loop:
        jsr slowdown
        jsr slowdown
        jsr slowdown
        dey
        bne delay_logo_fadein_loop
logo_fade_in_out:
        lda #$b0
        ldx #$0f
        jsr logocol_copy
        ldy #$10
keep_logo_loop:
        jsr slowdown
        jsr slowdown
        jsr slowdown
        dey
        bne keep_logo_loop
        lda #$0b
        ldx #$f0
        jsr logocol_copy
wc:		
        lda #$d0
main_thread_idle:
        bne main_thread_idle
        sta main_thread_idle
        
        .var MAIN_THREAD_ADR = *
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $0d00 "Delay Subroutine"
delay:              // subrout for cycle delay
                    // jsr delay + 63 - <no.of delay-cycles> with <no.of delay-cycles> = 14..63  
        nop #$80    
        nop #$80
        nop #$80
        nop #$80
        nop #$80
        
        nop #$80
        nop #$80
        nop #$80
        nop #$80
        nop #$80
        
        nop #$80
        nop #$80
        nop #$80
        nop #$80
        nop #$80
        
        nop #$80
        nop #$80
        nop #$80
        nop #$80
        nop #$80
        
        nop #$80
        nop #$80
        nop #$80
        nop #$80
        nop $ea
mindelay:
        rts
//-------------------------------------------------------------------------------------------------------------------------------------
        *= * "IRQ routine"
irq:    
        inc $01
        sta zpa
        lda $dc04
        stx zpx
        sty zpy
        
        lsr
        bcs skip1
skip1:	
		asr #$03
		bcc skip2
		bcs skip2
skip4:	
		bne endvarkill
skip2:	
		bne skip4		
endvarkill:
        jmp flirout
//-------------------------------------------------------------------------------------------------------------------------------------
spr_xpos_tab:
        .byte $18, $05
        .byte $18, $1a
        .byte $18, $16
        .byte $18, $01
        
        .byte $00, $2f  // $d008 = $18 will be set later in FLI routine
        .byte $18, $2f
        .byte $18, $2f
        .byte $18, $2f
        .byte $00
spr_col_tab:
        .byte $00
        .byte $00, $00
        .byte $0f, $0f, $0f, $0f
        .byte $00, $00, $00, $00
zp_init_val_tab:
.pseudopc $18 {
ZPSPRPTR_BASE:
        .byte $fc, $c3
        .byte $fc, $43
        .byte $fc, $c7
        .byte $fc, $47
        .byte $fc, $cb
        .byte $fc, $4b
        .byte $fc, $cf
        .byte $fc, $4f
        
        .byte $fd, $c3
        .byte $fd, $43
        .byte $fd, $c7
        .byte $fd, $47
        .byte $fd, $cb
        .byte $fd, $4b
        .byte $fd, $cf
        .byte $fd, $4f
        
        .byte $fe, $c3
        .byte $fe, $43
        .byte $fe, $c7
        .byte $fe, $47
        .byte $fe, $cb
        .byte $fe, $4b
        .byte $fe, $cf
        .byte $fe, $4f
zp_qline01:
        .byte $3a
zp_qline01f1seg1:
        .byte $3a   //$3b
zp_qline01f1:
        .byte $3a   //$3b
zp_qline01seg1:
        .byte $3a
        
zp_qline02:
        .byte $3c
zp_qline02f1seg1:
        .byte $3c   //$3d
zp_qline02f1:
        .byte $2c   //$2d
zp_qline02seg1:
        .byte $2c
        
zp_qline03:
        .byte $2e
zp_qline03f1seg1:
        .byte $2e   //$2f
zp_qline03f1:
        .byte $3e   //$3f
zp_qline03seg1:
        .byte $3e
        
zp_vicbank:
        .byte $30
zp_column_mask_ff:
        .byte $ff
//zp_vicbank+2:
        .byte $32
//zp_
        .byte $ff
zp_first_badline:
        .byte $38   //$39
zp_spr1pos:
        .byte $1a   //$1b
//zp__start_sprpos+2:
        .byte $38
//zp_spr1pos+2:
        .byte $1a
zp_flibyte0:
        .byte $38   //$39
zp_new_xval:
        .byte $1a   //$1a   //set to $18 for interlace
//zp_flibyte0+2:
        .byte $28
//zp_new_xval+2:
        .byte $1a
zp_scrollspeed:
        .byte $01
zp_letterline:
        .byte $ff
zp_start_xval:
        .byte $1a
zp_column_mask:
        .byte $ff
zp_column_mask2:
        .byte $ff
zp_scrollblend_flag:
        .byte $00
zp_pre_dc01:
        .byte $ff
zp_blend_idx:
        .byte $00
zp_screen_switch_flag:
        .byte $ff
zp_master_xval:
        .byte $1a
zp_zero_scroll_idx:
        .byte $00
zp_sidtune_flag:
        .byte $00
zp_logopixel_left:
        .byte $b0
}       
//.printnow "no. of zp byte = " + (* - zp_init_val_tab)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $0f00 "Letter Height Tab"
letterheight_tab:
        .for (var letter = 0; letter < LetterHeightList.size(); letter++) {
            .byte LetterHeightList.get(letter)
            .byte LetterHeightList.get(letter)
            .byte LetterHeightList.get(letter)
        }
//-------------------------------------------------------------------------------------------------------------------------------------
blendmask_left:
        .byte $ff
        .byte %01111111, %01110111, %01110111, %01010111, %01010111, %01010111, %00010111, %00010111
        .byte %00010101, %00010001, %00010001, %00010001, %00010001, %00010000, %00010000, %00000000
//-------------------------------------------------------------------------------------------------------------------------------------
blendmask_right:
        .byte $ff
        .byte %11111111, %11111111, %11111101, %11111101, %10111101, %10011101, %10011101, %10011001
        .byte %10011001, %10011001, %10011000, %10010000, %10000000, %10000000, %00000000, %00000000 
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $1000 "SID Data"
        .fill sidtune.size, sidtune.getData(i)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $9000 "FLI routine"
//-------------------------------------------------------------------------------------------------------------------------------------
flirout:
        ldy #$ff
        ldx zp_start_xval
        lda zp_first_badline - $18,x
        sta $d011
        sec
        sbc #$09
line_sync:
        cmp $d012
        sta $d009-$ff,y
        sta $d00b-$ff,y
        sta $d00d-$ff,y
        sta $d00f-$ff,y
        clc
        nop //bne line_sync
        nop
        nop
        nop
        nop
        nop
        nop $ea
        nop
        nop
        lda #COLVAL_SCREEN_PART
        sta $d020
        sta $d021
        :delay(33)
        sty SPRREG_SCROLLGAPS   //=$d02b
        
        lda zp_flibyte0 - $18,x
        sta $d018 - $ff,y
        ldy #$08
        :set_vic_bank()
        sty $d016
                
        .for (var qline=0; qline<99; qline++) {
            .var nqline = qline + 1
            .var qline8 = mod(qline, 8)
            .var nqline4 = mod(nqline, 4)
            .var nqline8 = mod(nqline, 8)
            .var sprseg = floor(qline/8)
            
            .if(qline8==0) {
                eor #$2a
                tax
            }
            
            :adjust_flibyte(nqline8)
            
            .if (nqline4>0) {
                :set_spr_col(nqline)
            }
            .if (nqline8==4) {
                sta $d011
                sta $d018
                :set_spr_ptr(4, sprseg)
                sty SPRREG_SCROLLGAPS   //$d02b
                :set_spr_ptr(5, sprseg)
            }
            .if (nqline8==0) {
                sta $d011
                :set_spr_pos(2*qline + 1)
                :set_spr_ptr(6, sprseg)
                :set_vic_bank()
                sty SPRREG_SCROLLGAPS
            }
            
            :preload_yreg(nqline8)
            
            .if (nqline4>0) {
                sta $d011
            }
        }
        lda zp_new_xval - $18,x
        tax
        stx zp_start_xval
        :set_spr_ptr(4, 12)
        lda #$18
        sta $d008
        nop
        nop
        sty SPRREG_SCROLLGAPS   //=$d02b
        ldy #$18
        lda #$03
        sta $dd00
        sty $d016
        
        :set_spr_ptr(5, 12)
        nop $ea
        lda zp_spr1pos - $18,x
        sta $d003
		lda #$0c
		sta $d015
        lda #COLVAL_LOWER_PART
        sta $d021
        sta $d020
        
        :set_spr_ptr(6, 12)
        lda #$30
        sta $d011
        
        .var ScrollerLinkList = List()
        .const ScrollSpr2_adr = $3e80
        .const ScrollSpr3_adr = $3ec0
        
        .const ScrollSpr4_adr = $3f40
        .const ScrollSpr0_adr = $3f80
        .const ScrollSpr1_adr = $3f00
        
        .const SpriteOrderList = List().add(ScrollSpr2_adr, ScrollSpr3_adr, ScrollSpr4_adr, ScrollSpr0_adr, ScrollSpr1_adr)
        
        .for (var line = 0; line < $09; line++) {
            .eval ScrollerLinkList.add(dummyreg)
            .eval ScrollerLinkList.add(dummyreg)
        }
        
        .for (var line = $09; line < $30; line++) {
            .var line_abs = line - $06
            .var line_rel = mod(line_abs, 21)
            .var base_adr_idx = floor(line_abs/21)
            .var adr = SpriteOrderList.get(base_adr_idx) + 3*line_rel + 1
            .eval ScrollerLinkList.add(adr)
            .eval ScrollerLinkList.add(adr + 1)
        }
        .for (var charline = 0; charline < 25; charline++) {
            .var sprseg = floor(charline/2)
            .var segment = mod(sprseg, 2)
            .var sprline = mod(charline*$8, 21)
            
            .var sprbase = segment==0 ? $5080 : $d080
            
            .eval ScrollerLinkList.add(sprbase + sprseg*3*$40 + sprline*$3 + 1)
            .eval ScrollerLinkList.add(sprbase + sprseg*3*$40 + sprline*$3 + 1 + 1)
            .eval ScrollerLinkList.add(sprbase + sprseg*3*$40 + mod(sprline+1, 21)*$3 + 1)
            .eval ScrollerLinkList.add(sprbase + sprseg*3*$40 + mod(sprline+1, 21)*$3 + 1 + 1)
            
            .var gfxbase = segment==0 ? $6000 : $e000
            
            .for (var relline = 0; relline < 6; relline++) {
                .eval ScrollerLinkList.add(gfxbase + charline*$140 + $8 + 2 + relline)
                .eval ScrollerLinkList.add(gfxbase + charline*$140 + $8 + 2 + relline + $8)
            }
        }
        .for (var line = $f8; line < $12c; line++) {
            .var line_abs = line - $ed
            .var line_rel = mod(line_abs, 21)
            .var base_adr_idx = floor(line_abs/21) + 2
            .var adr = SpriteOrderList.get(base_adr_idx) + 3*line_rel + 1
            .eval ScrollerLinkList.add(adr)
            .eval ScrollerLinkList.add(adr + 1)
        }
        
        inc SIDEBORDER_COLREG
        lda $d011
        sta dummyreg
        lda $d012
        sta dummyreg
        
        dec $01
        nop $ea
scrollrout:
        lda #$01
        sta zp_scrollspeed
        .var LdaStaList = List()
        .var cyc_used = 0
        .var copy_blks_dne = 0
        .for (var column = 0; column < 2; column++) {
            ldx zp_column_mask + column //zp_column_mask_ff    //#$ff
            .eval cyc_used += 3
            .for (var gfxline = $09; gfxline < $f8; gfxline++) {
                .if (gfxline == $2f) { 
                    .eval LdaStaList.add(*)
                    //inc $01
                    //inc $d020
                    //dec $01
                }
                lda ScrollerLinkList.get(2*(gfxline + 1) + column)
                .if (gfxline == $f7) { 
                    .eval LdaStaList.add(*)
                    //inc $01
                    //dec $d020
                    //dec $01
                }
                sax ScrollerLinkList.get(2*gfxline + column)
                .eval cyc_used += 8
                .eval copy_blks_dne++
                .if (copy_blks_dne == 351) {
                    .eval LdaStaList.add(*-3)
                    //.printnow "cyc used at lower col - change = " + cyc_used
                    //.printnow "copy-block counter at this spot is = " + copy_blks_dne
                    inc $01
                    lda $d012
                    sta dummyreg
                    lda #$f3
                    sta $d015
                    
                    lda #$00
                    sta $d020
                    sta $d021
                    dec $01
                    .eval LdaStaList.add(*)
                }
            }
            //inc $01
            //inc $d020
            //dec $01
        }
        //.printnow "cyc used at loop change point = " + cyc_used
        //.printnow "copy-block counter at loop change point = " + copy_blks_dne
        
        //.printnow LdaStaList
        
        .for (var column = 1; column >=0; column--) {
            .if (column == 0) {
                ldx zp_column_mask  //zp_column_mask_ff
                .eval cyc_used += 3
            }
            .for (var gfxline = $f8; gfxline < $116; gfxline++) {
                lda ScrollerLinkList.get(2*(gfxline + 1) + column)
                sax ScrollerLinkList.get(2*gfxline + column)
                .eval cyc_used += 8
                .eval copy_blks_dne++
                .if (copy_blks_dne == 511) {
                    //.printnow cyc_used
                    nop
                    inc $01
                    lda #COLVAL_UPPER_PART  //$0b
                    sta $d021
                    sta $d020
                    dec $01
                }
            }
        }
        //.printnow "max blk copy counter value is = " + copy_blks_dne
        inc $01
skipscroll:
        ldy zp_zero_scroll_idx
        beq cont_normal_scroll
        dey
        sty zp_zero_scroll_idx
        bne skip_screen_switch
        asl main_thread_idle
        lda zp_master_xval
        eor #$02
        tay
        sta zp_new_xval - $18,y
skip_screen_switch:
        lda #$00
        sta ScrollerLinkList.get(2*$116)
        sta ScrollerLinkList.get(2*$116 + 1)
        beq chk_scrollblending
cont_normal_scroll:
        ldy zp_letterline
        bpl get_nextline
.if (ROWMODE == 1) {
        lda #$20
        sta ld_scroll_linebyte0+2
ld_scroll:
        ldy intro_text_adr  //scrolltext
        inc ld_scroll+1
        
        tya
        asl
        asl
        asl
        
        asl
        rol ld_scroll_linebyte0+2
        asl
        rol ld_scroll_linebyte0+2
        
        sta ld_scroll_linebyte0+1
        sta ld_scroll_linebyte1+1
        
        lda ld_scroll_linebyte0+2
        ora #$04
        sta ld_scroll_linebyte1+2
        
        lda letterheight_tab,y
        tay
} else {
        lda #$10
        sta ld_scroll_linebyte0+2
ld_scroll:
        lax intro_text_adr  //scrolltext
        inc ld_scroll+1
        bne skip_hiinc
        ldy ld_scroll+2
        lda scroll_inc_tab - >scrolltext,y
        sta ld_scroll+2
        txa
skip_hiinc:
        cpx #$ff
        bne chk_music_trigger
        ldx #$01
        stx zp_blend_idx
        beq ld_scroll
chk_music_trigger:
        cpx #$fe
        bne chk_logo_fade_trigger
        stx zp_sidtune_flag
        beq ld_scroll 
chk_logo_fade_trigger:
        cpx #$fd
        bne chk_screenswap_trigger
        asl logo_fade_idle
        bcs ld_scroll
chk_screenswap_trigger:
        cpx #$e8
        bne skip_zero_scroll_act
        stx zp_zero_scroll_idx
        beq chk_scrollblending
skip_zero_scroll_act:
        asl
        rol ld_scroll_linebyte0+2
        asl
        rol ld_scroll_linebyte0+2
        asl
        rol ld_scroll_linebyte0+2
        sta ld_scroll_linebyte0+1
        sta ld_scroll_linebyte1+1
        
        lda ld_scroll_linebyte0+2
        ora #$84
        sta ld_scroll_linebyte1+2
        ldy letterheight_tab,x
}
get_nextline:
ld_scroll_linebyte0:
        lda $8000,y
        ldx zp_column_mask
        sax ScrollerLinkList.get(2*$116)
ld_scroll_linebyte1:        
        lda $8400,y
        ldx zp_column_mask + 1
        sax ScrollerLinkList.get(2*$116 + 1)
        dey
        sty zp_letterline
chk_scrollblending:
        ldx zp_blend_idx
        cpx #$00
        bne chk_idx_40
        
        lda zp_scrollblend_flag
        beq skip_scroll_blending
chk_idx_40:
        cpx #$11
        bne perform_blending
skip_main_thread:
        lda zp_scrollblend_flag
        bne skip_scroll_blending
        
        ldx #$ff
        stx zp_column_mask
        stx zp_column_mask2
        sta zp_blend_idx
        bne skip_scroll_blending
perform_blending:
        lda blendmask_left,x
        sta zp_column_mask
        lda blendmask_right,x
        sta zp_column_mask + 1
        inc zp_blend_idx
skip_scroll_blending:
        ldx #$7f
        stx $dc00
        ldx $dc01
        cpx #$ff
        bne key_pressed
no_key_pressed:
        lda zp_pre_dc01
        cmp #$ef
        bne no_flag_change
        lda zp_scrollblend_flag
        //eor #$01
        lda #$00
        sta zp_scrollblend_flag
no_flag_change:
key_pressed:
        stx zp_pre_dc01
        
    lda #$00
    sta SIDEBORDER_COLREG   //set to dummyvalue, usually =$d020
        
    lda $d012
    sta dummyreg
        lda zp_sidtune_flag
        beq delay_sidtune
        jsr sidtune.play
delay_sidtune:
        lda zpa
        ldx zpx
        ldy zpy
        dec $d019
        dec $01
nmi:    rti
//-------------------------------------------------------------------------------------------------------------------------------------
        *= MAIN_THREAD_ADR "Scroll speedcode swap-routine"
        lda LdaStaList.get(0)+2
        eor #$80
        sta LdaStaList.get(0)+2
        sta LdaStaList.get(2)+2
        eor #$2e
        sta LdaStaList.get(1)+2
        sta LdaStaList.get(5)+2
        
        
        .const LoadAdrStrt = (LdaStaList.get(5) - 4) & $ff00
        .const OfsIdxReg = mod(LdaStaList.get(5) - 4, $100) 
        .const WriteAdr0 = LoadAdrStrt
        .const WriteAdr1 = LdaStaList.get(1) - 4 - OfsIdxReg
        .const SprSetGap = LdaStaList.get(4) - LdaStaList.get(3)
        //.printnow "Gapval = " + SprSetGap 
        
        ldx #OfsIdxReg
        lda #>LoadAdrStrt
        sta ld_byte+2
        lda #>WriteAdr0
        sta st_byte0+2
        lda #<WriteAdr1
        sta st_byte1+1
        lda #>WriteAdr1
        sta st_byte1+2
        lda #$80
        sta branch_op
        lda #$01
        sta cp_byte+1
        bne ld_byte
eor_loop:
        eor #$80
st_byte0:
        sta WriteAdr0,x
st_byte1:
        sta WriteAdr1,x
        txa
        sbx #$03
        bcs ld_byte
        dec ld_byte+2
        dec st_byte0+2
        dec st_byte1+2
ld_byte:
        lda LoadAdrStrt,x
cp_byte:
        cmp #$01
        bne eor_loop
branch_op:
        beq end_loop    //will be replaced by a nop #val in the 1st loop run
        txa
        sbx #$17
        lda #(<WriteAdr1)+$17
        sta st_byte1+1
        lda #BEQ_REL
        sta branch_op
        lda #$3e
        sta cp_byte+1
        bne ld_byte
end_loop:
        lda zp_master_xval
        eor #$02
        sta zp_new_xval
        sta zp_new_xval+2
        sta zp_master_xval
permit_gfxcopy:
        nop wc
        lda #$4c
        sta permit_gfxcopy
        
        ldx #$10
        lda #$c0
outer_loop:
        cpx #$10
        bne store_adrbytes
        and #$7f
        ldx #$00
store_adrbytes:
        stx st_colbyte + 1
        stx ld_colbyte + 1
        sta st_colbyte + 2
        //and #$0f
        //ora #$b0
        //sta ld_colbyte + 2    // "inc ld_colbyte + 2" is shorter
        cpx #$c0
        bne loop_init_x
        ldx #$27
        bne core_loop
loop_init_x:
        ldx #$4f
core_loop:
ld_colbyte:
        lda $b000,x
st_colbyte:
        sta $4000,x
        dex
        bpl core_loop
        lda st_colbyte + 1
        sbx #($100-$50)
        bcc skip_inc_ldcol_hi
        inc ld_colbyte + 2      // "inc ld_colbyte + 2" is shorter
skip_inc_ldcol_hi:
        lda st_colbyte + 2
        adc #$80
        cmp #$d0
        bne outer_loop
        
        ldy #$03
collist_init_loop:
        ldx #$98
ld_collist:
        lda $dd00,x
st_collist:
        sta $5d17,x
        dex
        bne ld_collist
        inc ld_collist+2
        inc st_collist+2
        dey
        bne collist_init_loop
        
        ldy #11
        bne gfx_copy_loop_entry
outer_gfx_copy_loop:
        lax ld_bitmap + 1
        sbx #$80
        lda #$01
        bcc no_eor_hi
        inc ld_bitmap + 2
        eor #$80
no_eor_hi:        
        stx ld_bitmap + 1
        sta add_bitmap_hi + 1
        
        lax st_bitmap + 1
        sbx #$c0
        lda st_bitmap + 2
add_bitmap_hi:
        adc #$01
        stx st_bitmap + 1
        sta st_bitmap + 2
gfx_copy_loop_entry:
        ldx #$7f
gfx_copy_loop:
ld_bitmap:
        lda logo_swap_bitmap,x
st_bitmap:
        sta $6000 + 5*$140 + $08*13,x
        dex
        bpl gfx_copy_loop
        dey
        bne outer_gfx_copy_loop
        
        jmp wc
//-------------------------------------------------------------------------------------------------------------------------------------
// GFX-Data handling
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $0e00 "Swap Tab"
swaptab:
        .fill $100, mod(i, $10)*$10 + floor(i/16)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $0bf8
        .byte $fa, $fb, $fc, $fe
        .byte $fd, $ff, $ff, $ff        
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $0ff8
        .byte $fa, $fb, $fc, $fe
        .byte $fd, $ff, $ff, $ff
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $3080 "Shadow Bitmap"
logo_swap_bitmap:
        .for (var charline = 5; charline < 16; charline++) {
            .fill 16*$8, QCHBitmap.get($140*charline + $8*13 + i)
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        *= * "Colours for Fat Pixel Logo"
logo_cols_VRAM0:
        .for (var logoline = 0; logoline < 11; logoline++) {
            .for (var xpos = 0; xpos < 32; xpos += 2) {
                .var leftcol_tmp = FindC64Col(logo.getPixel(xpos, logoline*4))
                .var rightcol_tmp = FindC64Col(logo.getPixel(xpos+1, logoline*4))
                .byte leftcol_tmp*$10 + rightcol_tmp
            }            
        }
//-------------------------------------------------------------------------------------------------------------------------------------
logo_cols_VRAM1:
        .for (var logoline = 0; logoline < 11; logoline++) {
            .for (var xpos = 0; xpos < 32; xpos += 2) {
                .var leftcol_tmp = FindC64Col(logo.getPixel(xpos, logoline*4 + 1))
                .var rightcol_tmp = FindC64Col(logo.getPixel(xpos+1, logoline*4 + 1))
                .byte leftcol_tmp*$10 + rightcol_tmp
            }            
        }
//-------------------------------------------------------------------------------------------------------------------------------------
logo_cols_VRAM2:
        .for (var logoline = 0; logoline < 11; logoline++) {
            .for (var xpos = 0; xpos < 32; xpos += 2) {
                .var leftcol_tmp = FindC64Col(logo.getPixel(xpos, logoline*4 + 2))
                .var rightcol_tmp = FindC64Col(logo.getPixel(xpos+1, logoline*4 + 2))
                .byte leftcol_tmp*$10 + rightcol_tmp
            }            
        }
//-------------------------------------------------------------------------------------------------------------------------------------
logo_cols_VRAM3:
        .for (var logoline = 0; logoline < 11; logoline++) {
            .for (var xpos = 0; xpos < 32; xpos += 2) {
                .var leftcol_tmp = FindC64Col(logo.getPixel(xpos, logoline*4 + 3))
                .var rightcol_tmp = FindC64Col(logo.getPixel(xpos+1, logoline*4 + 3))
                .byte leftcol_tmp*$10 + rightcol_tmp
            }            
        }
//-------------------------------------------------------------------------------------------------------------------------------------
logocol_copy:
        sta zp_logopixel_left
        stx compare_logopixel_mask + 1
        ldy #$0f
logocol_copy_loop:
        jsr slowdown
        .for (var charline = 5; charline < 16; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .var vramidx = mod(charline*4, 16)
            txa
            and logo_cols_VRAM0 + (charline - 5)*$10,y
            ora zp_logopixel_left
            sta $4000 + segment*$8000 + VRamIdxList.get(vramidx)*$0400 + 40*charline + 13,y
            //jsr slowdown
            txa
            and logo_cols_VRAM1 + (charline - 5)*$10,y
            ora zp_logopixel_left
            sta $4000 + segment*$8000 + VRamIdxList.get(mod(vramidx+1, 16))*$0400 + 40*charline + 13 ,y
            //jsr slowdown
            txa
            and logo_cols_VRAM2 + (charline - 5)*$10,y
            ora zp_logopixel_left
            sta $4000 + segment*$8000 + VRamIdxList.get(mod(vramidx+2, 16))*$0400 + 40*charline + 13 ,y
            //jsr slowdown
            txa
            and logo_cols_VRAM3 + (charline - 5)*$10,y
            ora zp_logopixel_left
            sta $4000 + segment*$8000 + VRamIdxList.get(mod(vramidx+3, 16))*$0400 + 40*charline + 13 ,y
            //jsr slowdown
        }
change_pixel_side:
        lda zp_logopixel_left
eor_logopixel_left:
        eor #$b0
        sta zp_logopixel_left
        txa
mask_logopixel_left:
        eor #$f0
        tax
compare_logopixel_mask:
        cpx #$00
        beq cont_logocol_loop
        jmp logocol_copy_loop
cont_logocol_loop:
        dey
        bmi end_colcopy
        jmp logocol_copy_loop
end_colcopy:
        rts
slowdown:
        sty reload_y+1
        ldy #$00
slowdown_loop:
        jsr end_colcopy
        dey
        bne slowdown_loop
reload_y:
        ldy #$00
        rts
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $3e80 "Sprite blocks for Scroller in upper/lower border"
        .fill $40, $00
        *= $3ec0
        .fill $40, $00
        *= $3f00
        .fill $40, $00
        *= $3f40
        .fill $40, $00
        *= $3f80
        .fill $40, $00
        *= $3fc0
        .fill $40, $00
//-------------------------------------------------------------------------------------------------------------------------------------
// ----- 1st frame -----
//-------------------------------------------------------------------------------------------------------------------------------------
        .var shadowAdress_List = List()
        *= $4000 "VRAM 0"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==0) {
                .eval shadowAdress_List.add(*)
                .fill $28, $bb
            } else {
                .fill $28, QCHVRamAll1.get(0).get($28*charline + i)
            }
        }
        *= $43ff
        .byte $40   //$ff
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $4400 "VRAM 1"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==0) {
                .eval shadowAdress_List.add(*)
                .fill $28, $bb
            } else {
                .fill $28, QCHVRamAll1.get(1).get($28*charline + i)
            }
        }
        *= $47ff
        .byte $40
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $4800 "VRAM 2"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==0) {
                //.fill $28, QCHVRamAll.get(2).get($28*charline + i) 
                .eval shadowAdress_List.add(*)
                .fill $28, $bb
            } else {
                .fill $28, QCHVRamAll1.get(2).get($28*charline + i)
            }
        }
        *= $4bff
        .byte $41
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $4c00 "VRAM 3"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==0) {
                .eval shadowAdress_List.add(*)
                .fill $28, $bb
            } else {
                .fill $28, QCHVRamAll1.get(3).get($28*charline + i)
            }
        }
        *= $4fff
        .byte $40
        //.printnow shadowAdress_List
//-------------------------------------------------------------------------------------------------------------------------------------
        //.var sprbase = $5080
        .for (var gfxline=0; gfxline<200; gfxline++) {
            .var charline = floor(gfxline/8)
            .var sprseg = floor(gfxline/16)
            .var sprbase = mod(sprseg, 2)==0 ? $5080 : $d080
            .var sprline = mod(gfxline, 21)
            .var sprbytetmp
            .for (var charcolumn=0; charcolumn<3; charcolumn++) {
                *= sprbase + (sprseg*3 + charcolumn)*$40 + sprline*$3 "Sprite blocks for FLI Bug Pixels"
                .if (mod(gfxline, 8)<2) {
                    .byte $00, $00, $00
                } else {
                    .eval sprbytetmp = charcolumn==0 ? QCHBitmap.get($140*charline + $00 + mod(gfxline, 8)) : $00
                    .byte sprbytetmp
                    .eval sprbytetmp = charcolumn==1 ? QCHBitmap.get($140*charline + $08 + mod(gfxline, 8)) : $00
                    .byte sprbytetmp
                    .eval sprbytetmp = charcolumn==2 ? QCHBitmap.get($140*charline + $10 + mod(gfxline, 8)) : $00
                    .byte sprbytetmp
                }
            }
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        .var ColTable0 = List(152)
        .var ColTable1 = List(152)
        .var ColTable2 = List(152)
        
        .for (var idx=0; idx<152; idx++) {
            .eval ColTable0.set(idx, 0)
            .eval ColTable1.set(idx, 0)
            .eval ColTable2.set(idx, 0)
        }
        .var FLIColList = List().add(ColTable0, ColTable1, ColTable2)
        .var ofsidx = 0
        
        .for (var qline=0; qline<100; qline++) {
            .if (mod(qline, 4)>0) {
                .for (var charcolumn=0; charcolumn<3; charcolumn++) {
                    .var charline = floor(qline/4)
                    .var vramidx = VRamIdxList.get(mod(qline, 16))
                    .var vramidx1 = VRamIdxList.get(mod(8 + qline, 16))
                    .if (mod(charline, 4)<2) {
                        .eval FLIColList.get(charcolumn).set(ofsidx, QCHVRamAll.get(vramidx).get($28*charline + charcolumn))
                        .eval FLIColList.get(charcolumn).set(ofsidx+2, QCHVRamAll1.get(vramidx1).get($28*charline + charcolumn))
                    } else {
                        .eval FLIColList.get(charcolumn).set(ofsidx, QCHVRamAll1.get(vramidx1).get($28*charline + charcolumn))
                        .eval FLIColList.get(charcolumn).set(ofsidx+2, QCHVRamAll.get(vramidx).get($28*charline + charcolumn))
                    }
                }
                .eval ofsidx += 1
                .if (mod(ofsidx, 2)==0) .eval ofsidx += 2
            }
        }
//        .printnow ofsidx
//        .printnow FLIColList.get(0).size()
//        .printnow FLIColList.get(0).get(150)
//        .printnow FLIColList.get(1).size()
//        .printnow FLIColList.get(2).size()
//-------------------------------------------------------------------------------------------------------------------------------------
        *= FLIbugColTabBase "Col Tabs for FLI Bug Pixels" //=$5800
        .fill $18, $00
        .for (var blkidx = 0; blkidx < 6; blkidx++) {
            .byte $bb
            .byte $bb
            .byte FLIColList.get(0).get(blkidx*24 + 2)
            .byte FLIColList.get(0).get(blkidx*24 + 3)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(0).get(blkidx*24 + 6)
            .byte FLIColList.get(0).get(blkidx*24 + 7)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(0).get(blkidx*24 + 10)
            .byte FLIColList.get(0).get(blkidx*24 + 11)
            .byte FLIColList.get(0).get(blkidx*24 + 12)
            .byte FLIColList.get(0).get(blkidx*24 + 13)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(0).get(blkidx*24 + 16)
            .byte FLIColList.get(0).get(blkidx*24 + 17)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(0).get(blkidx*24 + 20)
            .byte FLIColList.get(0).get(blkidx*24 + 21)
            .byte $bb
            .byte $bb
        }
            .byte $bb
            .byte $bb
            .byte FLIColList.get(0).get(6*24 + 2)
            .byte FLIColList.get(0).get(6*24 + 3)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(0).get(6*24 + 6)
            .byte FLIColList.get(0).get(6*24 + 7)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= FLIbugColTabBase + $100 //=$5800
        .fill $18, $00
        .for (var blkidx = 0; blkidx < 6; blkidx++) {
            .byte $bb
            .byte $bb
            .byte FLIColList.get(1).get(blkidx*24 + 2)
            .byte FLIColList.get(1).get(blkidx*24 + 3)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(1).get(blkidx*24 + 6)
            .byte FLIColList.get(1).get(blkidx*24 + 7)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(1).get(blkidx*24 + 10)
            .byte FLIColList.get(1).get(blkidx*24 + 11)
            .byte FLIColList.get(1).get(blkidx*24 + 12)
            .byte FLIColList.get(1).get(blkidx*24 + 13)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(1).get(blkidx*24 + 16)
            .byte FLIColList.get(1).get(blkidx*24 + 17)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(1).get(blkidx*24 + 20)
            .byte FLIColList.get(1).get(blkidx*24 + 21)
            .byte $bb
            .byte $bb
        }
            .byte $bb
            .byte $bb
            .byte FLIColList.get(1).get(6*24 + 2)
            .byte FLIColList.get(1).get(6*24 + 3)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(1).get(6*24 + 6)
            .byte FLIColList.get(1).get(6*24 + 7)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= FLIbugColTabBase + $200 //=$5800
        .fill $18, $00
        .for (var blkidx = 0; blkidx < 6; blkidx++) {
            .byte $bb
            .byte $bb
            .byte FLIColList.get(2).get(blkidx*24 + 2)
            .byte FLIColList.get(2).get(blkidx*24 + 3)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(2).get(blkidx*24 + 6)
            .byte FLIColList.get(2).get(blkidx*24 + 7)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(2).get(blkidx*24 + 10)
            .byte FLIColList.get(2).get(blkidx*24 + 11)
            .byte FLIColList.get(2).get(blkidx*24 + 12)
            .byte FLIColList.get(2).get(blkidx*24 + 13)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(2).get(blkidx*24 + 16)
            .byte FLIColList.get(2).get(blkidx*24 + 17)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(2).get(blkidx*24 + 20)
            .byte FLIColList.get(2).get(blkidx*24 + 21)
            .byte $bb
            .byte $bb
        }
            .byte $bb
            .byte $bb
            .byte FLIColList.get(2).get(6*24 + 2)
            .byte FLIColList.get(2).get(6*24 + 3)
            .byte $bb
            .byte $bb
            .byte FLIColList.get(2).get(6*24 + 6)
            .byte FLIColList.get(2).get(6*24 + 7)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $dd00
        .byte $00
        .fill FLIColList.get(0).size(), FLIColList.get(0).get(i)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $de00
        .byte $00
        .fill FLIColList.get(1).size(), FLIColList.get(1).get(i)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $df00
        .byte $00
        .fill FLIColList.get(2).size(), FLIColList.get(2).get(i)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $6000 "Bitmap"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==0) {
                .for (var char=0; char<3; char++) {
                    .fill 2, QCHBitmap.get($140*charline + $8*char + i)
                    .fill 6, $00
                }
                .for (var char=3; char<40; char++) {
                    .if ((char > 12) && (char < 13+16) && (charline > 4) && (charline < 16)) {
                        .fill 8, $f0
                     } else {
                        .fill 8, QCHBitmap.get($140*charline + $8*char + i)
                     }
                }
            } else {
                .for (var char=0; char<3; char++) {
                    .fill 2, QCHBitmap1.get($140*charline + $8*char + i)
                    .fill 6, $00
                }
                .for (var char=3; char<40; char++) {
                    .fill 8, QCHBitmap1.get($140*charline + $8*char + i)
                }            
            }
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $5000 "MC Sprite Pattern"    //$7fc0
        .for (var sprline=0; sprline<21; sprline++) {
                .byte $55, $ff, $aa
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $5040 "Empty Sprite Pattern"
        .fill $40, $00
//-------------------------------------------------------------------------------------------------------------------------------------
        .var letterheight_max = ROWMODE == 1 ? $20 : $18
        .var letters_total = ROWMODE == 1 ? 27 : 42
        .for (var letter=0; letter < letters_total; letter++) {
            *= $8000 + letter*letterheight_max "Font Definition, left side"
            .var maxidx = LetterHeightList.get(letter) + 1  //ROWMODE == 1 ? LetterHeightList.get(letter) + 1 : $18
            .for (var line=0; line < maxidx; line++) {     //LetterHeightList.get(letter)+1; line++)
                .var font_ypos = ROWMODE == 1 ? LetterHeightList.get(letter) - line : floor(letter*2/40)*$18 + LetterHeightList.get(letter) - line 
                .var font_xpos = ROWMODE == 1 ? letter*2 : mod(letter*2, 40)
                .byte font.getSinglecolorByte(font_xpos,font_ypos)
            }
        }
        .align $10
        //.printnow "lastletter at " + *
        .for (var line=0; line < LetterHeightList.get(42) + 1; line++) {     //LetterHeightList.get(letter)+1; line++)
            .var font_ypos = ROWMODE == 1 ? LetterHeightList.get(42) - line : floor(42*2/40)*$18 + LetterHeightList.get(42) - line 
            .var font_xpos = ROWMODE == 1 ? 42*2 : mod(42*2, 40)
            .byte font.getSinglecolorByte(font_xpos,font_ypos)
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        //*= $8400
        .for (var letter=0; letter < letters_total; letter++) {
            *= $8400 + letter*letterheight_max "Font definitions, right side"
            .var maxidx = LetterHeightList.get(letter) + 1  //ROWMODE == 1 ? LetterHeightList.get(letter) + 1 : $18
            .for (var line=0; line < maxidx; line++) {
                .var font_ypos = ROWMODE == 1 ? LetterHeightList.get(letter) - line : floor(letter*2/40)*$18 + LetterHeightList.get(letter) - line 
                .var font_xpos = ROWMODE == 1 ? letter*2 + 1 : mod(letter*2 + 1, 40)
                .byte font.getSinglecolorByte(font_xpos,font_ypos)
            }
        }
        .align $10
        //.printnow "lastletter at " + *
        .for (var line=0; line < LetterHeightList.get(42) + 1; line++) {     //LetterHeightList.get(letter)+1; line++)
            .var font_ypos = ROWMODE == 1 ? LetterHeightList.get(42) - line : floor(42*2/40)*$18 + LetterHeightList.get(42) - line 
            .var font_xpos = ROWMODE == 1 ? 42*2 + 1: mod(42*2 + 1, 40)
            .byte font.getSinglecolorByte(font_xpos,font_ypos)
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        .const SCROLLTEXT_STRING00 = " the solution  "
        .const SCROLLTEXT_STRING01 = " salutes the scene  "
        .const SCROLLTEXT_STRING02 = " at zoo 2021     "
        
        .const SCROLLTEXT_STRING1 = "      sharpening our weapons we did hide for a while, and still do so basically..."
        .const SCROLLTEXT_STRING2 = "just to remind you that we did not leave the battlegrounds yet, well, we probably never will, we give you this little beauty you are currently staring at."
        .const SCROLLTEXT_STRING3 = "the two pictures in this small production were heartfully pixelled by jasky and c2b, you are free to take a guess who did which one!"
        .const SCROLLTEXT_STRING4 = @"as you might have noticed, the pictures are not plain hires! they were done in a new graphics mode i decided to call \"quarter char hires\" or just 'qch'."
        .const SCROLLTEXT_STRING5 = "the mode offers the usual 320 x 200 hires pixels but gives you 2 colours for each 8x2 tile, thus the name of the mode tells it all!"
        .const SCROLLTEXT_STRING6 = "thanks to dam we were able to present the pictures with a wonderful audial pleasure underneath, and thanks to cupid we have this decorative font onboard."
        .const SCROLLTEXT_STRING7 = "our respect goes to the humble combatants that fight with us for the eternity of the c64 scene..."
        .const SCROLLTEXT_STRING8 = "we are very honoured that c2b decided to join our party as a new member! we are the solution..."
        .const SCROLLTEXT_STRING9 = "members of the solution are christwoballs, copyfault, cupid, dam, groepaz, jasky, jazzvibee, jihad, lux, nerdine, shine, silpheed, snake petsken, topshelf, xiny6581."
        .const SCROLLTEXT_STRING10 = "mode and this tiny demo coded by copyfault. scroller is going to wrap soon, so we let the pictures speak for themselves for a moment. see you in the next release!"
        .const SCROLLTEXT_STRING11 = "                       "
        .const SCROLLTEXT_STRING12 = "                       "
        .const SCROLLTEXT_STRING13 = "                       "
        .const SCROLLTEXT_STRING14 = "                       "
        .const SCROLLTEXT_STRING15 = "                  'sunsadness' by jasky             "
        .const SCROLLTEXT_STRING16 = "                  'aflea' by christwoballs          "
        .const SCROLLTEXT_LIST = List().add( SCROLLTEXT_STRING1,  SCROLLTEXT_STRING2,  SCROLLTEXT_STRING3,  SCROLLTEXT_STRING4)
        .eval SCROLLTEXT_LIST.add(           SCROLLTEXT_STRING5,  SCROLLTEXT_STRING6,  SCROLLTEXT_STRING7,  SCROLLTEXT_STRING8)
        .eval SCROLLTEXT_LIST.add(           SCROLLTEXT_STRING9,  SCROLLTEXT_STRING10, SCROLLTEXT_STRING11, SCROLLTEXT_STRING12)
        .eval SCROLLTEXT_LIST.add(          SCROLLTEXT_STRING13,  SCROLLTEXT_STRING14, SCROLLTEXT_STRING15, SCROLLTEXT_STRING16)
        //.printnow "letter 0 = " + SCROLLTEXT_LIST.get(0).charAt(0)
        .const SCROLLTEXT_INTRO_LIST = List().add(SCROLLTEXT_STRING00, SCROLLTEXT_STRING01, SCROLLTEXT_STRING02)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $2800 "Scrolltext"
scrolltext:
        .for (var scrollnum = 0; scrollnum < SCROLLTEXT_LIST.size(); scrollnum++) {
            .for (var idx = 0; idx < SCROLLTEXT_LIST.get(scrollnum).size(); idx++) {
                .byte FindLetter(SCROLLTEXT_LIST.get(scrollnum).charAt(idx))*3
            }
            .byte $e8
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        .align $0100
        .var catch_page = *
        *= catch_page + ($100 - $40)
intro_text_adr:
        .for (var scrollnum = 0; scrollnum < SCROLLTEXT_INTRO_LIST.size(); scrollnum++) {
            .for (var idx = 0; idx < SCROLLTEXT_INTRO_LIST.get(scrollnum).size(); idx++) {
                .byte FindLetter(SCROLLTEXT_INTRO_LIST.get(scrollnum).charAt(idx))*3
            }
            .if (scrollnum == 1) .byte $fd
            .byte $ff
        }
        .byte $fe
        .byte $e8
        .byte $00, $00, $00, $00
        .byte $00, $00
//-------------------------------------------------------------------------------------------------------------------------------------
        .var scrolltextend_ADR = *-1
        //.printnow "scrolltext ends at " + scrolltextend_ADR
scroll_inc_tab:
        .var scrolltext_pages = (>scrolltextend_ADR) + 1 - (>scrolltext)
        //.printnow scrolltext_pages
        .for (var ofs = 0; ofs < scrolltext_pages - 1 ; ofs++) {
            .byte (>scrolltext) + mod(ofs + 1, scrolltext_pages - 1)  //>scrolltext
        }
        .byte (>scrolltext)
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $b000
        .fill 1000, QCHVRamAll.get(0).get(i)
        *= $b400
        .fill 1000, QCHVRamAll.get(1).get(i)
        *= $b800
        .fill 1000, QCHVRamAll.get(2).get(i)
        *= $bc00
        .fill 1000, QCHVRamAll.get(3).get(i)
//-------------------------------------------------------------------------------------------------------------------------------------
//------- 2nd framw ------        
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $c000 "VRAM 0 (2nd Frame)"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==1) {
                .eval shadowAdress_List.add(*)
                .fill $28, $bb
            } else {
                .fill $28, QCHVRamAll1.get(0).get($28*charline + i)
            }
        }
        *= $c3ff
        .byte $40   //$ff
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $c400 "VRAM 1 (2nd Frame)"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==1) {
                .eval shadowAdress_List.add(*)
                .fill $28, $bb
            } else {
                .fill $28, QCHVRamAll1.get(1).get($28*charline + i)
            }
        }
        *= $c7ff
        .byte $40   //$ff
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $c800 "VRAM 2 (2nd Frame)"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==1) {
                .eval shadowAdress_List.add(*)
                .fill $28, $bb
            } else {
                .fill $28, QCHVRamAll1.get(2).get($28*charline + i)
            }
        }
        *= $cbff
        .byte $40   //$ff
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $cc00 "VRAM 3 (2nd Frame)"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==1) {
                .eval shadowAdress_List.add(*)
                .fill $28, $bb
            } else {
                .fill $28, QCHVRamAll1.get(3).get($28*charline + i)
            }
        }
        *= $cfff
        .byte $41   //$ff
//-------------------------------------------------------------------------------------------------------------------------------------
        .for (var gfxline=0; gfxline<200; gfxline++) {
            .var charline = floor(gfxline/8)
            .var sprseg = floor(gfxline/16)
            .var sprbase = mod(sprseg, 2)==0 ? $d080 : $5080
            .var sprline = mod(gfxline, 21)
            .var sprbytetmp
            .for (var charcolumn=0; charcolumn<3; charcolumn++) {
                *= sprbase + (sprseg*3 + charcolumn)*$40 + sprline*$3 "Sprite Pattern DEfinitions for FLI Bug Pixels (2nd Frame)"
                .if (mod(gfxline, 8)<2) {
                    .byte $00, $00, $00
                } else {
                    .eval sprbytetmp = charcolumn==0 ? QCHBitmap1.get($140*charline + $00 + mod(gfxline, 8)) : $00
                    .byte sprbytetmp
                    .eval sprbytetmp = charcolumn==1 ? QCHBitmap1.get($140*charline + $08 + mod(gfxline, 8)) : $00
                    .byte sprbytetmp
                    .eval sprbytetmp = charcolumn==2 ? QCHBitmap1.get($140*charline + $10 + mod(gfxline, 8)) : $00
                    .byte sprbytetmp
                }
            }
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $e000 "Bitmap (2nd Frame)"
        .for (var charline=0; charline<25; charline++) {
            .var segment = mod(charline, 4)<2 ? 0 : 1
            .if (segment==1) {
                .for (var char=0; char<3; char++) {
                    .fill 2, QCHBitmap.get($140*charline + $8*char + i)
                    .fill 6, $00
                }
                .for (var char=3; char<40; char++) {
                    .if (char > 12 && char < 13+16 && charline > 4 && charline < 16) {
                        .fill 8, $f0
                     } else {
                        .fill 8, QCHBitmap.get($140*charline + $8*char + i)
                     }
                }
            } else {
                .for (var char=0; char<3; char++) {
                    .fill 2, QCHBitmap1.get($140*charline + $8*char + i)
                    .fill 6, $00
                }
                .for (var char=3; char<40; char++) {
                    .fill 8, QCHBitmap1.get($140*charline + $8*char + i)
                }            
            }
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $d000 "MC Sprite Definition (2nd Frame)"
        .for (var sprline=0; sprline<21; sprline++) {
                .byte $55, $ff, $aa
        }
//-------------------------------------------------------------------------------------------------------------------------------------
        *= $d040 "Empty Sprite Definition (2nd Frame)"
        .fill $40, $00
//-------------------------------------------------------------------------------------------------------------------------------------
//      !eof