;"Hole #23 enigma"
;ZX Spectrum 48K, tiny 256b intro
;code - .ded^RMDA
;24.06.2022, Samara, Russia

;---[Some tech info]--------------------------------------------
; 9895 bytes of uncompressed Z80 code and data
; 9312 bytes of generated routines
;31488 bytes of pRNG data, 3936 x 64 px. sprite, 5.125 screens
;~78 second of scroll until sprite loop
;~60450 T per frame @ 50fps
;~14.25 T per refresh of one screen byte
;200b of crunched ZX2 data (up to 4 bytes can be saved)
; 56b of ZX2 depacker with initialization

;---[How to build]----------------------------------------------
;in Pasmo https://pasmo.speccy.org
;pasmo.exe --bin hole23.asm hole23.bin
;pasmo.exe --tapbas --name enigma hole23.asm hole23.tap

;in SjASMplus https://github.com/z00m128/sjasmplus
;sjasmplus.exe hole23.asm

;---[How to link into 256b]-------------------------------------
;1) Build binary file, crunch it with ZX2.EXE -x -z
;2) Take original ZX2 "dzx2_nano.asm" depacker
;3) Optimize it to -x -z
;4) Remove first 3 opcodes (ld b,$ff:push bc:ld a,$80)
;5) Use this ORG and preambular:
;	org	#80C7
;	ld	hl,#80ff
;	ld	de,#d861
;	push	de
;	ld	b,l
;	push	bc
;	ld	a,h
; 6) Link preambular + modified depacker + binary
; 7) You got executable 256b output!

;---[How to test it without ZX2]--------------------------------
;Comment original ORG and remove ";" from two lines with "!!"

;.ded

	DEVICE	ZXSPECTRUM48

	org	#d861
;!!	org	#d861-11
begin:
;!!	ld a,#80: ld bc,#ff00: ld de,#ff08: ld	hl,#81c7

table:	EQU	gento		;10 bytes of SEED data for pRNG
;Z80 registers state after ZX2
;a=80 bc=ff00 de=ff08 hl=81c7 sp=not set

	di
	ld	h,#d7		;last segment for pRNG data
rndloop:
	exx
;---------------------------------------------------------------
;Fast quality CMWC random number generator by Patrik Rak 
;https://gist.github.com/raxoft/2275716fea577b48f7f0
	ld   hl,table		;table must be inside segment!
        ld   a,(hl) ; i = ( i & 7 ) + 1

        and  7
        inc  a
	out	(#fe),a		;border FX
        ld   (hl),a

        inc  l      ; hl = &cy

        ld   d,h    ; de = &q[i]
        add  a,l
        ld   e,a

        ld   a,(de) ; y = q[i]

        ld   b,a
        ld   c,a
        ld   a,(hl) ; ba = 256 * y + cy

        sub  c      ; ba = 255 * y + cy
        jr   nc,$+3
        dec  b

        sub  c      ; ba = 254 * y + cy
        jr   nc,$+3
        dec  b

        sub  c      ; ba = 253 * y + cy
        jr   nc,$+3
        dec  b

        ld   (hl),b ; cy = ba >> 8, x = ba & 255
        cpl         ; x = (b-1) - x = -x - 1 = ~x + 1 - 1 = ~x
        ld   (de),a ; q[i] = x
;-------end of pRNG generator-----------------------------------
	ld	bc,#7ffe	;BC will be used later for SPACE
	exx
	ld	(hl),a
	ld	a,h
	cp	b
	dec	hl
	jr	nz,rndloop
;a=ff bc=ff00 de=ff08 hl=fffe
;-------all pRNG data generated, lets start---------------------
	ld	h,#5b
cls:	ld	(hl),%01000101	;color of scrolling noise area
	dec	hl
	bit 	3,h
	jr	nz,cls
clspix:	res	3,h
	ld	(hl),b
	dec	hl
	cp	h
	jr	nz,clspix-1	;this -1 give us "free" LD SP,HL
;a=ff bc=ff00 de=ff08 hl=ffff sp=0000
;--------RL+PUSH code generator---------------------------------
;ld a,(hl)
;inc hl
;dec ixh
;rla
;....
;rl (ix+x),d	;23T
;rl (ix+x),e	;23T
;push de	;11T    =57T per 4 bytes, 14,25T per byte
;....
;LOOP
	ld	hl,gento	;where to generate Z80 code

	rra			;A=#7F, initial state for IX+X

	ld	d,e             ;D=8, number of segments 32x8
gen1:	
 	ld	b,e             ;B=8, number of lines in segment
;---------------------------------------------------------------
	ld	(hl),#7E        ;LD A,(HL)	;7T
	inc	hl
	ld	(hl),#23	;INC HL		;6T
	inc	hl	
;---------------------------------------------------------------
	ld	(hl),#DD
	inc	hl
	ld	(hl),#25	;DEC IXH	;8T
	inc	hl
;-------one pixel line------------------------------------------
gen2:	ld	c,#10		;32 byte per line / 2
;-------4T bit extractor----------------------------------------
	ld	(hl),#17        ;RLA		;4T
	inc	hl		
;-------two bytes RL--------------------------------------------
gen3:	ld	(hl),#DD
	inc	hl
	ld	(hl),#CB
	inc	hl
	ld	(hl),a          ;+X
	dec	a
	inc	hl
	ld	(hl),#12	;RL (IX+N),D	;23T

	inc	hl

	ld	(hl),#DD
	inc	hl
	ld	(hl),#CB
	inc	hl
	ld	(hl),a          ;+X
	dec	a
	inc	hl
	ld	(hl),#13	;RL (IX+N),E	;23T 

	inc	hl
;-------two bytes PUSH------------------------------------------
	ld	(hl),#d5	;PUSH DE	;11T
	inc	hl
	dec	c
	jr	nz,gen3
;-------end of 1 line-------------------------------------------
	djnz	gen2
;---------------------------------------------------------------
	dec	d
	jr	nz,gen1
;a=7f bc=0000 de=0008 hl=fddd sp=0000
;-------end of code generation----------------------------------

;-------FX loop init--------------------------------------------
	ld	h,a		;first yellow section is shorter
	ld	iy,fxloop	;set IM handler jump back addr
	ld	b,%00110110	;set color of hole background
;-------IM2 init------------------------------------------------
	add	a,a		;set I=#FE and enable IM2
	ld	i,a
	im	2
;hl=7fdd
;-------main FX loop--------------------------------------------

fxloop:	ld	c,b		;duplicate hole background color

	ld	sp,#5a00
	push	bc,bc,bc,bc,bc,de,de,de,de,de,de,bc,bc,bc,bc,bc
	push	bc,bc,bc,bc,de,de,de,de,de,de,de,de,bc,bc,bc,bc
	push	bc,bc,bc,de,de,de,de,de,de,de,de,de,de,bc,bc,bc
destr:	push	bc,bc,de,de,de,de,de,de,de,de,de,de,de,de,bc,bc
	push	bc,bc,de,de,de,de,de,de,de,de,de,de,de,de,bc,bc
	push	bc,bc,bc,de,de,de,de,de,de,de,de,de,de,bc,bc,bc
	push	bc,bc,bc,bc,de,de,de,de,de,de,de,de,bc,bc,bc,bc
	push	bc,bc,bc,bc,bc,de,de,de,de,de,de,bc,bc,bc,bc,bc

	ld	a,d            ;swap hole color for up & down
	ld	d,e
	ld	e,a

	ld	sp,#58f3
	push	de,de,de
	ld	sp,#5a13
	push	de,de,de
;---------------------------------------------------------------
	ld	ix,#4880  ;middle of last 256 byte segment to RL
	ld	sp,#5800  ;end of area to PUSH
;---------------------------------------------------------------
gento:
	DUP	9312
	defb	#58	  ;fill byte for better ZX2 compression
	EDUP
;a=current pRNG byte
;bc=#2d2d solid color
;de=current pRNG data
;hl=current adress of pRNG data
;---------------------------------------------------------------
	and	%00010000	;beeper noise
	xor	c               ;border color
	out	(#fe),a
;-------keyboard check------------------------------------------
	exx
;bc=#7ffe
enigma:	in	a,(c)
	rrca
	jr	nc,enigma	;SPACE to solve enigma
	exx
;-------HL check------------------------------------------------
	ld	a,h
	cp	#d7
	jr	c,exit

	ld	a,b
	sub	9
	jr	nc,scol
	ld	a,%00111111

scol:	ld	b,a
	ld	h,#5c
;-------end of frame--------------------------------------------
exit:	ei
	halt
;pc=#fdfd
;-------IM2 handler---------------------------------------------
	org	#fdfd
	jp	(iy)		;"jp fxloop" save 3 bytes,slower
;-------IM2 table-----------
	DUP	#101+8		;+8 provide us E=#08 after ZX2
	defb	#fd		;IM2 table area #FE00-FF00 = #FD
	EDUP
;---------------------------------------------------------------
finish:	
	SAVESNA	"hole23.sna", begin
	SAVEBIN	"hole23.bin", begin, finish-begin
;	EMPTYTRD "hole23.trd","Hole #23"
;	SAVETRD	"hole23.trd","enigma2.C",begin,finish-begin
;	EMPTYTAP "hole23.tap"
;	SAVETAP "hole23.tap",CODE,"enigma2",begin,finish-begin

;-------=RMDA=---------------------------------------------[eof]