:BasicUpstart2(program)

.print "path:"+getPath()
.print "filename: "+getFilename()


/*

					====================================================
							TRISDOS/Ikari 1988 Crackintro Homage
							https://csdb.dk/release/?id=53347
							Reloaded intro by Dr.j/Delysid ASOA 2020
					====================================================



*/
.var ldaSize=asmCommandSize(LDA_IMM)
.var ldxSize=asmCommandSize(LDX_IMM)
.print "ldasize="+ldaSize
.label cpu_io_port=$01 
.var q1=$04   
.var q2=$06 
.var q3=$08
.var global_func_index=$03 //resereved to $04
.label border_color = $d020
.label background_color = $d021

.label processor_port = $01
.label screen_memory = $0400
.label color_memory = $d800
.label cia1_interrupt_control_register = $dc0d
.label cia2_interrupt_control_register = $dd0d
.label vic2_interrupt_control_register = $d01a
.label vic2_interrupt_status_register = $d019
.label vic2_rasterline_register = $d012
.label screen_control_register = $d011
.var ikari_charObj=LoadBinary ("../gfx/ikari_charset.bin")
.var ikari_scroller_obj=LoadBinary ("../gfx/1_1_scroller.bin")
.label default_charset=$1400
.label ikari_charset=$2000
.const VIC2 = $d000
.label vic2_screen_control_register1 = $d011
.label vic2_screen_control_register2 = $d016
.label vic2_control_memory_register= $d018
.label character_color1 = $d022
.label character_color2 = $d023
.label character_color3 = $d024
.var RTS_ARGUMENT=CmdArgument(AT_IMMEDIATE,RTS)
.var NOP_ARGUMENT=CmdArgument(AT_IMMEDIATE,NOP)
.label next_intro=$3800
.label spr_loc=$0c00 
.var debug=false 
.namespace sprites {
 .label positions = VIC2
  .label position_x_high_bits = VIC2 + 16
  .label enable_bits = VIC2 + 21
  .label colors = VIC2 + 39
  .label vertical_stretch_bits = VIC2 + 23 
  .label horizontal_stretch_bits = VIC2 + 29
  .label pointers = screen_memory  + 1024 - 8

  .label multicolor_bits = VIC2 + 28
  .label color1 = VIC2 + 37
  .label color2 = VIC2 + 38
  .label priority_bits = VIC2 + 27
.print "namespace="+getNamespace()

}
.enum {color0=0,color1=64,color2=128,color3=192}
.const KOALA_TEMPLATE = "C64FILE, Bitmap=$0000, ScreenRam=$1f40, ColorRam=$2328,BackgroundColor = $2710"
.var music=LoadSid("../music/Ikari_Intro_Song.sid")
.var ikari_screen_obj=LoadBinary("../gfx/ikari_screen.bin")
.var logo_screen_obj=LoadBinary("../gfx/delysid.iscr")
.var logo_char_obj=LoadBinary("../gfx/delysid.imap")
//.watch vic2_rasterline_register // Watches $d012
.var colorCycleList= List()
.eval colorCycleList.add(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)
.eval colorCycleList.lock()
.enum {tlchar=85,trchar=73,blchar=74,brchar=75,horchar=64,verchar=66}
.enum {tlchar_index=35,trchar_index=36,blchar_index=37,brchar_index=38,horchar_index=39,verchar_index=40}
.label ikari_scroller_mem=$2800 
.label spr_loction=$0a00 
.const ypos=$c8 
.var title_name="delysid are hungry for c64 at asoa 2022"
.var logo_color=LoadBinary("../gfx/delysid.col")	
*=$3000 "program"

program:




											//do ensure vic2_rasterline_register=$0
											bit vic2_screen_control_register1
											bpl *-3
											bit vic2_screen_control_register1
											bmi *-3

											

											.print "val=$"+toHexString(irq0>>8 & %11111111)				
											
											:fill_screen(' ')


											sei
											lda processor_port
											and #%11111101
											sta processor_port

											ldx #0
											ldy #0
											lda #music.startSong-1
											jsr music.init 
											lda #%01111111
											sta cia1_interrupt_control_register
											sta cia2_interrupt_control_register
											bit cia1_interrupt_control_register
											bit cia2_interrupt_control_register
											lda #1
											sta vic2_interrupt_control_register
											asl vic2_interrupt_status_register
											lda #toD018(screen_memory,ikari_charset)
											sta vic2_control_memory_register
											:set_raster(50)
											:mov16 #irq0 : $fffe 

											:border(BLACK)
											:background(BLACK)

											
											
											:mov16 #my_scroll : q2 
											:mov16 #sprite_scoller : q3

											cli

											//paint the IKARI logo 
											
											ldx #0
										!:	lda logo_color_mem,X 
											sta color_memory,X 
											lda logo_color_mem+$90,X 
											sta color_memory+$90,X 
											inx 
											bne !-
																					


											//settings for ikari logo 
											lda #BLUE 
											sta character_color1
											lda #LIGHT_BLUE
											sta character_color2

											//copy ikari logo 
											ldx #0
									!:		lda ikari_logo_screen,X 
											sta screen_memory,X 
											lda ikari_logo_screen+$90,X 
											sta screen_memory+$90,X 
											inx 
											bne !-

											//clear scroller
											lda #0
											tax 
									!:		sta color_memory+15*40,X 
											sta color_memory+23*40,X 
											inx 
											cpx #40
											bne !-
											:print_at(23,[40-title_name.size()]/2,title_name,color0)

											//init sprites 

											lda #%11111111
											sta sprites.enable_bits
											
											lda #%00000000
											sta sprites.multicolor_bits

											//lda #%00000000
											//sta sprites.priority_bits
											
											
											:mov16 #my_scroll : q2 
											:mov16 #sprite_scoller : q3

											

											//set for the color effect 
											ldx #39
									!:		
											lda #$df 
											sta screen_memory+13*40,x 
											lda #$de 
											sta screen_memory+17*40,x 
											lda #$dd 
											sta screen_memory+14*40,x
											lda #$dc
											sta screen_memory+16*40,x 
											dex 
											bpl !-

											//setup sprites position
											lda #%11111111
											sta sprites.horizontal_stretch_bits
											lda #%00000000
											sta sprites.vertical_stretch_bits
											
											
											.for (var i=0;i<8;i++) {
											 lda #[spr_loction&$3fff]/64+i 
											 sta sprites.pointers+i 

											 :set_sprite_location(i,15+(24*2*i),ypos)

											}
												
											lda #BLACK 
											.for (var i=0;i<8;i++) {
												sta sprites.colors+i 
											}

											lda #$ff 
											ldx #0
										!:	
											sta spr_loction,X 
											sta spr_loction+$100,X 
											inx 
											bne !-
											lda #0
											sta $12 
											sta $13
											sta $14


								!loop:
											
											lda _end_of_intro: #0
											cmp #1
											bne !loop- 			
											jmp end_of_intro 

.var scroller_raster=168
.const scroller_raster1=201
.align 256
logo_color_mem:
.fill logo_color.getSize(),logo_color.get(i)


						*=* "irq0"
							irq0:			
											sta saveRegs+1
											stx saveRegs+3
											sty saveRegs+5 
											:mov #%00011010 : vic2_screen_control_register1
											:mov #%00011000 : vic2_screen_control_register2
											
											lda #toD018(screen_memory,ikari_charset)
											sta vic2_control_memory_register
											//44 61
											:wait_raster(44) //45
											:cycles(36) //30
											
											
											ldx #0	
											ldy #5	
											jmp cont 
									!:		ldy #7	
											inx 	
								cont:		lda $1d00,x	
											sta $d021	  
											sta $d020	  
											dey 	
											bmi !-	
							.label	change_d016=*+1
											lda my_d016,x	
											sta $d016	    
											
											:cycles(12*2+4+4)	
											
											inx 	
											cpx #104
											bne cont 

											:background(BLACK)
											:border(BLACK)
											
											dec change_d016
											lda change_d016
											cmp #$ff 
											bne !+
											lda #$95 
											sta change_d016
									!:		

											
											:set_raster(scroller_raster-16)
											:mov16 #irq1 : $fffe 
											jmp exitIRQ	

							irq1:			sta saveRegs+1
											stx saveRegs+3
											sty saveRegs+5 	
											lda #toD018(screen_memory,ikari_scroller_mem)
											sta vic2_control_memory_register
											:set_raster(scroller_raster-3)
											:mov16 #irq2 : $fffe 
											jmp exitIRQ				
.var counter=0			
.var counter1=0
.var counter2=0
rasters:
.byte 6,$e0,3
.fill 7,1
.byte 7,$0a,2
.fill 3,0
end_of_rasters:

							irq2:			sta saveRegs+1
											stx saveRegs+3
											sty saveRegs+5 
											
											:stabilize_irq()
											lda offset: #%11000111 
											sta vic2_screen_control_register2
											//lda #toD018(screen_memory,ikari_scroller_mem)
											//sta vic2_control_memory_register

											:cycles($38-3-6)
											
											.for (var rasterline=scroller_raster;rasterline<scroller_raster+[end_of_rasters-rasters];rasterline++) {
											.var cycle_count=63	
												ldx #counter
												lda rasters,X 
												sta border_color
												sta background_color
												.eval counter++
											.if (is_next_line_bad(rasterline))	{
												.eval cycle_count-=43
											}
											.eval cycle_count-=14	
											:cycles(cycle_count) 	
											cycle_63:	
											}

											lda #195
											cmp vic2_rasterline_register
											bne *-3
											
											lda #WHITE
											sta background_color
											sta border_color
											ldx #$0a
											dex 
											bne *-1
											lda #BLACK 
											sta background_color
											sta border_color



											:wait_raster(199)
											:cycles(45)
											
											.for (var rasterline=scroller_raster1;rasterline<scroller_raster1+15;rasterline++) {
											.var cycle_count=63	
												ldx #counter1
												lda rasters1,X 
												sta background_color
												sta background_color
												.eval counter1++
											.if (is_next_line_bad(rasterline))	{
												.eval cycle_count-=43
											}
											.eval cycle_count-=14	
											:cycles(cycle_count) 	
											cycle_63:	
											}
											
											
											:wait_raster(222)
											:cycles(43)
											//we need to start the line 
											//.break 	
											lda #WHITE										
											sta background_color
											sta border_color
											ldx #10
											dex 
											bne *-1
											lda #BLACK 
											sta background_color
											sta border_color
											ldx #$0a 
											dex 
											bne *-1
											lda #BLACK 
											lda #%11001000
											sta vic2_screen_control_register2

											:wait_raster(232) //$e9
														//233 34
											
											ldx #8
											dex 
											bne *-1
											
											.for (var rasterline=233;rasterline<233+14;rasterline++) {
											.var cycle_count=63	
												ldx #counter2
												lda rasters2,X 
												sta background_color
												sta border_color
												.eval counter2++
											.if (is_next_line_bad(rasterline))	{
												.eval cycle_count-=43
											}
											.eval cycle_count-=14	
											:cycles(cycle_count) 	
											cycle_63:	
											}
											
											

											jsr funcs  
											:set_raster(40)
											:mov16 #irq0 : $fffe 

											jmp exitIRQ											

.align 256
rasters1:
.byte 0
.byte 2,2,9,9,8,8,7,7,1,1,3,3,0,0,0
.byte 0
.align 64
rasters2:
.byte 9,8,7
.fill 7,1
.byte $f,$c,$b,0

.byte 
dummy:{
	rts 
}																		

.align 256
paninaro_index: 
.import binary "1900_index.bin"


.align $100
*=* "my d016"
my_d016:
.import binary "paninaro_d016.bin"

move_scrolling_sprites:{

		ldx #14
	!:	dec sprites.positions,X 
		dec sprites.positions,X 
		dex 
		dex 
		bpl !-
		lda sprites.positions+2 
		cmp #15
		beq switch_pointers
		cmp #57
		bmi cont_1 
		jmp fetch_new_char_scroller 

cont_1:
			lda sprites.positions
			bmi cont_2 
exit:					
			rts 
cont_2:	
			lda #15 
			sta sprites.positions
			ldy #0
			sty $12 		
			

			lda sprites.pointers
			lsr 
			ror $12
			lsr 
			ror $12
			clc 
			adc #0
			sta $13  
			iny 
			//pointer  of the first sprites
	!:		
			lda ($12),Y 
			dey 
			sta ($12),Y 
			iny 
			iny 
			lda ($12),Y 
			dey 
			sta ($12),y
			iny 
			lda #0
			sta ($12),y 
			tya 
			clc 
			adc #5
			tay 
			cpy #49 
			bne !-
			
			jmp exit 

.align 16
*=* "init points"
my_init_points:
//.import binary "table0.bin"		
.fill 8,[15+24*2*i,ypos]

switch_pointers:
			
			ldx #15
		!:	
			lda my_init_points,X 
			sta sprites.positions,X 
			dex 
			bpl !-
			ldy sprites.pointers
			ldx #0
		!:	
			lda sprites.pointers+1,X 
			sta sprites.pointers,X 
			
			inx 
			cpx #8
			bne !-
			sty sprites.pointers+7 

			lda #0
			sta fetch_to_sprite
			tya 
			lsr 
			ror fetch_to_sprite
			lsr 
			ror fetch_to_sprite
			clc 
			adc #0
			sta fetch_to_sprite+1 
			lda #0
			sta $14 
			jmp exit 
fetch_new_char_scroller:
			lda $01 
			sta tmp 
			lda #$36 //to read chars from rom 
			sta $01 
			lda #>ikari_scroller_mem
			sta $13
			//get the current char 
			//.break 
			ldy #0
			lda (q3),Y 
			cmp #64
			bmi !+

			and #%00111111 

	!:		:asl #3 
			sta $12 
			lda $13
			adc #0
			sta $13
						 

			ldx $14
			//copy letter to last sprite 
	!:	
			lda ($12),Y 
			eor #$ff 
.label fetch_to_sprite=*+1		

			sta $0a40,X 

			txa 
			clc 
			adc #6  //every second line 
			tax 
			iny 
			cpy #8
			bne !-
			inc q3 
			bne *+4
			inc q3+1 
			ldy #0
			lda (q3),Y 
			cmp #$ff 
			bne !+ 
			:mov16 #sprite_scoller : q3 
	!:		inc $14 
			lda #$35 
			sta $01
			
			jmp exit 

tmp: .byte 0
}







check_space:{
		
		ldx #$ff          //;  ;port dc00 = outputs
		stx $dc02
		inx          //;       ;port dc01 = inputs
		stx $dc03
		lda #%01111111
		sta $dc00 
		lda $dc01
		and #%00010000
		bne !+
				
		lda #1
		sta _end_of_intro
	!:  rts 	

}
my_scroll:
.fill 4,$1c 
.fill 4,' '
.text "tridos did it on 1988...we did it 34 years later on asoa 2022 party!! source of the reloaded intro will come along the download files  so you can make your research for this golden legendary intro as you wish....."
.fill 4,' '
.byte $ff 

.align 64
sprite_scoller:
.fill 4,' '
.text "greetings to all our friends and all the people who are salute the c64 demo scene        "
.byte $ff  


scroller:{
.label @scroller_pos=screen_memory+15*40
				//lda offset 
				
				dec offset 
				dec offset 
				lda offset 
				cmp #%11000000
				bcs end 
				clc 
				adc #8
				sta offset

				ldx #0
		!:		lda scroller_pos+1,X 
				sta scroller_pos,X 
				inx 
				cpx #39
				bne !-
				
				ldy #0 
		!:		lda (q2),Y 
				cmp #$ff 
				bne !+
				:mov16 #my_scroll: q2 
				clc 
				bcc !-

		!:		and #%00111111
				sta scroller_pos+39
				inc q2
				bne *+4
				inc q2+1 
		
		end: 	rts 		


}


color_cycle:{
				
				 ldx val: #0
				 ldy #0 
			!:	 cpx #0
				 bpl !+ //delay 
				 inx 
				 iny 
				 cpy #16
				 bne !-
			!:	 lda colorRam,Y 
				 sta color_memory+13*40,X 
				 sta color_memory+16*40,X 
				 stx tmp 
				 lda #39 
				 sec 
				 sbc tmp  
				 tax 
				 lda colorRam1,Y 
				 sta color_memory+14*40,X 	
				 sta color_memory+17*40,X 
				 ldx tmp 
				 cpx #39
				 beq !+
				 inx 
				 iny 
				 cpy #16
				 bne !-
			!:	 inc val 
				 lda val 
				 cmp #40
				 bne !+
				 lda #241 //for timers 
				 sta val 
			!:   rts 
tmp: .byte 0
colorRam: .byte 0,6,0,6,$e,6,$e,$e,3,$e,3,3,1,3,1,1
colorRam1: .byte 0,$b,0,$b,$c,$b,$c,$c,$f,$c,$f,$f,1,$f,1,1

}

funcs:{
	jsr check_space	
	jsr scroller 
	
	jsr color_cycle
	jsr move_scrolling_sprites 
	jsr make_rasters
	jsr check_space
	jmp music.play	
	rts 
}											

exitIRQ:
asl vic2_interrupt_status_register
saveRegs:
	lda #0
	ldx #0
	ldy #0
	rti 


.align 256
ikari_logo_screen:
//.fill  ikari_screen_obj.getSize(),ikari_screen_obj.get(i)
.fill logo_screen_obj.getSize(),logo_screen_obj.get(i)

*=* "end of intro"				
end_of_intro: {

.var @next_part_start_address= 2061
.var @start_of_screen=$0340

        
      sei 
      lda #$37
      sta $01
      
        
      jsr $fda3
      jsr $e518
      jsr $fd15     
      
      lda #$16
      sta $d018 

      lda #BLACK
      sta $d020
      sta $d021     
      
     
      ldx #0
!:    lda msg,x
      //and #%00111111
      sta screen_memory,x
      lda #WHITE
      sta color_memory,x
      inx
      cpx #[msg_end-msg]
      bne !-
      
     	
        
      ldx #0
!:    lda mylink_zone,x        
      sta start_of_screen,x
      inx
      cpx #[p3-p1]
      bne !-
                  
      jmp start_of_the_intro_at_real_location  
.align 64      
msg: .text "Code by Tridos/Ikari/Paninaro           "
	 .text "Reloaded code by Dr.j                   "
	 .text "Delysid logo  by Mythus                 "
   	 .text "Tune by Laxity                          "
msg_end: 
     
 }     


*=* "my link zone" 
mylink_zone:                  
.pseudopc start_of_screen {      
p1:
.text "code by alex goldblat"
start_of_the_intro_at_real_location:
	    lda #$34 //;will be at  start_of_screen+$15
        sta $01
        ldx #$00
        .label source=*+1
!:      lda next_intro,x
		.label destination=*+1
        sta $0801,x
        inx
        bne !-
        inc source+1 
        inc destination+1
        bne !-
        lda #$8C  
        ldx #$AE  
        sta $2E 
        sta $AF 
        stx $2D 
        stx $AE 
        
        lda #$00  
        sta $0800
                
          
        sta $c6 
        sta $0286 
        sta $d020 
        sta $d021 
        sta $d015 
              
        lda #$2f
        sta $00 
        
        
        lda #$37
        sta $01
        cli
        
        jmp $fce2      //reset of C64
        
        //jmp next_part_start_address //;next_part_start_address
p3: .byte $00    
} 

topsprite_ns: :define_spr(LIGHT_GREEN,spr_loc,20,%00,0)
//years_ns: :define_spr(YELLOW,years_loc,10,%11,20)

//------------------------------------
// Assets extracted
//------------------------------------
*=music.location  "Ikari music"
.fill music.size,music.getData(i)
*=ikari_charset  "ikari logo charset"
//.fill ikari_charObj.getSize(),ikari_charObj.get(i)
.fill logo_char_obj.getSize(),logo_char_obj.get(i)
*=ikari_scroller_mem "ikari 1x1 charset"
.fill 240*8,ikari_scroller_obj.get(i)

*=$1d00 "paninaro rasters"
paninaro_rasters:
.import binary "../gfx/rast.bin"
//.fill data.getSize(), data.get(i)


*=$1e0f "reverse engine code"
make_rasters:{

	
	
branch65:	ldx myindex	
	lda paninaro_index,x	
	cmp #$ee	
	bne branch66	
	lda #$00	
	beq branch67	
	//jmp $0d00	
	
branch66:	cmp #$2e	
	bcc branch68	
branch67:	jmp branch72
branch68:	cmp #$1e	
	bcs branch69	
	ldx #$09	
!:	lda $1da0,x	
	sta $1d06,x	
	lda $1da4,x	
	sta $1d10,x	
	lda $1da8,x	
	sta $1d1a,x	
	lda $1dac,x	
	sta $1d24,x	
	lda $1da0,x	
	sta $1d58,y	
	lda $1da4,x	
	sta $1d4e,y	
	lda $1da8,x	
	sta $1d44,y	
	lda $1dac,x	
	sta $1d3a,y	
	iny	
	dex 	
	bpl !-	
	lda val: #$00	
	eor #1	
	sta val 
	bne branch70	
branch70:	ldy $1dbf	
	ldx #$1e	
!:	lda $1da0,x	
	sta $1da1,x	
	dex 	
	bpl !-
	sty $1da0	
branch69:	ldx #$0b	
!:	lda $1de0,x	
.label go3=*+1
	sta $1d3a,x	
	dex 	
	bpl !-	
	ldx #$0b	
!:	lda $1dd0,x	
.label go0=*+1
	sta $1d34,x	
	dex 	
	bpl !-	
	ldx #$0b	
!:	lda $1dc0,x	
	sta $1d2e,x	
	dex 	
	bpl !-	
	ldx #$0b	
!:	lda $1dd0,x	
.label go1=*+1
	sta $1d28,x	
	dex 	
	bpl !-	
	ldx #$0b	
!:	lda $1de0,x	
.label go4=*+1
	sta $1d22,x	
	dex 	
	bpl !-
	lda val1:#1	
	eor #$01	
	sta val1
	bne branch71	
	inc go0	
	dec go1	
branch71:	inc go3	
	dec go4
	lda go4 
	cmp #$16	
	bne branch72	
	lda #$16	
	sta go3 
	lda #$22	
	sta go0	
	lda #$3a	
	sta go1 	
	lda #$46	
	sta go4 
branch72:	ldx #$00	
	ldy #$00	
	lda #$00	
branch74:	cpx #$29	
	beq branch73	
	sta $1d00,x	
	inx 	
	bne branch74	
branch73:	lda $1d90,y	
	sta $1d00,x	
	inx 	
	iny	
	cpy #$06	
	bne branch73	
	ldy #$00	
	lda #$68	
	sec	
	sbc branch74+1	
	sbc #$06	
	tax	

branch75:	lda $1d90,y	
	sta $1d00,x	
	inx 	
	iny	
	cpy #$06	
	bne branch75	
	lda #$00	
branch77:	cpx #$69	
	beq branch76	
	sta $1d00,x	
	inx 	
	bne branch77	
.label myindex=*+1		
branch76:	ldx #$3a	
	lda paninaro_index,x	
	bpl !+	
	pha	
	and #$40	
	bne branch78	
	lda $1d91	
	sta $1d92	
	sta $1d93	
	lda $1d90	
	sta $1d91	
	sta $1d94	
	lda #$00	
	sta $1d90	
	sta $1d95	
	beq branch79	
branch78:	ldx #$00	
	lda $1d91	
	sta $1d90	
	sta $1d95	
	lda $1d92	
	sta $1d91	
	sta $1d94	
	lda $1d98,x	
	sta $1d92	
	sta $1d93	
	inc branch78+1	
	lda branch78+1
	cmp #$03	
	bne branch79	
	lda #$00	
	sta branch78+1	
branch79:	pla	
!:	and #$3f	
	sta branch74+1	
	inc myindex	
	lda myindex	
	cmp #$e0	
	bne !+	
	lda #$00	
	sta myindex	
!:	rts 

}

//------------------------------------
// Macros +  pseudocommand
//------------------------------------
.pseudocommand apply_sreen_offset  xoffset {
	//bit 3 for 38/40 row 
	lda vic2_screen_control_register2
	and #%11110000
	ora #%00001000 //mc
	ora  xoffset
	sta vic2_screen_control_register2
}

.macro location_at(loc,row,column){


}


.macro cycles(count){
	.if (mod(count,2)!=0) {
		.eval count-=3 
		bit $ea //3 
	}
	:nops(count/2)

}

.macro nops(count){
	.for (var i=0;i<count;i++) {
		nop ;
	}
}

.macro define_spr(_color,_location,initial_index,_maskbyte,init_point){
.label location=_location	
myzp: .byte 0,0
color: .byte _color
t0: .byte initial_index
maskbyte: .byte _maskbyte
initial_starting_point: .byte init_point
temp: .byte 0

}



.macro stabilize_irq() {
  start:
    :mov16 #irq2 : $fffe
    inc vic2_rasterline_register
    asl vic2_interrupt_status_register
    tsx
    cli

    inc $fb
    dec $fb
    :nops(4)

  irq2:
    txs
    ldx #1+7 // 2
  !loop: // (2+3) * 7
    dex  // 2
    bne !loop- // 2
    bit $ea
  test:
    lda vic2_rasterline_register
    cmp vic2_rasterline_register
    beq next_instruction
  next_instruction:
}

.macro move_spr(screen,counter,start_index,coord,ypos,hspace,isChange_Color){
//:move_spr(topsprite_ns,2,0,x_coordinates1,140,30,false)	
//:move_spr(years_ns,5,2,x_coordinates,160,18,true)	

		.for (var i=0;i<counter;i++) {
			lda #[screen.location&$3fff]/64+i 
			sta sprites.pointers+start_index+i 	
		}

		clc 
		:ror #start_index : screen.temp 
		
		lda #0
		sta screen.myzp+1
		ldx screen.t0
		lda coord,X 
		sta screen.myzp 
		clc 
		adc screen.initial_starting_point
		sta screen.myzp 


			clc 	
		.for (var i=0;i<counter;i++) {
			lda screen.myzp
			clc 
			adc #hspace
			sta screen.myzp
			sta sprites.positions+start_index*2+i*2 
			lda screen.myzp+1
			adc #0
			sta screen.myzp+1
			bne sprite_in_msb
			clc 
			jmp set_position_x_high_bit
sprite_in_msb:
			sec 
set_position_x_high_bit:
			:ror #1 : screen.temp 
		}
			clc 	
			:ror [8-counter-start_index] : screen.temp 

			lda sprites.position_x_high_bits
			and #255- screen.temp //flip the bits 
			ora screen.temp //add bits 
			sta sprites.position_x_high_bits
			inx
			stx screen.t0 
			//fetch the Ypos 
			lda #ypos
			.for (var i=0;i<counter;i++) {
				sta sprites.positions+start_index*2+2*i+1 
			}

}


.macro set_sprite_location(index,xpos,ypos){
	lda #xpos 
	sta sprites.positions+index*2
	lda #ypos 
	sta sprites.positions+index*2+1 
	lda sprites.position_x_high_bits
	.if (xpos>255) {
		ora #1 << index 
	} else {
		and #255- [1 << index]  //reset the accurate bit 
	}
	sta sprites.position_x_high_bits

}


.pseudocommand asl count : location {
	:ensureImmediatevalue(count)
	.for (var i=0;i<count.getValue();i++) {
		asl location 
	}
}

.pseudocommand lsr count : location {
	:ensureImmediatevalue(count)
	.for (var i=0;i<count.getValue();i++) {
		lsr location 
	}
}

.pseudocommand rol count : location {
	:ensureImmediatevalue(count)
	.for (var i=0;i<count.getValue();i++) {
		rol location 
	}
}


.pseudocommand ror count : location {
	:ensureImmediatevalue(count)
	.for (var i=0;i<count.getValue();i++) {
		ror location 
	}
}

.pseudocommand add16 a : b {
	:_add bits2byte(16) : a : b 
}


.pseudocommand add a : b {
	:_add bits2byte(8) : a : b 
}

.pseudocommand _add byte_id : arg1 : arg2 {
	clc 
	.for (var i=0;i<byte_id.getValue();i++) {
		lda extract_byte_argument(arg1,i)
		adc extract_byte_argument(arg2,i)
		sta extract_byte_argument(arg1,i)
	}
}


.pseudocommand mov16  a  : b {
	:_mov bits2byte(16) : a  : b 
}


.pseudocommand mov  a  : b {
	:_mov bits2byte(8) : a  : b 
}


.pseudocommand _mov byte_id : arg1 : arg2 {
	.for (var i=0;i<byte_id.getValue();i++) {
		lda extract_byte_argument(arg1,i)
		sta extract_byte_argument(arg2,i) 
	}
}

.function extract_byte_argument(arg,byte_id){
	.print "---------------------------------------"
	.print "arg="+toHexString(arg.getValue())
	
	.if (arg.getType()==AT_IMMEDIATE) {
		.print "pass on immediate = $"+toHexString(extract_byte(arg.getValue(),byte_id))
		.return CmdArgument(AT_IMMEDIATE, extract_byte(arg.getValue(),byte_id))
	} else {
		//AT_ABSOLUTE $1000
		.print "pass on absolute mode= $"+toHexString(arg.getValue()+byte_id)
		.return CmdArgument(arg.getType(),arg.getValue()+byte_id)
	}

	.print "---------------------------------------"
}

.function extract_byte(value,byte_id) {
	.var bits=byte2bits(byte_id)
	.eval value= value >> bits 
	.return value & %11111111
}

.macro fill_screen(char) {
	:fill_memory char : screen_memory : 1000 
}

.macro fill_color(color){
	:fill_memory color : color_memory : 1000 
}

.pseudocommand fill_memory value : location : iteration {
.var counter=iteration.getValue()/250 ;
		ldx #250  
		lda #value.getValue()
	!:		
		.for (var i=0;i<counter;i++) {
			sta location.getValue()+250*i-1,X 

		}
		dex 
		bne !-
}

.macro sprite_row(value) {
	.byte extract_byte(value,2) ,extract_byte(value,1) ,extract_byte(value,0)
}


.macro wait_raster(rasterline){
!wait:
		lda #rasterline
		cmp vic2_rasterline_register
		bne !wait-
		bit vic2_screen_control_register1
		.if (rasterline<=255)	{
			//we need the 7th bit to be clear so jump to !wait if it "on"
			bmi !wait-
		}
		else {
			//for >255 we need to enable 7 bit of vic2_screen_control_register1	so jump to !wait if its "off"
			bpl !wait- 
		}
}


.macro set_raster(rasterline){
	lda #rasterline
	sta vic2_rasterline_register

	lda vic2_screen_control_register1
	.if (rasterline>255) {
		ora #%10000000
		} else {
		and #%01111111	
		}
	sta vic2_screen_control_register1	

}

.macro print_at(row,column,string,offset) {
.label screen_at=screen_at(row,column)	

		:mov16 #screen_at-1 : q1


		.if (string.size()>1)  {
			jmp print_txt 	
		} else {
			.error "text is small than 1 char"
		}
		
		
str: .fill string.size(),string.charAt(i) | offset 
print_txt:
			ldy #string.size()
!:			lda str-1,y 
			sta (q1),Y 
			dey  
			bne !-

}

.function screen_at(row,column){
	.return screen_memory+[row*40]+column

}

.function color_at(row,column) {
	.return color_memory+[row*40]+column 
}

.function byte2bits(byte){
	.return byte*8; 
}

.function bits2byte(bits){
	.return bits/8;
}

.function is_next_line_bad(rasterline){
	.if (rasterline<50 || rasterline>242) {
		.return false 	
	}
	
	.if (mod(rasterline-50,8)==0) {
		.return true 	
	}
	.return false ;
}


.function toD018(screen,charset){
	.print "-----------------------------------------"
	.print "function toD018"
	.print "screen=$" + toHexString(screen/1024)
	.print "charset= $" + toHexString(charset/1024)
	.print "format 4 screen=$" + toHexString([screen/1024]<<4)
	.print "-----------------------------------------"
	.return screen2d018(screen) << 4 | screen2d018(charset) & %1111
}

.function screen2d018(screen)  {
	.return [screen & $3fff]/1024;
}

.macro background(color) {
	lda #color 
	sta background_color
}

.macro border(color) {
	lda #color
	sta border_color

}

.macro define_table(mytable) {
t0: .fill 2,0
.label flashing_color_table=mytable	
}

.macro ensureImmediatevalue(x) {
	.if (x.getType()!=AT_IMMEDIATE) {
		.error "not immediate value"
	}
}