const scriptMaker = () => [
    // -------------------- branding screen --------------------
    {
        type: 'scene',
        name: 'branding scene',
        start: 0,
        duration: 14,
        children: [
            {
                type: 'overlay',
                config: {
                    source: 'black'
                },
            },
            {
                type: 'overlay',
                config: {
                    position: [
                        [3, [0, -480], 'easeOutBounce'],
                        [5.5, [0, 0]],
                    ],
                    source: 'mikujingle_backround'
                },
            },
            {
                type: 'overlay',
                start: 6,
                config: {
                    source: 'mikujingle5-shadow-to-slide-down',
                    position: [
                        [2, [0, 0], 'easeInOutSine'],
                        [3, [0, 2]]
                    ],
                    alpha: [
                        [2, 0, 'easeInOutSine'],
                        [3, 1]
                    ]
                },
            },
            {
                type: 'overlay',
                start: 6,
                config: {
                    source: [
                        [0.0, ''],
                        [0.1, 'mikujingle1'],
                        [0.4, 'mikujingle2'],
                        [0.6, 'mikujingle3'],
                        [1.0, 'mikujingle4'],
                    ],
                    position: [
                        [2, [0, 0], 'easeInOutSine'],
                        [3, [0, -2]]
                    ],
                },
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    alpha: [
                        [13, 0],
                        [14, 1]
                    ],
                },
            },
        ]
    },

    // -------------------- MELLOW logo screen --------------------
    {
        type: 'scene',
        name: 'logo scene',
        enabled: true,
        start: 14,
        duration: 58,
        children: [
            {
                type: 'noise',
                config: {
                    strength: [
                        [10, 4],
                        [10.5, 0],
                        [23, 4],
                        [23.5, 0],
                        [38, 4],
                        [38.5, 0],
                        [52, 4],
                        [52.5, 0],
                    ],
                }
            },
            {
                type: 'noise',
                config: {
                    strength: [
                        [0, 0.0],
                        [4, .2],
                    ],
                    mode: [
                        [0, 'absolute', 'hold'],
                        [10, 'multiply', 'hold'],
                        [10.5, 'absolute', 'hold'],
                        [23, 'multiply', 'hold'],
                        [23.5, 'absolute', 'hold'],
                        [38, 'multiply', ,'hold'],
                        [38.5, 'absolute', ,'hold'],
                        [52, 'multiply', 'hold'],
                        [52.5, 'absolute', 'hold']
                    ]
                },
                syncs: {
                    strength: [
                        ['snare1', 1.2],
                        ['snare2', 1.5],
                    ]
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: [
                        [0, 4],
                        [58, 10],
                    ],
                    fov: 65,
                    lookAt: [0, 0, 0],
                    height: [
                        [0, -2],
                        [58, +2],
                    ],
                    roll: 0,
                    rotation: [
                        [0, 140],
                        [58, 860],
                    ]
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'additive',
                    clearDepthBuffer: true,
                    rasterMask: [
                        [13, 2, 'hold'],
                        [13.25, 7, 'hold'],
                        [13.5, 2, 'hold'],
                        [23, 2, 'hold'],
                        [23.25, 12, 'hold'],
                        [23.5, 2, 'hold'],
                        [28, 2, 'hold'],
                        [28.25, 5, 'hold'],
                        [28.5, 2, 'hold'],
                        [51.5, 4, 'hold'],
                        [52., 5, 'hold'],
                        [52.75, 12, 'hold'],
                        [53, 2, 'hold'],
                        [55.5, 12, 'hold'],
                        [55.75, 2, 'hold'],
                    ]
                }
            },
            {
                type: 'insideCylinder',
                config: {
                    brightness: [
                        [0, 0],
                        [8, 0.075],
                    ],
                    textureScale: [
                        [0, .1, 'easeOutSine'],
                        [9.7, 1],
                        [10, 3]
                    ],
                    texture: 'border'
                },
                syncs: {
                    brightness: [
                        ['basedrum', 1.5]
                    ]
                }
            },
            {
                type: 'depthFilter',
                config: {
                    edgeValue: 0.0,
                    stripeSize: 10,
                    stripeBrightness: 0.5,
                    decaySpeed: 0.005,
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'set',
                    colourField: 'gradientBlue'
                }
            },
            {
                type: 'clear',
                config: {
                }
            },
            {
                type: 'model',
                config: {
                    model: [
                        [0, 'MIKULOGO3'],
                        [23, 'MIKULOGO2'],
                        [38, 'MIKULOGO2_with-contour'],
                        [52, 'NINJA'],
                    ],
                    xRotation: 0,
                    yRotation: 180,
                    zRotation: 0,
                    scale: [
                        [9.7, [0, 20, 0], 'easeInSine'],
                        [10, [1, 1, 1]],

                        [23, [1, 1, 1], 'hold'],
                        [23.25, [1.5, .5, .5]],
                        [23.5, [1, 1, 1]],

                        [28, [1, 1, 1], 'hold'],
                        [28.25, [1.5, .5, .5]],
                        [28.5, [1, 1, 1]],

                        [56.7, [1, 1, 1]],
                        [57, [0, 20, 0], 'easeInSine'],
                    ],
                    translation: [
                        [0, [0, 0, 0], 'hold'],
                        [23, [0, 0, 0], 'hold'],
                        [38, [0.15, 0.1, 0.4], 'hold'],
                        [52, [0, 0, 0], 'hold'],
                    ],
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'fixBuffer',
                config: {
                    multiply: 1
                },
                syncs: {
                    multiply: [
                        ['basedrum', 1.05]
                    ]
                }
            },
            {
                type: 'distort',
                config: {
                    magnetDistance:[
                        [0, 3000, 'hold'],
                        [20, 500, 'hold'],
                    ],
                    strength: [
                        [10, 0, 'hold'],
                        [11, 2],
                        [12, 0, 'hold'],

                        [25, 0, 'hold'],
                        [26, 1, 'hold'],
                        [27, 0, 'hold'],

                        [45, 0, 'hold'],
                        [46, 2],
                        [49, 0, 'hold'],

                        [53, 1],
                        [55, 0],
                    ]
                }
            },
            {
                type: 'zoom',
                config: {
                    repeats: 4,
                    zoom: 1.3,
                    blend: [
                        [0, 0.0],
                        [40, 0.1],
                        [42, 0.2],
                        [46, 0.1],
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'add',
                    colourField: 'gradientOrange',
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'masks/YAS',
                    alpha: [
                        [0, 1, 'hold'],
                        [10, 0]
                    ],
                    scale: [
                        [0, 2],
                        [9, 1.1],
                        [10, 1]
                    ]
                },
            },
        ]
    },

    // -------------------- triangle field screen --------------------
    {
        type: 'scene',
        name: 'triangle field scene',
        start: 72,
        duration: 24,
        children: [
            {
                type: 'clear',
                config: {
                    value: 0.1
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'depth',
                    clearDepthBuffer: true,
                    rasterMask: 0,
                    nearDistance: 5,
                    farDistance: 13,
                    nearBrightness: .25,
                    farBrightness: 0.05,
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: 3,
                    fov: 80,
                    lookAt: [0, 0, 0],
                    roll: [
                        [0, -30],
                        [24, -40],
                    ],
                    rotation: [
                        [0, -50],
                        [24, -40],
                    ],
                    height: 7,
                }
            },
            {
                type: 'triangleField',
                config: {
                    brightness: [
                        [0, 3.0],
                    ],
                    border: 0.15,
                    gridSize: 25,
                    alternatePattern: true,
                    drawMode: [
                        [0, 'lines'],
                    ],
                    time1: [
                        [0, 0],
                        [24, 1],
                    ],
                    scale1: 0.175,
                    strength1: 1,
                    time2: [
                        [0, 0],
                        [24, -1],
                    ],
                    scale2: 0.05,
                    strength2: 3,
                    position: [
                        [0, [0, 0]],
                        [24, [0, 0]],
                    ]
                }
            },
            {
                type: 'blur',
                enabled: true,
                config: {
                    passes: 0,
                }
            },
            {
                type: 'fixBuffer',
                config: {
                    fixBorder: true
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'set',
                    colourField: 'gradientPurple2',
                    colourField2: 'white',
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    alpha: [
                        [0, 1, 'easeOutSine'],
                        [2, 0],
                        [22, 0, 'easeInSine'],
                        [24, 1],
                    ]
                }
            },
        ]
    },

    // -------------------- model tour screen --------------------
    {
        type: 'scene',
        name: 'model tour scene',
        start: 96,
        duration: 72,
        children: [
            {
                type: 'modelCam',
                config: {
                    model: 'STRUCTURE4_path',
                    upVector: [-1, 0, 0],
                    fromPathObjectName: 'camera',
                    fromPathSubObjectIndex: 0,
                    fromPosition: [
                        [0, 0],
                        [7, .03],
                        [72, .95]
                    ],
                    toPathObjectName: 'lookat',
                    toPathSubObjectIndex: 0,
                    toPosition: [
                        [0, 0],
                        [7, .034],
                        [72, 0.99]
                    ],
                    yaw: [
                        [60, 0, 'easeInOutSine'],
                        [72, -10]
                    ],
                    pitch: [
                        [60, 0, 'easeInOutSine'],
                        [72, -10]
                    ],
                    roll: [
                        [0, 0],
                        [72, 360]
                    ],
                    fov: [
                        [28, 60],
                        [31, 120],
                        [34, 60],
                        [60, 60],
                        [72, 75],
                    ],
                }
            },
            {
                type: 'brightSpot',
                config: {
                    brightness: [
                        [66, 0],
                        [72, 1],
                    ],
                    spotRange: .6,
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'additive',
                    rasterMask: 0,
                    nearDistance: 5,
                    farDistance: 22,
                    nearBrightness: [
                        [48, 1.25],
                        [68, 0.05],
                    ],
                    farBrightness: 0.1,
                    // originOffset: [-100, 0]
                }
            },
            {
                type: 'model',
                config: {
                    model: 'STRUCTURE4_tunnel',
                    excludeObjects: 'tunnel',
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'additive',
                    rasterMask: 0,
                    nearDistance: 5,
                    farDistance: 22,
                    nearBrightness: [
                        [24.5, 0.1, 'easeInSine'],
                        [25, 2.5, 'easeOutSine'],
                        [29, 1.0],
                        [36.5, 0.1, 'easeInSine'],
                        [37, 2.5, 'easeOutSine'],
                        [41, 1.0],
                        [48, 0.1, 'easeInSine'],
                        [49, 2.5, 'easeOutSine'],
                        [53, 1.0],
                    ],
                    farBrightness: 0.1,
                }
            },
            {
                type: 'model',
                config: {
                    model: 'STRUCTURE4_tunnel',
                    excludeObjects: 'wire_tunnel.003',
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 3,
                }
            },
            {
                type: 'remap',
                config: {
                    merge: [
                        [10, 0],
                        [12, 1],
                        [19, 1],
                        [20, 0]
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'set',
                    colourField: 'gradientPurple',
                    colourField2: 'gradientOrange',
                }
            },
            {
                type: 'clear',
                config: {
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'additive',
                    rasterMask: 1,
                    nearDistance: 20,
                    farDistance: 100,
                    nearBrightness: 1.0,
                    farBrightness: 0.01,
                }
            },
            {
                type: 'model',
                config: {
                    model: 'STRUCTURE4_surrounding',
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'add',
                    colourField: 'gradientBlue',
                }
            },
            {
                type: 'clear',
                config: {
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'depth',
                    clearDepthBuffer: true,
                    rasterMask: 0,
                    nearDistance: 1,
                    farDistance: [
                        [62, 5],
                        [62, 4],
                    ],
                    nearBrightness: [
                        [58, 0.85],
                        [60, 2.85],
                        [62, 0.85],
                    ],
                    farBrightness: [
                        [58, 0.1],
                        [60, 2.1],
                        [62, 0.1],
                    ],
                }
            },
            {
                type: 'model',
                config: {
                    model: 'STRUCTURE4_spike',
                    brightness: 1
                },
                syncs: {
                    brightness: [
                        ['basedrum', 2.1]
                    ]
                }
            },
            {
                type: 'present',
                start: 0,
                duration: 60,
                config: {
                    mode: 'add',
                    colourField: 'white',
                    colourField2: 'gradientOrange',
                }
            },
            {
                type: 'present',
                start: 60,
                config: {
                    mode: 'mask',
                    colourField: 'white',
                    colourField2: 'gradientOrange',
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'masks/moire_back',
                    alpha: [
                        [62, 0],
                        [63, 1],
                        [64, 0],
                        [65, 1],
                        [66, 0],
                        [67, 1],
                        [68, 0],
                    ]
                },
            },
            {
                type: 'overlay',
                start: 62,
                config: {
                    source: 'masks/BROUHAHA',
                    alpha: 1,
                    position: [
                        [62, [-6, 0]],
                        [72, [18, 0]]
                    ]
                },
            },
            {
                type: 'overlay',
                config: {
                    source: 'masks/tunnelvision'
                },
            },
            {
                type: 'overlay',
                config: {
                    source: 'masks/tunnelvision_accel_1',
                    alpha: [
                        [0, 'hold'],
                        [29, 0, 'easeInSine'],
                        [29.2, 1],
                        [31.5, 1, 'easeOutSine'],
                        [32, 0],
                    ]
                },
            },
            {
                type: 'overlay',
                config: {
                    source: 'masks/tunnelvision_accel_2',
                    alpha: [
                        [0, 'hold'],
                        [29.5, 0, 'easeInSine'],
                        [30, 1],
                        [31, 1, 'easeOutSine'],
                        [32, 0],
                    ]
                },
            },
        ]
    },

    // -------------------- raymarched marble scene --------------------
    {
        type: 'scene',
        name: 'raymarched marble scene',
        start: 168,
        duration: 27,
        children: [
            {
                type: 'presentImage',
                config: {
                    image: [
                        [0, 'backgrounds/marblelogo1'],
                        [12, 'backgrounds/marblelogo2'],
                    ]
                }
            },
            {
                type: 'brightSpot',
                config: {
                    brightness: 4.0,
                    spotRange: .8,
                    noiseGridSize: 20,
                    noiseScale: 0.0125,
                    noiseStrength: 0.025,
                    noisePosition: [
                        [0, 20],
                        [27, 33],
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'alpha',
                    colourField: 'gradientOrange',
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: [
                        [0, 60],
                        [27, 70]
                    ],
                    fov: 35,
                    lookAt: [0, 0, 0],
                    roll: [
                        [0, 0],
                        [27, -50],
                    ]
                }
            },
            {
                type: 'clear',
                config: {
                    value: 0.0
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'depth',
                    clearDepthBuffer: true,
                    rasterMask: 0,
                    nearDistance: 49,
                    farDistance: 77,
                    nearBrightness: 1.0,
                    farBrightness: 0.01,
                }
            },
            {
                type: 'metaballMarble',
                config: {
                    animation: [
                        [0, -5],
                        [27, -2],
                    ],
                    fieldSize: 17,
                    thickness: .2,
                    noiseScale: 0.075,
                    fieldStrength: [
                        [0.5, .825, 'easeOutSine'],
                        [4, .125]
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 0
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'mask',
                     // colours
                    colourField: 'gradientPurple',
                    // colourField: 'gradientPurple',
                    // colourField2: 'gradientBlue',
                }
            },
        ]
    },

    // -------------------- greets screen --------------------
    {
        type: 'scene',
        name: 'greets scene',
        start: 195,
        duration: 48,
        children: [
            {
                type: 'presentImage',
                config: {
                    image: 'backgrounds/greets'
                }
            },
            {
                type: 'scene',
                name: 'time-wrapper',
                config: {
                    time: [
                        [0, 0],

                        [3, 3],
                        [3.5, 3],

                        [6, 5.5],
                        [6.5, 5.5],

                        [8, 7],
                        [8.5, 7],
                        [9, 7.5],
                        [9.5, 7.5],
                        [10, 8.0],
                        [10.5, 8.0],

                        [12, 10.0],
                        [12.5, 10.0],

                        [15, 13.0],
                        [15.5, 13.0],

                        [18, 16.0],
                        [18.5, 16.0],

                        [27, 25.0],
                        [27.5, 25.0],

                        [30, 28.0],
                        [30.5, 28.0],

                        [32, 30.0],
                        [32.5, 30.0],
                        [33, 30.5],
                        [33.5, 30.5],
                        [34, 31.0],
                        [34.5, 31.0],

                        [36, 33.0],
                        [36.5, 33.0],

                        [48, 44.5],
                    ]
                },
                children: [
                    {
                        type: 'orbitCam',
                        config: {
                            distance: [
                                [0, 13, 'easeOutSine'],
                                [7, 14, 'easeOutSine'],
                                [17, 13, 'easeOutSine'],
                                [20, 12, 'easeOutSine'],
                                [25, 13, 'easeOutSine'],
                                [29, 15, 'easeOutSine'],
                                [37, 14, 'easeOutSine'],
                                [48, 13, 'easeOutSine'],
                            ],
                            fov: 30,
                            lookAt: [
                                [0, [-5, 0, 0]],
                                [48, [5, 0, 0]],
                            ],
                            rotation: [
                                [0, -15],
                                [48, +15],
                            ],
                            roll: [
                                [0, 10, 'easeOutSine'],
                                [5, 5, 'easeOutSine'],
                                [7, 10, 'easeOutSine'],
                                [17, -5, 'easeOutSine'],
                                [22, 3, 'easeOutSine'],
                                [31, -9, 'easeOutSine'],
                                [36, -2, 'easeOutSine'],
                                [40, 3, 'easeOutSine'],
                                [45, 7, 'easeOutSine'],
                                [48, 2, 'easeOutSine'],
                            ],
                            height: [
                                [0, 0.5, 'easeOutSine'],
                                [10, 0.2, 'easeOutSine'],
                                [17, 0.3, 'easeOutSine'],
                                [23, 0.7, 'easeOutSine'],
                                [35, 0.2, 'easeOutSine'],
                                [38, 0.5, 'easeOutSine'],
                                [40, 0.3, 'easeOutSine'],
                                [48, 0.5, 'easeOutSine'],
                            ]
                        }
                    },
                    {
                        type: 'clear',
                        config: {
                            value: [
                                [2.9, 0.0],
                                [3.0, 0.5],
                                [3.1, 0.0],

                                [5.4, 0.0],
                                [5.5, 0.5],
                                [5.6, 0.0],

                                [6.9, 0.0],
                                [7.0, 0.5],
                                [7.1, 0.0],

                                [7.4, 0.0],
                                [7.5, 0.5],
                                [7.6, 0.0],

                                [7.9, 0.0],
                                [8.0, 0.5],
                                [8.1, 0.0],
                                
                                [9.9, 0.0],
                                [10.0, 0.5],
                                [10.1, 0.0],
                                
                                [12.9, 0.0],
                                [13.0, 0.5],
                                [13.1, 0.0],
                                
                                [15.9, 0.0],
                                [16.0, 0.5],
                                [16.1, 0.0],
                                
                                [24.9, 0.0],
                                [25.0, 0.5],
                                [25.1, 0.0],
                                
                                [27.9, 0.0],
                                [28.0, 0.5],
                                [28.1, 0.0],
                                
                                [29.9, 0.0],
                                [30.0, 0.5],
                                [30.1, 0.0],
                                
                                [30.4, 0.0],
                                [30.5, 0.5],
                                [30.6, 0.0],
                                
                                [30.9, 0.0],
                                [31.0, 0.5],
                                [31.1, 0.0],
                                
                                [32.9, 0.0],
                                [33.0, 0.5],
                                [33.1, 0.0],
                            ]
                        }
                    },
                            {
                        type: 'renderState',
                        config: {
                            renderStyle: 'depth',
                            clearDepthBuffer: true,
                            rasterMask: 0,
                            nearDistance: 5,
                            farDistance: 37,
                            nearBrightness: 3.0,
                            farBrightness: 0.1,
                        }
                    },
                    {
                        type: 'greetsFlyBy',
                        config: {
                            yRotation: -90,
                        }
                    },
                    {
                        type: 'blur',
                        config: {
                            passes: 1,
                        }
                    },
                    {
                        type: 'present',
                        config: {
                            mode: 'mask',
                            // colours
                            colourField: 'greets_gradient',
                            //colourField: 'gradientOrange',
                        }
                    },
                    {
                        type: 'clear',
                        config: {
                            value: 0
                        }
                    },
                            {
                        type: 'renderState',
                        config: {
                            renderStyle: 'depth',
                            clearDepthBuffer: false,
                            rasterMask: 0,
                            nearDistance: 0,
                            farDistance: 8,
                            nearBrightness: 7.0,
                            farBrightness: 0.1,
                        }
                    },
                    {
                        type: 'model',
                        config: {
                            model: [
                                [2.75, 'BLACKMAIDEN'],
                                [5.25, 'BLASPHEMY'],
                                [6.75, 'BYPASS'],
                                [7.25, 'DESIRE'],
                                [7.75, 'HOLON'],
                                [9.75, 'ORANGE'],
                                [12.75, 'ORB'],
                                [15.75, 'PURPLE'],
                                [24.75, 'REPLAY'],
                                [27.75, 'RIBBON'],
                                [29.75, 'SONIK'],
                                [30.25, 'TPOLM'],
                                [30.75, 'UKSCENE'],
                                [32.75, 'MIKUCOM_THANKFUL'],
                            ],
                            yRotation: -90,
                            translation: [
                                [0, [0, 50, 0], 'hold'],

                                [2.75, [-1.75, 0, 7.0]],
                                [3.25, [-9.75, 0, 7.0]],
                                [3.25, [0, 50, 0], 'hold'],

                                [5.25, [-1.17, 0, 7.4]],
                                [5.75, [-9.17, 0, 7.4]],
                                [5.75, [0, 50, 0], 'hold'],

                                [6.75, [-0.50, 0, 7]],
                                [7.25, [-8.50, 0, 7]],
                                [7.25, [0, 50, 0], 'hold'],

                                [7.25, [-0.50, 0, 7]],
                                [7.75, [-8.50, 0, 7]],
                                [7.75, [0, 50, 0], 'hold'],

                                [7.75, [-0.80, 0, 8.5]],
                                [8.25, [-8.80, 0, 8.5]],
                                [8.25, [0, 50, 0], 'hold'],

                                [9.75, [+0.3, 0, 7]],
                                [10.25, [-7.7, 0, 7]],
                                [10.25, [0, 50, 0], 'hold'],

                                [12.75, [1.1, 0, 6.5]],
                                [13.25, [-6.9, 0, 6.5]],
                                [13.25, [0, 50, 0], 'hold'],

                                [15.75, [1.8, 0, 6.5]],
                                [16.25, [-6.2, 0, 6.5]],
                                [16.25, [0, 50, 0], 'hold'],

                                [24.75, [4.7, 0, 6.5]],
                                [25.25, [-4.3, 0, 6.5], 'hold'],
                                [25.25, [0, 50, 0]],

                                [27.75, [5.6, 0, 8]],
                                [28.25, [-3.4, 0, 8], 'hold'],
                                [28.25, [0, 50, 0]],

                                [29.75, [6.2, 0, 7.9]],
                                [30.25, [-2.8, 0, 7.9], 'hold'],
                                [30.25, [0, 50, 0]],

                                [30.25, [6.5, 0, 7.8]],
                                [30.75, [-2.5, 0, 7.8], 'hold'],
                                [30.75, [0, 50, 0]],
                                
                                [30.75, [6.6, 0, 8.2]],
                                [31.25, [-2.4, 0, 8.2], 'hold'],
                                [31.25, [0, 50, 0]],

                                [32.75, [7, 0, 7.4]],
                                [33., [2.6, 0, 7.4]],
                                [41.5, [4.5, 0, 6.2]],
                                [48., [18, 0, 6.2]],
                            ],
                        }
                    },
                    {
                        type: 'blur',
                        config: {
                            passes: 1
                        }
                    },
                    {
                        type: 'present',
                        config: {
                            mode: 'mask',
                            // colours
                            colourField2: 'white',
                            colourField: 'gradientPurple',
                            // colourField2: 'white',
                            // colourField: 'gradientBlue',
                        }
                    },
                ]
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    alpha: [
                        [0, 1, 'easeOutSine'],
                        [2, 0],
                        [45, 0, 'easeInSine'],
                        [48, 1],
                    ]
                }
            },
        ]
    },

    // -------------------- tunnel models screen --------------------
    {
        type: 'scene',
        name: 'tunnel models scene ',
        start: 243,
        duration: 45,
        children: [
            {
                type: 'presentImage',
                config: {
                    image: [
                        [0, 'backgrounds/mikutunnelmodel1'],
                        [10, 'backgrounds/mikutunnelmodel3'],
                        [21, 'backgrounds/mikutunnelmodel2'],
                    ]
                }
            },
            {
                type: 'orbitCam',
                name: 'camera 2',
                config: {
                    distance: [
                        [0, 35, 'easeInOutSine'],
                        [3, 30, 'easeOutSine'],
                        [6, 35, 'easeOutSine'],
                        //[8, 40, 'easeOutSine'],
                        //[9, 35, 'easeOutSine'],
                        [10, 30, 'easeOutSine'],
                        [16, 40, 'easeOutSine'],
                        [24, 30, 'easeInSine'],
                        [45, 50],
                    ],
                    fov: [
                        //[0, 60, 'easeInOutSine'],
                        [3, 20],
                    ],
                    lookAt: [
                        [0, [-2, 0, 0], 'easeInOutSine'],
                        [16, [0, -2, 2]],
                        [18, [0, -2, 2], 'easeInOutSine'],
                        [22, [0, 0, 0]],
                    ],
                    roll: [
                        [0, -25, 'easeInOutSine'],
                        [3, -12, 'easeInOutSine'],
                        [10, -10, 'easeInOutSine'],
                        [16, 10, 'easeInOutSine'],
                        [24, 13.5, 'easeInOutSine'],
                    ],
                    rotation: [
                        [0, -10, 'easeInOutSine'],
                        [10, 70, 'easeInOutSine'],
                        [16, 55, 'easeInOutSine'],
                        [24, 120, 'easeInOutSine'],
                    ],
                    height: [
                        [0, 20],
                        [24, -2],
                        [34, -4],
                    ]
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'depth',
                    clearDepthBuffer: true,
                    rasterMask: 0,
                    nearDistance: [
                        [18, 20],
                        [22, 5],
                    ],
                    farDistance: 70,
                    nearBrightness: 8.0,
                    farBrightness: 1.5,
                    originOffset: [
                        [0, [-200,0], 'easeOutSine'],
                        [2, [0,0]],
                        [24, [0,0], 'easeInOutSine'],
                        [45, [0,30]],
                    ]
                }
            },
            {
                type: 'clear',
                config: {
                }
            },
            {
                type: 'modelTunnel',
                name: 'main',
                config: {
                    distance: [
                        [0, 100],
                        [21, 100, 'easeInOutSine'],
                        [24, 96],
                        [45, 115],
                    ],
                    startDepth: 0,
                    repeatCount: [
                        [0, 0],
                        [3, 1],
                        [6, 2],
                        [8, 3],
                        [9, 4],
                        [10, 5],
                        [24, 6],
                    ],
                    componentDepth: 2.3,
                    models: 'TRYNABSTRACT_new',
                    excludeObjects: 'wire',
                    rotationMod: [
                        [0, 100, 'easeOutSine'],
                        [3, 30],
                    ],
                },
                syncs: {
                    rotationMod: [
                        ['basedrum', 1.05]
                    ]
                }
            },
            {
                type: 'depthFilter',
                config: {
                    edgeValue: 0.0,
                    stripeSize: 10,
                    stripeBrightness: [
                        [6, 0.75],
                        [24, 0.5],
                    ],
                    nonStripeBrightness: 0.75,
                    decaySpeed: 0.0025,
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 3,
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'mask',
                    colourField: 'gradientPurple',
                    colourField2: 'gradientOrange',
                }
            },
            {
                type: 'clear',
                config: {
                }
            },
            {
                type: 'modelTunnel',
                name: 'echo',
                config: {
                    distance: [
                        [0, 100],
                        [21, 100, 'easeInOutSine'],
                        [24, 96],
                        [45, 115],
                    ],
                    startDepth: 0,
                    repeatCount: 6,
                    componentDepth: 2.3,
                    models: 'TRYNABSTRACT_new',
                    excludeObjects: 'cube',
                    rotationMod: 30,
                    depthBias: -0.2
                },
                syncs: {
                    rotationMod: [
                        ['basedrum', 1.05]
                    ]
                }
            },
            {
                type: 'fixBuffer',
                config: {
                    multiply: [
                        [24, 0.0],
                        [30, 0.2],
                    ],
                    fixBorder: true
                },
                syncs: {
                    multiply: [
                        ['snare1', 2],
                        ['snare2', 2],
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2,
                },
                syncs: {
                    passes: [
                        ['snare1', 3],
                        ['snare2', 3],
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'add',
                    colourField: 'white',
                    colourField2: 'white',
                }
            },
        ]
    },

    // -------------------- triangle field screen --------------------
    {
        type: 'scene',
        name: 'triangle field scene',
        start: 288,
        duration: 6,
        children: [
            {
                type: 'clear',
                config: {
                    value: 0.1
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'depth',
                    clearDepthBuffer: true,
                    rasterMask: 0,
                    nearDistance: 0,
                    farDistance: 10,
                    nearBrightness: 0.75,
                    farBrightness: 0.125,
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: 3,
                    fov: 80,
                    lookAt: [0, 0, 0],
                    roll: [
                        [0, -20],
                        [60, +20],
                    ],
                    rotation: [
                        [0, -20],
                        [60, +20],
                    ],
                    height: 7,
                }
            },
            {
                type: 'triangleField',
                config: {
                    brightness: [
                        [0, 3.0],
                    ],
                    border: 0.15,
                    gridSize: 25,
                    alternatePattern: true,
                    drawMode: [
                        [0, 'lines'],
                    ],
                    time1: [
                        [0, 2],
                        [60, -1],
                    ],
                    scale1: 0.075,
                    strength1: 3,
                    time2: [
                        [0, 0],
                        [60, 1],
                    ],
                    scale2: 0.05,
                    strength2: 2,
                    position: [
                        [0, [0, 0]],
                        [60, [4, 0]],
                    ]
                }
            },
            {
                type: 'blur',
                enabled: true,
                config: {
                    passes: 0,
                }
            },
            {
                type: 'fixBuffer',
                //enabled: false,
                config: {
                    fixBorder: true
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'set',
                    colourField: 'gradientPurple',
                    colourField2: 'white',
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    alpha: [
                        [0, 1, 'easeOutSine'],
                        [2, 0],
                        [4, 0, 'easeInSine'],
                        [6, 1],
                    ]
                }
            },
        ]
    },

    // -------------------- spikeball screen --------------------
    {
        type: 'scene',
        name: 'spikeball scene ',
        start: 294,
        duration: 32,
        children: [
            {
                type: 'orbitCam',
                config: {
                    distance: [
                        [30, 5, 'easeInOutSine'],
                        [31, 3.6, 'easeInSine'],
                        [32, 3.92],
                    ],
                    fov: 80,
                    lookAt: [0, 0, 0],
                    height: [
                        [0, -1],
                        [32, 0],
                    ],
                    roll: [
                        [0, -10, 'easeInOutSine'],
                        [32, 20],
                    ],
                    rotation: [
                        [0, 0],
                        [32, 180],
                    ]
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'depth',
                    clearDepthBuffer: true,
                    rasterMask: 0,
                    nearDistance: 1,
                    farDistance: 4.5,
                    nearBrightness: [
                        [28, 1.3, 'easeInSine'],
                        [32, 3],
                    ],
                    farBrightness: 0.1,
                    originOffset: [
                        [0, [-600, 0], 'easeOutSine'],
                        [2, [0, 0]],
                        [32, [2, 3]],
                    ]
                }
            },
            {
                type: 'clear',
                config: {
                    value: 0
                }
            },
            {
                type: 'insideCylinder',
                enabled: true,
                config: {
                    brightness: [
                        [0, 1.0, 'easeInSine'],
                        [32, 0],
                    ],
                    textureRepeats: 1,
                    textureScale: 3,
                    texture: 'gradient' 
                },
                syncs: {
                    brightness: [
                        ['basedrum', 1.5]
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 5
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'set',
                    colourField: 'gradientGreen',
                }
            },
            {
                type: 'presentImage',
                start: 25.5,
                config: {
                    image: [
                        [0, 'backgrounds/mikuballs-1'],
                        [2.5, 'backgrounds/mikuballs-2'],
                        [3.5, 'backgrounds/mikuballs-3'],
                        [4.5, 'backgrounds/mikuballs-4'],
                    ]
                }
            },
            {
                type: 'clear',
                config: {
                    value: 0
                }
            },
            {
                type: 'spikeBall',
                config: {
                    model1: 'icosphere1',
                    model2: 'icosphere2',

                    bump1: 0,
                    brightness1: 1.8,

                    bump2: [
                        [0, 0.0, 'hold'],
                        [13, 0.1, 'hold'],
                        [22, 0.1],
                        [24, 0.0],
                    ],
                    brightness2: [
                        [0, 1.0, 'hold'],
                        [13, 5000, 'hold'],
                        [20, 5000, 'hold'],
                        [23.5, 2.8],
                        [32, 1.8],
                    ],

                    animation: [
                        [0, 2],
                        [4, 0],
                        [8, 0],
                        [12, 10],
                        [16, 4],
                        [20, 2],
                        [24, 8],
                        [28, 5],
                        [32, 8],
                    ],
                    xRotation: [
                        [0, 30],
                        [12, -50],
                        [32, -23]
                    ],
                    yRotation: [
                        [0, 0],
                        [32, 223]
                    ],
                    zRotation: 90,
                    scale: [2, 2, 2],
                    extendMin: [
                        [0, 0.6],
                        [4, 0.6],
                        [8, 0.6],
                        [12, 0.1],
                        [16, 1.5],
                        [20, 0.3],
                        [31.5, 1.0],
                    ],
                    extendMax: [
                        [0, 1.5],
                        [4, 1.5],
                        [8, 1.5],
                        [12, 1.25],
                        [16, 0.5],
                        [20, 1.2],
                        [31.5, 1.0],
                    ],
                    powA: [
                        [0, 5.3],
                        [4, 2.3],
                        [8, 2.3],
                        [12, 5.0],
                        [16, 1.3],
                        [20, 1.3],
                        [24, 3.3],
                        [28, 1.3],
                    ],
                    powB: [
                        [0, 0.6],
                        [3, 0.6, 'easeOutBounce'],
                        [6, 0.1],
                        [8, 0.1],
                        [12, 0.75],
                        [24, 0.75],
                        [28, 2.75],
                    ],
                    dScale: [
                        [0, 2.5],
                        [4, 2.5],
                        [8, 2.5],
                        [12, 0.7],
                        [16, 0.7],
                        [20, 1.8],
                    ],
                    attractorStrength1: [
                        [0, 1],
                        [20, 1.5],
                        [30, 0],
                    ],
                    attractorStrength2: [
                        [0, 1],
                        [4, 0],
                        [8, 0],
                        [30, 2.5],
                        [31.5, 0.0],
                    ]
                }
            },
            {
                type: 'blur',
                start: 25.5,
                config: {
                    passes: 1
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'mask',
                    colourField: [
                        // colours
                        [0.0,'gradientPurple2'],
                        [4.0,'white'],
                        [8.0,'gradientPurple2']
                        // [0.0,'gradientOrange'],
                        // [4.0,'white'],
                        // [8.0,'gradientOrange']
                    ]
                }
            },
        ]
    },

    // -------------------- raymarched objects scene --------------------
    {
        type: 'scene',
        name: 'raymarched objects scene',
        start: 326,
        duration: 28,
        children: [
            {
                type: 'presentImage',
                config: {
                    image: [
                        [0, 'backgrounds/mikuballs-4'],

                        [8, 'backgrounds/mikuballs-5'],
                        [10, 'backgrounds/mikuballs-6'],
                        [12, 'backgrounds/mikuballs-7'],
                        [16, 'backgrounds/mikuballs-8'],
                    ]
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: [
                        [0, 47, 'easeOutSine'],
                        [1, 55],
                    ],
                    fov: 30,
                    lookAt: [0, 1, 0],
                    roll: 0,
                    rotation: [
                        [0, 40],
                        [28, 96],
                    ]
                }
            },
            {
                type: 'clear',
                config: {
                    value: 0.0
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'depth',
                    clearDepthBuffer: true,
                    rasterMask: 0,
                    nearDistance: [
                        [0, 50, 'easeOutSine'],
                        [4, 30],
                    ],
                    farDistance: 60,
                    nearBrightness: [
                        [0, 100, 'easeOutSine'],
                        [8, 60],
                    ],
                    farBrightness: 5.0,
                    originOffset: [
                        [0, [-17, -11], 'easeOutSine'],
                        [4, [0, 0]],
                    ]
                }
            },
            {
                type: 'metaballRay',
                config: {
                    animation: [
                        [0, 0.32],
                        [23, 3],
                        [28, 2.5],
                    ],
                    fieldStrength: [
                        [8, 1.8],
                        [16, 0.7],
                        [20, 0.7],
                        [27, 1.2],
                    ],
                    blendFactor: [
                        [0.0, 1.8],
                        [1.5, 13],
                        [13.5, 13],
                        [14.5, 1],
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2,
                }
            },
            {
                type: 'distort',
                config: {
                    brightness: 0,
                    distortDistance: 10,
                    strength: [
                        [22.75, 0],
                        [23, 3],
                        [24, 0, 'hold'],
                        [27.5, 2, 'hold'],
                        [28, 0, 'hold'],
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'mask',
                    // colours
                    colourField: 'gradientPurple2'
                    // colourField: 'gradientOrange'
                }
            },
        ]
    },

    // -------------------- triangle field screen --------------------
    {
        type: 'scene',
        name: 'triangle field scene',
        start: 354,
        duration: 112,
        config: {
            time: [
                [0, 0],
                [17, 16.75, 'easeOutSine'],
                [17.5, 21.5, 'easeOutSine'],
                [18, 25, 'easeOutSine'],
                [18.25, 30],
                [19, 30],
                [22, 35],
                [22, 36],
                [23.25, 37],
                [23.25, 38],
                [31, 45],
                [31, 46],
                [164, 164],
            ]
        },
        children: [
            {
                type: 'clear',
                config: {
                    value: [
                        [14.75, 0.0],
                        [14.75, 0.1],
                    ]
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'depth',
                    clearDepthBuffer: true,
                    rasterMask: 0,
                    nearDistance: 3,
                    farDistance: 12,
                    nearBrightness: 3,
                    farBrightness: 0.25,
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: 3,
                    fov: 80,
                    lookAt: [0, 0, 0],
                    roll: [
                        [0, -20],
                        [120, +60],
                    ],
                    rotation: [
                        [0, -20],
                        [120, +60],
                    ],
                    height: 7,
                }
            },
            {
                type: 'triangleField',
                config: {
                    brightness: [
                        [0, 3.0],
                        [14.75, 0.1],
                        [15.1, 0.6],
                        [30, 0.15],
                        [30.125, 0.6],
                    ],
                    border: 0.15,
                    gridSize: 25,
                    alternatePattern: true,
                    drawMode: [
                        [0, 'lines'],
                        [14.75, 'tris'],
                    ],
                    time1: [
                        [0, 0],
                        [120, 4],
                    ],
                    scale1: 0.075,
                    strength1: 3,
                    time2: [
                        [0, 0],
                        [120, -2],
                    ],
                    scale2: 0.05,
                    strength2: 2,
                    position: [
                        [0, [0, 0]],
                        [120, [-8, 0]],
                    ]
                }
            },
            {
                type: 'blur',
                enabled: true,
                config: {
                    passes: 0,
                }
            },
            {
                type: 'depthFilter',
                enabled: true,
                start: 14.75,
                config: {
                    edgeValue: 0.0,
                    stripeSize: 2,
                    stripeBrightness: 1.5,
                    decaySpeed: 0.02,
                }
            },
            {
                type: 'blur',
                enabled: true,
                start: 14.75,
                config: {
                    passes: [ 
                        [32.05, 2],
                        [36.05, 8],
                    ]
                }
            },
            {
                type: 'fixBuffer',
                config: {
                    fixBorder: true,
                    multiply: [ 
                        [46.8, 1],
                        [50.8, 0.2],
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'set',
                    colourField: 'gradientPurple2',
                    colourField2: 'gradientOrange',
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'text-line',
                    alpha: [
                        [0, 0],
                        [2, .5],
                        [14.75, .5],
                        [15.00, 0]
                    ]
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'finaltext1',
                    alpha: [
                        [2, 0],
                        [4, 1],
                        [6, 0],
                    ],
                    position: [
                        [2, [0, 0]], 
                        [6, [-15, 0]], 
                    ]
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'finaltext2',
                    alpha: [
                        [5, 0],
                        [7, 1],
                        [9, 0],
                    ],
                    position: [
                        [5, [0, 0]], 
                        [9, [-15, 0]], 
                    ]
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'finaltext3',
                    alpha: [
                        [8, 0],
                        [10, 1],
                        [12, 0],
                    ],
                    position: [
                        [8, [0, 0]], 
                        [12, [-15, 0]], 
                    ]
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'finaltext4',
                    alpha: [
                        [11, 0],
                        [13, 1],
                        [14.75, 1],
                        [15.00, 0],
                    ],
                    position: [
                        [11, [0, 0]], 
                        [16, [-15, 0]], 
                    ]
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'yas-border-background',
                    alpha: [
                        [30, 0],
                        [31, 1],
                        [33.4, 1],
                        [34.4, 0],
                    ],
                }
            },
            {
                type: 'overlay',
                config: {
                    source: [
                        [30, '', 'hold'],
                        [31.2, 'yas-border-text2'],
                        [31.6, 'yas-border-text3'],
                        [32, 'yas-border-text4'],
                        [32.4, 'yas-border-text2'],
                        [32.8, 'yas-border-text3'],
                        [33.2, 'yas-border-text4'],
                        [33.6, 'yas-border-text1'],
                    ],
                    alpha: [
                        [31, 0],
                        [32, 1],
                        [33.4, 1],
                        [34.4, 0],
                    ],
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'yas-border-top-bottom',
                    position: [
                        [30, [0, -600]],
                        [30.5, [0, 0]],
                    ],
                    alpha: [
                        [30, 0],
                        [30.5, 1],
                        [33.2, 1],
                        [34.2, 0],
                    ],
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'yas-border-bottom-top',
                    position: [
                        [30, [0, 480]],
                        [30.5, [0, 0]],
                    ],
                    alpha: [
                        [30, 0],
                        [30.5, 1],
                        [33.2, 1],
                        [34.2, 0],
                    ],
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'yas-border-left-right',
                    position: [
                        [30, [-640, 0]],
                        [30.5, [0, 0]],
                    ],
                    alpha: [
                        [30, 0],
                        [30.5, 1],
                        [33.2, 1],
                        [34.2, 0],
                    ],
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'yas-border-right-left',
                    position: [
                        [30, [640, 0]],
                        [30.5, [0, 0]],
                    ],
                    alpha: [
                        [30, 0],
                        [30.5, 1],
                        [33.2, 1],
                        [34.2, 0],
                    ],
                }
            }
        ]
    },
    {
        type: 'scene',
        name: 'ending logo scene',
        enabled: true,
        start: 390,
        duration: 56,
        children: [
            {
                type: 'clear',
                config: {
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: 10,
                    fov: 55,
                    lookAt: [0, 0, 0],
                    height: [
                        [0, 0.5],
                        [58, -0.5],
                    ],
                    roll: 0,
                    rotation: [
                        [0, -90],

                        [4, -90],
                        [5, 270],
                        [5, -90],

                        [10, -90],
                        [11, 270],
                        [11, -90],

                        [14, -90],
                        [15, 270],
                        [15, -90],

                        [20, -90],
                        [21, 270],
                        [21, -90],

                        [24, -90],
                        [25, 270],
                        [25, -90],

                        [30, -90],
                        [31, 270],
                        [31, -90],

                        [34, -90],
                        [35, 270],
                        [35, -90],

                        [40, -90],
                        [41, 270],
                        [41, -90],

                        [44, -90],
                        [45, 270],
                        [45, -90],

                        [50, -90],
                        [51, 270],
                        [51, -90],
                    ]
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'additive',
                    clearDepthBuffer: true,
                    rasterMask: [
                        [13, 2, 'hold'],
                        [13.25, 7, 'hold'],
                        [13.5, 2, 'hold'],
                        [23, 2, 'hold'],
                        [23.25, 12, 'hold'],
                        [23.5, 2, 'hold'],
                        [28, 2, 'hold'],
                        [28.25, 5, 'hold'],
                        [28.5, 2, 'hold'],
                        [51.5, 4, 'hold'],
                        [52., 5, 'hold'],
                        [52.75, 12, 'hold'],
                        [53, 2, 'hold'],
                        [55.5, 12, 'hold'],
                        [55.75, 2, 'hold'],
                    ],
                    originOffset: [0, 0],
                    nearBrightness: 0.75,
                    farBrightness: 0.1,
                }
            },
            {
                type: 'model',
                config: {
                    model: "MIKULOGO4",
                    xRotation: 0,
                    yRotation: 180,
                    zRotation: 0,
                    scale: [
                        [0.3, [0, 20, 0], 'easeInSine'],
                        [.5, [1, 1, 1]],
                    ],
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 1
                }
            },
            {
                type: 'distort',
                config: {
                    magnetDistance: 500,
                    strength: [
                        [0, 0, 'hold'],
                        [1, 2],
                        [2, 0, 'hold'],
                        [30, 0, 'hold'],
                        [31, 3],
                        [33, 0, 'hold'],
                        [43, 0, 'hold'],
                        [44, 2],
                        [45, 0, 'hold'],
                    ]
                }
            },
            {
                type: 'noise',
                config: {
                    mode: 'additive',
                    strength: [
                        [0, 0],
                        [4, .2],
                    ]
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'add',
                    // colours
                    colourField: 'gradientPurple'
                    // colourField: 'gradientBlue'
                }
            },
            {
                type: 'overlay',
                config: {
                    source: 'miku_thankful',
                    alpha: [
                        [4, 0],
                        [12, 1],
                    ]
                },
            },
            {
                type: 'overlay',
                config: {
                    source: 'black',
                    alpha: [
                        [35, 0],
                        [44, 1],
                    ],
                },
            },
        ]
    },

    // -------- deleted scenes

    // -------------------- line test screen --------------------
    {
        type: 'scene',
        name: 'line test scene',
        start: 11400,
        duration: 48,
        children: [
            {
                type: 'brightSpot',
                config: {
                    brightness: 0.3,
                    noiseGridSize: 20,
                    noiseScale: 0.05,
                    noiseStrength: 2,
                    noisePosition: [
                        [0, 10],
                        [48, 18],
                    ],
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 2
                }
            },
            {
                type: 'present',
                config: {
                    colourField: 'tunnel'
                }
            },
            {
                type: 'clear',
                config: {
                    value: 0.
                }
            },
            {
                type: 'orbitCam',
                config: {
                    distance: 2,
                    fov: 80,
                    lookAt: [0, 0, 0],
                    roll: [
                        [0, 150, 'easeInSine'],
                        [4, 20, 'easeInSine'],
                        [8, 100, 'easeInSine'],
                        [12, 80, 'easeInSine'],
                        [16, 200, 'easeInSine'],
                        [20, 40, 'easeInSine'],
                        [24, 160, 'easeInSine'],
                        [28, 40, 'easeInSine'],
                        [32, 120, 'easeInSine'],
                        [36, 20, 'easeInSine'],
                        [40, 80, 'easeInSine'],
                        [44, 120, 'easeInSine'],
                        [48, 50, 'easeInSine'],
                    ],
                    rotation: [
                        [0, 150, 'easeInSine'],
                        [4, 20, 'easeInSine'],
                        [8, 100, 'easeInSine'],
                        [12, 80, 'easeInSine'],
                        [16, 20, 'easeInSine'],
                        [20, 40, 'easeInSine'],
                        [24, 60, 'easeInSine'],
                        [28, 40, 'easeInSine'],
                        [32, 120, 'easeInSine'],
                        [36, 100, 'easeInSine'],
                        [40, 80, 'easeInSine'],
                        [44, 120, 'easeInSine'],
                        [48, 50, 'easeInSine'],
                    ],
                }
            },
            {
                type: 'renderState',
                config: {
                    renderStyle: 'additive',
                    rasterMask: 0,
                }
            },
            {
                type: 'lineTest',
                config: {
                    lineBrightness: [
                        [0, 10],
                        [48, 1.5],
                    ],
                    quadBrightness: [
                        [0, 0.2],
                        [48, 0.5],
                    ],
                    scale: [
                        [0, 2],
                        [4, 1],
                        [4, 2],
                        [8, 1],
                        [8, 2],
                        [12, 1],
                        [12, 2],
                        [16, 1],
                        [16, 2],
                        [20, 1],
                        [20, 2],
                        [24, 1],
                        [24, 2],
                        [28, 1],
                        [28, 2],
                        [32, 1],
                        [32, 2],
                        [36, 1],
                        [36, 2],
                        [40, 1],
                        [40, 2],
                        [44, 1],
                        [44, 2],
                        [48, 1],
                    ],
                    subdivisions: [
                        [0, 1, 'hold'],
                        [4, 2, 'hold'],
                        [8, 1, 'hold'],
                        [12, 3, 'hold'],
                        [16, 1, 'hold'],
                        [20, 4, 'hold'],
                        [24, 3, 'hold'],
                        [28, 1, 'hold'],
                        [32, 1, 'hold'],
                        [36, 2, 'hold'],
                        [40, 1, 'hold'],
                        [44, 3, 'hold'],
                        [48, 1, 'hold'],
                    ],
                    style: [
                        [0, 0, 'hold'],
                        [4, 1, 'hold'],
                        [8, 0, 'hold'],
                        [12, 2, 'hold'],
                        [16, 1, 'hold'],
                        [20, 2, 'hold'],
                        [24, 0, 'hold'],
                        [28, 2, 'hold'],
                        [32, 0, 'hold'],
                        [36, 1, 'hold'],
                        [40, 2, 'hold'],
                        [44, 1, 'hold'],
                        [48, 0, 'hold'],
                    ],
                    shell: [
                        [0, 0, 'hold'],
                        [4, 1, 'hold'],
                        [8, 0, 'hold'],
                        [12, 1, 'hold'],
                        [16, 1, 'hold'],
                        [20, 0, 'hold'],
                        [24, 1, 'hold'],
                        [28, 1, 'hold'],
                        [32, 1, 'hold'],
                        [36, 0, 'hold'],
                        [40, 0, 'hold'],
                        [44, 1, 'hold'],
                        [48, 1, 'hold'],
                    ]
                }
            },
            {
                type: 'blur',
                config: {
                    passes: 5
                }
            },
            {
                type: 'present',
                config: {
                    mode: 'mask',
                    colourField: 'gradientPurple2'
                }
            },
        ]
    },

    // -------- debug/test scenes

    // -------------------- music part name overlays --------------------
    {
        type: 'debugText',
        name: 'music part name overlays',
        enabled: false,
        config: {
            text: [
                [0, 'JINGLE'], 
                [12, 'INTRO'], 
                [24, 'PRE'], 
                [72, 'BASS'], 
                [120, 'ARP'], 
                [168, 'BREAK INTRO'], 
                [192, 'BREAK FIRST'], 
                [240, 'BREAK SECOND'], 
                [288, 'SILENCE'], 
                [294, 'REPRISE'], 
                [342, 'OUTRO'], 
                [390, 'TADA'], 
            ]
        }
    }
]
