'use strict'

modules['dotCube'] = {
    config: [
        ['width', 'int', 1],
        ['spacing', 'float', 10],
        ['brightness', 'float', 0.2],
        ['dotSize', 'float', 0.5],
        ['warpPos', 'float3', 0.0],
        ['texture', 'string', 'ball'],
    ],

    render: async (time, self, config) => {
        const {
            width,
            spacing,
            brightness,
            dotSize,
            warpPos,
            texture,
        } = { ...config }
        const halfSize = width

        const balls3d = []
        for (let x = -halfSize; x <= halfSize; ++x) {
            const sx = x * spacing
            for (let y = -halfSize; y <= halfSize; ++y) {
                const sy = y * spacing
                for (let z = -halfSize; z <= halfSize; ++z) {
                    const sz = z * spacing
                    const size = 1 + (Math.abs(Math.sin(warpPos[0] + y*0.1)) * 0.5 + Math.abs(Math.sin(warpPos[1] + x*0.1)) * 0.5 + Math.abs(Math.sin(warpPos[2] + z*0.1)) * 0.5)
                    balls3d.push([[sx, sy, sz, 1], brightness, size * dotSize])
                }
            }
        }

        const balls2d = transformBalls(balls3d)
        drawBalls(balls2d, texture)
    }
}
