'use strict'

modules['dotSphere'] = {
    config: [
        ['offsetSize', 'float', 20],
        ['innerSize', 'float', 50],
        ['offsetPosition', 'float', 0],
        ['brightness', 'float', 1],
        ['spriteSize', 'float', 1],
        ['texture', 'string', 'default'],
    ],

    init: () => {
        const BALL_COUNT = 1000
        const balls = []
        const ballRng = new Math.seedrandom('balls')
        for (let b = 0; b < BALL_COUNT; ++b) {
            balls.push(randomNormal(ballRng))
        }
        return {
            BALL_COUNT,
            balls
        }
    },

    render: async (time, self, config) => {
        const {
            offsetSize,
            innerSize,
            offsetPosition,
            brightness,
            spriteSize,
            texture,
        } = { ...config }

        const balls3d = []
        for (let b = 0; b < self.BALL_COUNT; ++b) {
            const ba = b / self.BALL_COUNT
            const of = Math.pow(Math.max(0, Math.sin(offsetPosition + ba * Math.PI * 2)), 4)
            const bd = innerSize + of * offsetSize
            const dotSize = 1 - of
            let [sx, sy, sz] = self.balls[b]
            sx *= bd
            sy *= bd
            sz *= bd
            balls3d.push([[sx, sy, sz, 1], brightness, spriteSize * dotSize])
        }

        const balls2d = transformBalls(balls3d)
        drawBalls(balls2d, texture)
    }
}
