'use strict'

function getIso2 (x, y, z, t, fieldSize, thickness, noiseScale) {
    const iso1 = getIsoSphere([x, y, z], fieldSize-1)
    const iso2 = getIsoSphere([x, y, z], (fieldSize-1) * thickness)
    const iso3 = noise.simplex3(t+x*noiseScale, t-y*noiseScale, t+z*noiseScale)
    return Math.max(Math.max(iso1, -iso2), -iso3)
}

modules['metaballMarble'] = {
    config: [
        ['animation', 'float', 0],
        ['fieldSize', 'int', 10],
        ['thickness', 'float', 0.1],
        ['noiseScale', 'float', 0.1],
        ['fieldStrength', 'float', 1],
    ],
  
    render: async (time, self, config) => {
        const {
            animation,
            fieldSize,
            thickness,
            noiseScale,
            fieldStrength,
        } = { ...config }

        const isoField = makeIsoField(fieldSize, (x, y, z) => getIso2(x, y, z, animation, fieldSize, 1 - thickness, noiseScale))
        const lists = renderIsoField(fieldSize, isoField, fieldStrength, 'tris')
        renderer.drawLists(greyscaleBuffers[getOutputBufferId()], m4.identity(), lists.verts, lists.lines, 1, lists.tris, 1, [], 1)
    }
}
