'use strict'

modules['model'] = {
    config: [
        ['model', 'model', ''],
        ['excludeObjects', 'string', ''],
        ['scale', 'float3', [1, 1, 1]],
        ['translation', 'float3', [0, 0, 0]],
        ['xRotation', 'angle', 0],
        ['yRotation', 'angle', 0],
        ['zRotation', 'angle', 0],
        ['brightness', 'float', 1],
    ],

    render: async (time, self, config) => {
      const {
          model,
          excludeObjects,
          scale,
          translation,
          xRotation,
          yRotation,
          zRotation,
          brightness,
      } = { ...config }

      const buffer = greyscaleBuffers[getOutputBufferId()]

      const excludeObjectArray = excludeObjects.split(',')

      const xRotationMat = m4.xRotation(xRotation)
      const yRotationMat = m4.yRotation(yRotation)
      const zRotationMat = m4.zRotation(zRotation)
      const scaleMat = m4.scaling(scale[0], scale[1], scale[2])
      const translationMat = m4.translation(translation[0], translation[1], translation[2])
      const modelMat = m4.multiply(translationMat, m4.multiply(scaleMat, m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat)))
      
      const trans = m4.translation(0, 0, 0)
      const worldMat = m4.multiply(trans, modelMat)
      renderer.drawModel(buffer, worldMat, model, excludeObjectArray, brightness)
    }
}
