'use strict'

modules['noise'] = {
    config: [
        ['strength', 'float', 1],
        ['mode', 'string', 'absolute'],
    ],

    render: async (time, self, config) => {
        const {
            strength,
            mode,
        } = { ...config }

        const greyscaleBuffer = greyscaleBuffers[getOutputBufferId()]
        if (mode === 'absolute') {
            for (let i = 0; i < 640 * 480; ++i) {
                greyscaleBuffer[i] = Math.random() * strength
            }
        } else if (mode === 'additive') {
            for (let i = 0; i < 640 * 480; ++i) {
                greyscaleBuffer[i] += Math.random() * strength
            }
        } else if (mode === 'multiply') {
            for (let i = 0; i < 640 * 480; ++i) {
                greyscaleBuffer[i] *= Math.random() * strength
            }
        }
    }
}
